/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.js;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Format {
    private Map<String, Locale> m_Locales = new HashMap<String, Locale>();
    private Map<String, SimpleDateFormat> m_DateFormats = new HashMap<String, SimpleDateFormat>();
    private DecimalFormat m_NumberFormat = (DecimalFormat)NumberFormat.getNumberInstance();
    private DecimalFormat m_CurrencyFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
    private DecimalFormat m_PercentFormat = (DecimalFormat)NumberFormat.getPercentInstance();

    public Format() {
        DecimalFormatSymbols decimalFormatSymbols = this.m_NumberFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setNaN("NaN");
        this.m_NumberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.m_CurrencyFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.m_PercentFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    public String padLeftAligned(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(0, n);
        }
        if (n2 == n) {
            return string;
        }
        return string + this.spaces(n - n2);
    }

    public String padRightAligned(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(0, n);
        }
        if (n2 == n) {
            return string;
        }
        return this.spaces(n - n2) + string;
    }

    public String padCenterAligned(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            int n3 = (n2 - n) / 2;
            return string.substring(n3, n3 + n);
        }
        if (n2 == n) {
            return string;
        }
        int n4 = (n - n2) / 2;
        return this.spaces(n4) + string + this.spaces(n - n4 - n2);
    }

    public String spaces(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String format(Object object, String string) {
        if (object == null) {
            return "";
        }
        if (object instanceof Number) {
            return this.formatNumber((Number)object, string);
        }
        if (object instanceof Date) {
            return this.formatDate((Date)object, string);
        }
        throw new RuntimeException("format(" + object.getClass().getName() + "," + string + ") expected Number or Date");
    }

    public String formatNumber(Number number, int n) {
        this.m_NumberFormat.setMinimumFractionDigits(n);
        this.m_NumberFormat.setMaximumFractionDigits(n);
        this.m_NumberFormat.setDecimalSeparatorAlwaysShown(n > 0);
        return this.m_NumberFormat.format(number);
    }

    public String formatNumber(Number number, int n, String string) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(this.getLocale(string));
        decimalFormat.setMinimumFractionDigits(n);
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setDecimalSeparatorAlwaysShown(n > 0);
        this.configNaN(decimalFormat);
        return decimalFormat.format(number);
    }

    public String formatNumber(Number number, String string) {
        if (string.equals("#,K") || string.equals("#0,K")) {
            double d = number.doubleValue();
            int n = (int)(d / 1000.0);
            if (n == 0) {
                if (string.length() > 3) {
                    return "0K";
                }
                return "K";
            }
            return n + "K";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        this.configNaN(decimalFormat);
        return decimalFormat.format(number);
    }

    public String formatCurrency(Number number) {
        return this.m_CurrencyFormat.format(number);
    }

    public String formatCurrency(Number number, String string) {
        return NumberFormat.getCurrencyInstance(this.getLocale(string)).format(number);
    }

    public String formatPercent(Number number, int n) {
        this.m_PercentFormat.setMinimumFractionDigits(n);
        this.m_PercentFormat.setMaximumFractionDigits(n);
        this.m_PercentFormat.setDecimalSeparatorAlwaysShown(n > 0);
        return this.m_PercentFormat.format(number);
    }

    public String formatPercent(Number number, String string, int n) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(this.getLocale(string));
        decimalFormat.setMinimumFractionDigits(n);
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setDecimalSeparatorAlwaysShown(n > 0);
        this.configNaN(decimalFormat);
        return decimalFormat.format(number);
    }

    public String formatDate(Date date, String string) {
        SimpleDateFormat simpleDateFormat = this.m_DateFormats.get(string);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(string);
            this.m_DateFormats.put(string, simpleDateFormat);
        }
        return simpleDateFormat.format(date);
    }

    public String formatDate(Date date, String string, String string2) {
        String string3 = string + ":" + string2;
        SimpleDateFormat simpleDateFormat = this.m_DateFormats.get(string3);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(string, this.getLocale(string2));
            this.m_DateFormats.put(string3, simpleDateFormat);
        }
        return simpleDateFormat.format(date);
    }

    private Locale getLocale(String string) {
        Locale locale = this.m_Locales.get(string);
        if (locale == null) {
            int n = string.length();
            String string2 = n >= 2 ? string.substring(0, 2) : "";
            String string3 = n >= 5 ? string.substring(3, 5) : "";
            String string4 = n >= 8 ? string.substring(6, 8) : "";
            locale = new Locale(string2, string3, string4);
            this.m_Locales.put(string, locale);
        }
        return locale;
    }

    private void configNaN(DecimalFormat decimalFormat) {
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setNaN("NaN");
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }
}

