/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.pl.FilterPageListener;
import com.elixirtech.report2.logical.IPaginator;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.PagedSectionRenderer;
import com.elixirtech.report2.logical.StreamedSectionRenderer;
import com.elixirtech.report2.logical.layout.SectionSplitter;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.PageBreak;
import com.elixirtech.report2.logical.model.PageHeader;
import java.util.Iterator;

public class PagedLogicalRenderContext
extends LogicalRenderContext {
    protected IPaginator m_Paginator;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PagedLogicalRenderContext.class);

    public PagedLogicalRenderContext(PageListener pageListener, Result result) {
        super(PagedLogicalRenderContext.getPL(pageListener, result), result);
    }

    private static PageListener getPL(PageListener pageListener, Result result) {
        String string;
        if (result != null && StringUtil.notEmpty(string = result.getFeature("Result.Filter"))) {
            try {
                FilterPageListener filterPageListener = new FilterPageListener(pageListener, string);
                pageListener = filterPageListener;
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.error((Object)("Can't parse page filter: " + String.valueOf(numberFormatException)));
            }
        }
        return pageListener;
    }

    @Override
    public void pushScope(StreamedSectionRenderer streamedSectionRenderer) {
        assert (streamedSectionRenderer instanceof PagedSectionRenderer);
        this.m_Paginator = streamedSectionRenderer.getPaginator();
        super.pushScope(streamedSectionRenderer);
    }

    @Override
    public void popScope() {
        super.popScope();
        this.m_Paginator = this.m_SectionRenderer != null ? this.m_SectionRenderer.getPaginator() : null;
    }

    @Override
    public void setPageHeader(PageHeader pageHeader) {
        super.setPageHeader(pageHeader);
        this.m_Paginator.add(pageHeader.getHeight());
        this.m_Paginator.initAvailableHeight();
    }

    @Override
    public BodyPart addBodyPart(BodyPart bodyPart) {
        try {
            if (bodyPart.isKeepWithNext() && bodyPart.getHeight() < this.m_Paginator.getBodyHeight()) {
                ((PagedSectionRenderer)this.m_SectionRenderer).addKeepWithNext(bodyPart);
            } else {
                this.paginate(bodyPart);
            }
        }
        catch (RenderException renderException) {
            m_Log.error((Object)("Can't paginate " + bodyPart.getTagName() + " : " + String.valueOf(renderException)), (Throwable)renderException);
        }
        this.m_RawToLogical.clear();
        this.m_RawToLogical.put(bodyPart.getRaw(), bodyPart);
        return bodyPart;
    }

    @Override
    protected void pageBreak(boolean bl) throws RenderException {
        this.m_SectionRenderer.pageBreak(bl);
    }

    @Override
    protected void ensureHeightAvailable(int n) {
        this.m_SectionRenderer.ensureHeightAvailable(n);
    }

    protected void paginate(BodyPart bodyPart) throws RenderException {
        this.paginate2(0, bodyPart);
    }

    protected void paginate2(int n, BodyPart bodyPart) throws RenderException {
        if (n > SectionSplitter.PartitionLimit) {
            throw new RuntimeException("Body Partition depth limit " + SectionSplitter.PartitionLimit + " exceeded");
        }
        int n2 = bodyPart.getHeight();
        ((PagedSectionRenderer)this.m_SectionRenderer).flushKeepWithNext(n2);
        boolean bl = this.m_Paginator.isAtTop();
        PageBreak pageBreak = this.getExplicitPageBreak(bodyPart);
        if (pageBreak != null) {
            bodyPart.getLogicalElementList().remove(pageBreak);
            SectionSplitter sectionSplitter = new SectionSplitter(bodyPart, pageBreak.getTop(), true);
            this.paginate2(n + 1, sectionSplitter.getAbove());
            this.pageBreak(pageBreak.isResetPageCount());
            BodyPart bodyPart2 = sectionSplitter.getBelow();
            if (bodyPart2.getHeight() > 0) {
                this.m_SectionRenderer.renderRepeatGroupHeaders();
            }
            this.paginate2(n + 1, bodyPart2);
        } else if (this.m_Paginator.canFit(n2)) {
            String string = bodyPart.getVerticalAlign();
            if ("Top".equals(string)) {
                this.doAddBodyPart(bodyPart);
                this.m_Paginator.add(n2);
                int n3 = bodyPart.getSpaceAfter();
                if (n3 != 0) {
                    if (this.m_Paginator.canFit(n3)) {
                        this.m_Paginator.add(n3);
                    } else {
                        this.pageBreak(false);
                    }
                }
            } else if ("Bottom".equals(string)) {
                int n4 = this.m_Paginator.getAvailableHeight();
                this.m_Paginator.add(n4 - n2);
                this.shiftContents(bodyPart, n4 - n2);
                this.doAddBodyPart(bodyPart);
                this.pageBreak(false);
            } else if ("Center".equals(string)) {
                int n5 = this.m_Paginator.getAvailableHeight();
                int n6 = (n5 - n2) / 2;
                this.m_Paginator.add(n6);
                this.shiftContents(bodyPart, n6);
                this.doAddBodyPart(bodyPart);
            } else {
                this.doAddBodyPart(bodyPart);
                this.m_Paginator.add(n2);
                int n7 = bodyPart.getSpaceAfter();
                if (n7 != 0) {
                    if (this.m_Paginator.canFit(n7)) {
                        this.m_Paginator.add(n7);
                    } else {
                        this.pageBreak(false);
                    }
                }
            }
        } else if (!bl && bodyPart.isKeepTogether() && n2 < this.availableHeightOnNextPage()) {
            this.pageBreak(false);
            this.m_SectionRenderer.renderRepeatGroupHeaders();
            this.paginate2(n + 1, bodyPart);
        } else {
            boolean bl2 = n2 >= this.availableHeightOnNextPage();
            SectionSplitter sectionSplitter = new SectionSplitter(bodyPart, this.m_Paginator.getAvailableHeight(), bl2);
            this.doAddBodyPart(sectionSplitter.getAbove());
            this.pageBreak(false);
            BodyPart bodyPart3 = sectionSplitter.getBelow();
            if (bodyPart3.getHeight() > 0) {
                this.m_SectionRenderer.renderRepeatGroupHeaders();
            }
            this.paginate2(n + 1, bodyPart3);
        }
    }

    protected PageBreak getExplicitPageBreak(BodyPart bodyPart) {
        Iterator<LogicalElement> iterator = bodyPart.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            if (!(logicalElement instanceof PageBreak)) continue;
            return (PageBreak)logicalElement;
        }
        return null;
    }

    protected void shiftContents(ILogicalElementHolder iLogicalElementHolder, int n) {
        if (iLogicalElementHolder instanceof BodyPart) {
            ((BodyPart)iLogicalElementHolder).setHeight(iLogicalElementHolder.getHeight() + n);
        }
        Iterator<LogicalElement> iterator = iLogicalElementHolder.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            logicalElement.setTop(logicalElement.getTop() + n);
            if (!(logicalElement instanceof ILogicalElementHolder)) continue;
            this.shiftContents((ILogicalElementHolder)((Object)logicalElement), n);
        }
    }

    protected int availableHeightOnNextPage() {
        int n = this.m_Paginator.getBodyHeight();
        int n2 = this.m_SectionRenderer.getRepeatGroupHeadersHeight();
        return n - n2;
    }
}

