/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.IPaginator;
import com.elixirtech.report2.logical.MultiColumnPaginator;
import com.elixirtech.report2.logical.PagedLogicalRenderContext;
import com.elixirtech.report2.logical.StreamedSectionRenderer;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.GroupFooter;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.ReportFooter;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SectionFooter;
import com.elixirtech.report2.raw.model.SectionHeader;
import java.util.ArrayList;
import java.util.List;

public class PagedSectionRenderer
extends StreamedSectionRenderer {
    public static final int MINIMUM_BODY_HEIGHT = 200;
    protected MultiColumnPaginator m_Paginator;
    private boolean m_ShowPaginatorProgress = true;
    private boolean m_RepeatHeadersNeedRendering;
    protected List<BodyPart> m_KeepWithNextList = new ArrayList<BodyPart>();
    protected int m_KeepWithNextHeight;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PagedSectionRenderer.class);

    public PagedSectionRenderer(LogicalReport logicalReport) {
        super(logicalReport);
    }

    public void setShowPaginatorProgress(boolean bl) {
        this.m_ShowPaginatorProgress = bl;
    }

    @Override
    protected boolean setupPaginator() {
        this.m_Paginator = new MultiColumnPaginator(this.m_Section, this.m_ShowPaginatorProgress);
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        javaScriptEngine.declareBean("Paginator", this.m_Paginator);
        if (this.m_Paginator.getBodyHeight() <= 200) {
            m_Log.error((Object)"Page header and footer leave insufficient space to render report");
            return false;
        }
        return true;
    }

    @Override
    public IPaginator getPaginator() {
        return this.m_Paginator;
    }

    @Override
    public void dispose() {
        if (this.m_Paginator != null) {
            JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
            javaScriptEngine.undeclareBean("Paginator");
            this.m_Paginator.dispose();
            this.m_Paginator = null;
        }
        super.dispose();
    }

    @Override
    public boolean renderSectionHeader() throws RenderException {
        boolean bl = super.renderSectionHeader();
        this.m_Paginator.initAvailableHeight();
        this.startSection();
        return bl;
    }

    @Override
    public boolean renderSectionFooter() throws RenderException {
        if (this.m_RepeatHeadersNeedRendering) {
            this.renderRepeatGroupHeaders();
        }
        this.endSection();
        SectionHeader sectionHeader = this.m_Section.getSectionHeader();
        boolean bl = this.m_Section.isShowSectionHeader() && sectionHeader != null && sectionHeader.isVisible();
        boolean bl2 = false;
        if (this.m_Section.isShowSectionFooter()) {
            SectionFooter sectionFooter = this.m_Section.getSectionFooter();
            if (sectionFooter != null && sectionFooter.isVisible()) {
                if (sectionHeader != null) {
                    sectionFooter.setTableOfContents(sectionHeader.isTableOfContents());
                }
                bl2 = this.renderChunk(sectionFooter, sectionFooter);
            }
        } else if (bl) {
            assert (sectionHeader != null);
            ReportFooter reportFooter = new ReportFooter();
            SectionFooter sectionFooter = new SectionFooter();
            sectionFooter.setCaption("Section Footer");
            sectionFooter.setShrinkable(true);
            reportFooter.setRaw(sectionFooter);
            reportFooter.setTableOfContents(sectionHeader.isTableOfContents());
            reportFooter.setHeight(0);
            this.m_LogicalRenderContext.addBodyPart(reportFooter);
            bl2 = true;
        }
        this.flushKeepWithNext(0);
        this.renderLastPageFooter();
        this.m_ScriptEngine.popJSScope();
        return bl2;
    }

    protected void startSection() {
        if (this.m_Paginator.hasColumns()) {
            this.startOfColumns();
        }
    }

    protected void endSection() {
        if (this.m_Paginator.hasColumns()) {
            this.endOfColumns();
        }
    }

    @Override
    public boolean renderDetail(Section section) throws RenderException {
        boolean bl;
        if (this.m_RepeatHeadersNeedRendering) {
            this.renderRepeatGroupHeaders();
        }
        if ((bl = super.renderDetail(section)) && this.m_Paginator.isAcrossThenDown()) {
            if (this.m_Paginator.hasMoreColumns()) {
                this.m_Paginator.newColumn();
                this.startOfColumn();
            } else {
                this.endOfColumns();
                this.startOfColumns();
            }
        }
        return bl;
    }

    protected void renderLastPageFooter() throws RenderException {
        if (this.m_Section.isShowPageFooter()) {
            this.renderPageFooter();
        }
    }

    @Override
    public void pageBreak(boolean bl) throws RenderException {
        if (this.showingColumns() && this.m_Paginator.hasMoreColumns() && this.m_Paginator.getLayout() == 10) {
            this.m_Paginator.newColumn();
            this.startOfColumn();
        } else {
            this.endOfPage();
            this.m_Paginator.newPage(bl);
            if (bl) {
                this.startOfPageSequence(bl);
                this.startOfPage();
            } else {
                this.startOfPage();
            }
        }
    }

    @Override
    public void ensureHeightAvailable(int n) {
        if (!this.m_Paginator.canFit(n)) {
            this.pageBreak(false);
        }
    }

    @Override
    public void startOfPage() throws RenderException {
        super.startOfPage();
        if (this.m_Section.isShowPageHeader()) {
            this.renderPageHeader();
        }
        if (this.showingColumns() && this.m_Paginator.hasColumns()) {
            this.startOfColumns();
        }
        this.m_RepeatHeadersNeedRendering = true;
    }

    public void endOfPage() throws RenderException {
        if (this.showingColumns() && this.m_Paginator.hasColumns()) {
            this.endOfColumns();
        }
        if (this.m_Section.isShowPageFooter()) {
            this.renderPageFooter();
        }
    }

    public void startOfColumns() {
        this.m_LogicalRenderContext.startColumns();
        this.m_LogicalRenderContext.addColumn();
        this.m_Paginator.startOfColumns();
    }

    public void startOfColumn() {
        this.m_LogicalRenderContext.addColumn();
    }

    public void endOfColumns() {
        this.m_LogicalRenderContext.endColumns();
        this.m_Paginator.endOfColumns();
    }

    @Override
    public void renderGroupHeader(Group group, boolean bl) throws RenderException {
        GroupHeader groupHeader;
        if (group.isGroupHeaderVisible() && (groupHeader = group.getGroupHeader()) != null && groupHeader.isVisible()) {
            if (bl) {
                int n = groupHeader.getHeight();
                if (!this.m_Paginator.canFit(n)) {
                    m_Log.warn((Object)("Repeating group header (" + group.getGroupOn() + ") ignored: too big for the page"));
                    return;
                }
            } else if (this.m_RepeatHeadersNeedRendering) {
                this.renderRepeatGroupHeaders();
            }
            super.renderGroupHeader(group, bl);
        }
    }

    @Override
    protected void renderRepeatGroupHeaders() {
        if (this.m_RepeatHeadersNeedRendering) {
            this.m_RepeatHeadersNeedRendering = false;
            int n = this.m_KeepWithNextHeight;
            this.m_KeepWithNextHeight = 0;
            this.m_DataSink.repeatGroupHeaders();
            this.m_KeepWithNextHeight = n;
        }
    }

    @Override
    public int getRepeatGroupHeadersHeight() {
        return this.m_DataSink.getRepeatGroupHeadersHeight();
    }

    public void flushKeepWithNext(int n) throws RenderException {
        if (!this.m_KeepWithNextList.isEmpty()) {
            m_Log.debug((Object)("flushing keep with next " + this.m_KeepWithNextList.size() + " items"));
            boolean bl = this.m_Paginator.isAtTop();
            int n2 = n + this.m_KeepWithNextHeight;
            boolean bl2 = this.m_Paginator.canFit(n2);
            if (!bl && !bl2) {
                m_Log.debug((Object)"flush is adding a page break");
                this.pageBreak(false);
                this.renderRepeatGroupHeaders();
            }
            ArrayList<BodyPart> arrayList = new ArrayList<BodyPart>();
            arrayList.addAll(this.m_KeepWithNextList);
            this.m_KeepWithNextList.clear();
            this.m_KeepWithNextHeight = 0;
            for (BodyPart bodyPart : arrayList) {
                m_Log.debug((Object)("paginating " + bodyPart.getTagName() + " " + String.valueOf(bodyPart)));
                try {
                    ((PagedLogicalRenderContext)this.m_LogicalRenderContext).paginate(bodyPart);
                }
                catch (RenderException renderException) {
                    m_Log.error((Object)("Can't render keep-with-next: " + bodyPart.getTagName() + " : " + String.valueOf(renderException)));
                }
            }
        }
    }

    public void addKeepWithNext(BodyPart bodyPart) throws RenderException {
        int n = bodyPart.getHeight();
        if (n > 0 || bodyPart instanceof GroupFooter) {
            if (this.m_KeepWithNextList.contains(bodyPart)) {
                throw new RenderException("BodyPart " + bodyPart.getTagName() + " already kept");
            }
            this.m_KeepWithNextList.add(bodyPart);
            this.m_KeepWithNextHeight += n;
        }
    }

    public boolean isOnKeepList(GroupHeader groupHeader) {
        for (BodyPart bodyPart : this.m_KeepWithNextList) {
            if (bodyPart.getRaw() != groupHeader) continue;
            return true;
        }
        return false;
    }

    private boolean showingColumns() {
        int n = this.m_DataSink.getState();
        return n > 2 && n < 6;
    }
}

