/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.ClipUtil;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.IBody;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.SizableElement;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.sax.IBean;
import java.util.Iterator;

public class RenderUtil {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RenderUtil.class);

    public static void growShrinkBodyPart(BodyPart bodyPart) {
        RawElementHolder rawElementHolder = (RawElementHolder)bodyPart.getRaw();
        if (rawElementHolder == null) {
            m_Log.error((Object)("growShrinkBodyPart(" + bodyPart.getTagName() + ") raw is null"));
            return;
        }
        boolean bl = rawElementHolder.isGrowable();
        boolean bl2 = rawElementHolder.isShrinkable();
        if (bl || bl2) {
            int n = bodyPart.getHeight();
            int n2 = RenderUtil.calcBottom(bodyPart);
            if (bl && n < n2) {
                bodyPart.setHeight(n2);
            } else if (bl2 && n > n2) {
                bodyPart.setHeight(n2);
            } else {
                ClipUtil.clipHolder(bodyPart);
            }
        } else {
            ClipUtil.clipHolder(bodyPart);
        }
    }

    public static void growShrinkRectangle(Rectangle rectangle) {
        RawModelElement rawModelElement = rectangle.getRaw();
        boolean bl = rawModelElement.isGrowable();
        boolean bl2 = rawModelElement.isShrinkable();
        if (bl || bl2) {
            int n = rectangle.getHeight();
            int n2 = Math.max(0, RenderUtil.calcBottom(rectangle) - rectangle.getTop());
            if (bl && n < n2) {
                rectangle.setHeight(n2);
            } else if (bl2 && n > n2) {
                rectangle.setHeight(n2);
            } else {
                ClipUtil.clipHolder(rectangle);
            }
        } else {
            ClipUtil.clipHolder(rectangle);
        }
    }

    public static int calcBottom(ILogicalElementHolder iLogicalElementHolder) {
        int n = iLogicalElementHolder.getTop() + RenderUtil.getBorderTop(iLogicalElementHolder) + RenderUtil.getPaddingTop(iLogicalElementHolder);
        for (LogicalElement logicalElement : iLogicalElementHolder.getLogicalElementList()) {
            int n2 = logicalElement.getTop() + logicalElement.getHeight();
            n = Math.max(n, n2);
        }
        int n3 = n + RenderUtil.getBorderBottom(iLogicalElementHolder) + RenderUtil.getPaddingBottom(iLogicalElementHolder);
        return (int)Math.ceil((float)n3 / 20.0f) * 20;
    }

    public static int calcRight(ILogicalElementHolder iLogicalElementHolder) {
        int n = iLogicalElementHolder.getLeft() + RenderUtil.getBorderLeft(iLogicalElementHolder) + RenderUtil.getPaddingLeft(iLogicalElementHolder);
        for (LogicalElement logicalElement : iLogicalElementHolder.getLogicalElementList()) {
            int n2 = logicalElement.getLeft() + logicalElement.getWidth();
            n = Math.max(n, n2);
        }
        return n + RenderUtil.getPaddingRight(iLogicalElementHolder) + RenderUtil.getBorderRight(iLogicalElementHolder);
    }

    public static int getBorderWidth(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            if (BorderStyle.NONE == BorderStyle.get(rectangle.getBorderStyle())) {
                return 0;
            }
            return rectangle.getBorderWidth();
        }
        if (iBean instanceof RawElement) {
            RawElement rawElement = (RawElement)iBean;
            if (BorderStyle.NONE == BorderStyle.get(rawElement.getBorderStyle())) {
                return 0;
            }
            return rawElement.getBorderWidth();
        }
        return 0;
    }

    public static int getBorderTop(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
            if (borderStyle != BorderStyle.NONE && rectangle.isBorderTop()) {
                return rectangle.getBorderWidth();
            }
            return 0;
        }
        if (iBean instanceof RawElement) {
            RawElement rawElement = (RawElement)iBean;
            BorderStyle borderStyle = BorderStyle.get(rawElement.getBorderStyle());
            if (borderStyle != BorderStyle.NONE && rawElement.isBorderTop()) {
                return rawElement.getBorderWidth();
            }
            return 0;
        }
        return 0;
    }

    public static int getBorderLeft(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
            if (borderStyle != BorderStyle.NONE && rectangle.isBorderLeft()) {
                return rectangle.getBorderWidth();
            }
            return 0;
        }
        if (iBean instanceof RawElement) {
            RawElement rawElement = (RawElement)iBean;
            BorderStyle borderStyle = BorderStyle.get(rawElement.getBorderStyle());
            if (borderStyle != BorderStyle.NONE && rawElement.isBorderLeft()) {
                return rawElement.getBorderWidth();
            }
            return 0;
        }
        return 0;
    }

    public static int getBorderBottom(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
            if (borderStyle != BorderStyle.NONE && rectangle.isBorderBottom()) {
                return rectangle.getBorderWidth();
            }
            return 0;
        }
        if (iBean instanceof RawElement) {
            RawElement rawElement = (RawElement)iBean;
            BorderStyle borderStyle = BorderStyle.get(rawElement.getBorderStyle());
            if (borderStyle != BorderStyle.NONE && rawElement.isBorderBottom()) {
                return rawElement.getBorderWidth();
            }
            return 0;
        }
        return 0;
    }

    public static int getBorderRight(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
            if (borderStyle != BorderStyle.NONE && rectangle.isBorderRight()) {
                return rectangle.getBorderWidth();
            }
            return 0;
        }
        if (iBean instanceof RawElement) {
            RawElement rawElement = (RawElement)iBean;
            BorderStyle borderStyle = BorderStyle.get(rawElement.getBorderStyle());
            if (borderStyle != BorderStyle.NONE && rawElement.isBorderRight()) {
                return rawElement.getBorderWidth();
            }
            return 0;
        }
        return 0;
    }

    public static int getPaddingTop(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            return rectangle.getPaddingTop();
        }
        return 0;
    }

    public static int getPaddingBottom(IBean iBean) {
        LogicalElementHolder logicalElementHolder;
        RawElementHolder rawElementHolder;
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            return rectangle.getPaddingBottom();
        }
        if (iBean instanceof LogicalElementHolder && (rawElementHolder = (RawElementHolder)(logicalElementHolder = (LogicalElementHolder)iBean).getRaw()) != null) {
            return rawElementHolder.getPaddingBottom();
        }
        return 0;
    }

    public static int getPaddingLeft(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            return rectangle.getPaddingLeft();
        }
        return 0;
    }

    public static int getPaddingRight(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            return rectangle.getPaddingRight();
        }
        return 0;
    }

    public static final int getBorderWidth(String string) {
        if (string == null) {
            return 0;
        }
        string = string.trim();
        return Integer.parseInt(string);
    }

    public static boolean isBlank(Page page) {
        Body body = page.getBody();
        if (body == null) {
            return true;
        }
        return RenderUtil.isBlank(body);
    }

    private static boolean isBlank(IBody iBody) {
        Iterator<BodyPart> iterator = iBody.getBodyPartIterator();
        while (iterator.hasNext()) {
            BodyPart bodyPart = iterator.next();
            if (bodyPart instanceof Columns) {
                Iterator<Column> iterator2 = ((Columns)bodyPart).getColumnIterator();
                while (iterator2.hasNext()) {
                    if (RenderUtil.isBlank(iterator2.next())) continue;
                    return false;
                }
                continue;
            }
            if (RenderUtil.isBlank(bodyPart)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlank(BodyPart bodyPart) {
        RawModelElement rawModelElement = bodyPart.getRaw();
        return bodyPart.getLogicalElementCount() == 0 && (rawModelElement.isShrinkable() || rawModelElement.getHeight() == 0);
    }

    public static void cleanBlankPage(Page page) {
        Body body = page.getBody();
        if (body != null) {
            body.removeAllBodyParts();
        }
    }

    public static boolean isValidTOC(SizableElement sizableElement) {
        return !"Below".equals(sizableElement.getSplit());
    }
}

