/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.graphics.VerticalAlignment;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.report2.logical.ITextWrapper;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextWrapperER3
implements ITextWrapper {
    private List<ITextWrapper.Text> m_Lines = new ArrayList<ITextWrapper.Text>();
    private int m_Height;
    private Rectangle m_Rect;
    IFontMeasurer m_FontMeasurer;
    private boolean m_CanGrow;
    private boolean m_CanShrink;
    private int m_FirstLineIndent;
    private VerticalAlignment m_VerticalAlignment;
    private Rectangle m_BoundingBox;
    private int m_NextChar;
    private int m_Orientation;
    private String[] m_LineArray;

    public TextWrapperER3(Rectangle rectangle, String string, IFontMeasurer iFontMeasurer, boolean bl, boolean bl2, int n, VerticalAlignment verticalAlignment) {
        this.m_Rect = rectangle;
        this.m_FontMeasurer = iFontMeasurer;
        this.m_CanGrow = bl;
        this.m_CanShrink = bl2;
        this.m_FirstLineIndent = n;
        this.m_VerticalAlignment = verticalAlignment;
        this.m_LineArray = this.splitIntoLines(string);
    }

    @Override
    public void setOrientation(int n) {
        this.m_Orientation = n;
        while (this.m_Orientation >= 360) {
            this.m_Orientation -= 360;
        }
        while (this.m_Orientation < 0) {
            this.m_Orientation += 360;
        }
    }

    @Override
    public void doLayout() {
        if (this.m_Orientation < 90) {
            this.wrapLayout0(this.m_LineArray);
        } else if (this.m_Orientation < 180) {
            this.invert(this.m_Rect);
            boolean bl = this.m_CanGrow;
            this.m_CanGrow = false;
            this.wrapLayout0(this.m_LineArray);
            this.m_CanGrow = bl;
            this.invert(this.m_Rect);
            this.rotate90();
        } else if (this.m_Orientation < 270) {
            this.wrapLayout0(this.m_LineArray);
            this.rotate180();
        } else {
            this.invert(this.m_Rect);
            boolean bl = this.m_CanGrow;
            this.m_CanGrow = false;
            this.wrapLayout0(this.m_LineArray);
            this.m_CanGrow = bl;
            this.invert(this.m_Rect);
            this.rotate270();
        }
    }

    @Override
    public int getLineCount() {
        return this.m_Lines.size();
    }

    protected void wrapLayout0(String[] stringArray) {
        int n = this.m_Rect.width;
        int n2 = 0;
        this.m_NextChar = 0;
        int n3 = this.getLineHeight();
        int n4 = this.getAscent();
        int n5 = n4 + this.getDescent();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            int n6;
            boolean bl = true;
            int n7 = stringArray[i].length();
            int n8 = stringArray[i].trim().length();
            int n9 = 0;
            if (n7 == 0 || n8 == 0) {
                if (!this.m_CanGrow && n2 + n4 > this.m_Rect.height) break;
                int n10 = this.m_Rect.x;
                n6 = n;
                if (bl && this.m_FirstLineIndent > 0) {
                    n10 += this.m_FirstLineIndent;
                    n6 -= this.m_FirstLineIndent;
                } else if (!bl && this.m_FirstLineIndent < 0) {
                    n10 -= this.m_FirstLineIndent;
                    n6 += this.m_FirstLineIndent;
                }
                ITextWrapper.Text text = new ITextWrapper.Text();
                text.line = "";
                text.rc.x = n10;
                text.rc.y = n2 + this.m_Rect.y;
                text.rc.width = n6;
                text.rc.height = n5;
                this.addLine(text);
                n2 += n3;
                continue;
            }
            LBM lBM = new LBM(stringArray[i]);
            while (lBM.getPosition() < n7) {
                if (!this.m_CanGrow && n2 + n4 > this.m_Rect.height) {
                    this.m_NextChar += lBM.getPosition();
                    break block0;
                }
                n6 = this.m_Rect.x;
                int n11 = n;
                if (bl && this.m_FirstLineIndent > 0) {
                    n6 += this.m_FirstLineIndent;
                    n11 -= this.m_FirstLineIndent;
                } else if (!bl && this.m_FirstLineIndent < 0) {
                    n6 -= this.m_FirstLineIndent;
                    n11 += this.m_FirstLineIndent;
                }
                lBM.nextLayout(n11);
                int n12 = lBM.getPosition();
                ITextWrapper.Text text = new ITextWrapper.Text();
                text.line = stringArray[i].substring(n9, n12);
                text.rc.x = n6;
                text.rc.y = n2 + this.m_Rect.y;
                text.rc.width = n11;
                text.rc.height = n5;
                this.addLine(text);
                n2 += n3;
                n9 = n12;
                bl = false;
            }
            this.m_NextChar += n7;
            if (i >= stringArray.length - 1) continue;
            ++this.m_NextChar;
        }
        this.m_Height = n2;
    }

    protected void addLine(ITextWrapper.Text text) {
        this.m_BoundingBox = this.m_BoundingBox == null ? new Rectangle(text.rc) : this.m_BoundingBox.union(text.rc);
        this.m_Lines.add(text);
    }

    protected void invert(Rectangle rectangle) {
        int n = rectangle.width;
        rectangle.width = rectangle.height;
        rectangle.height = n;
    }

    protected void dump(String string, ITextWrapper.Text text) {
        System.out.println(string + ": " + text.rc.x + "," + text.rc.y + "," + text.rc.width + "," + text.rc.height);
    }

    protected void rotate90() {
        if (this.m_BoundingBox != null) {
            float f = this.m_Rect.width;
            if (this.m_VerticalAlignment == VerticalAlignment.CENTER) {
                f = this.m_Rect.width - (this.m_Rect.width - this.m_BoundingBox.height) / 2;
            }
            if (this.m_VerticalAlignment == VerticalAlignment.BOTTOM) {
                f = this.m_BoundingBox.height;
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(f, 0.0);
            affineTransform.rotate(1.5707963267948966);
            this.transformLines(affineTransform);
        }
    }

    protected void rotate180() {
        int n = this.m_CanShrink ? this.m_BoundingBox.height : this.m_Rect.height;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.m_Rect.width, n);
        affineTransform.rotate(Math.PI);
        this.transformLines(affineTransform);
    }

    protected void rotate270() {
        if (this.m_BoundingBox != null) {
            float f;
            float f2 = 0.0f;
            float f3 = f = this.m_CanShrink ? (float)this.m_BoundingBox.width : (float)this.m_Rect.height;
            if (this.m_VerticalAlignment == VerticalAlignment.CENTER) {
                f2 = this.m_Rect.width - (this.m_Rect.width - this.m_BoundingBox.height) / 2;
            }
            if (this.m_VerticalAlignment == VerticalAlignment.BOTTOM) {
                f2 = this.m_Rect.width - this.m_BoundingBox.height;
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(f2, f);
            affineTransform.rotate(-1.5707963267948966);
            this.transformLines(affineTransform);
        }
    }

    protected void transformLines(AffineTransform affineTransform) {
        for (ITextWrapper.Text text : this.m_Lines) {
            text.rc.x -= this.m_Rect.x;
            text.rc.y -= this.m_Rect.y;
            Shape shape = affineTransform.createTransformedShape(text.rc);
            text.rc = shape.getBounds();
            text.rc.x += this.m_Rect.x;
            text.rc.y += this.m_Rect.y;
        }
    }

    @Override
    public Iterator getLines() {
        return this.m_Lines.iterator();
    }

    public int getHeight() {
        if (this.m_Height < this.m_Rect.height) {
            return this.m_CanShrink ? this.m_Height : this.m_Rect.height;
        }
        if (this.m_Height > this.m_Rect.height) {
            return this.m_CanGrow ? this.m_Height : this.m_Rect.height;
        }
        return this.m_Height;
    }

    public int getLineHeight() {
        return (int)this.m_FontMeasurer.getHeight() / 20;
    }

    public int getAscent() {
        return (int)this.m_FontMeasurer.getAscent() / 20;
    }

    public int getDescent() {
        return (int)this.m_FontMeasurer.getDescent() / 20;
    }

    public int getLeading() {
        return (int)this.m_FontMeasurer.getLeading() / 20;
    }

    @Override
    public int getNextChar() {
        return this.m_NextChar;
    }

    protected String[] splitIntoLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 != '\n' && c2 != '\r') continue;
            arrayList.add(string.substring(n2, i));
            if (i + 1 < n && ((c = string.charAt(i + 1)) == '\n' || c == '\r') && c2 != c) {
                ++i;
            }
            n2 = i + 1;
        }
        if (n2 < n) {
            arrayList.add(string.substring(n2, n));
        }
        if (arrayList.size() == 0) {
            arrayList.add("");
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private class LBM {
        private String m_Line;
        private int m_Position;

        public LBM(String string) {
            this.m_Line = string.replace('\t', ' ');
        }

        public int getPosition() {
            return this.m_Position;
        }

        public void nextLayout(int n) {
            int n2;
            int n3;
            n *= 20;
            int n4 = this.m_Line.length();
            int n5 = -1;
            for (n3 = n2 = this.m_Position; n3 < n4; ++n3) {
                String string;
                int n6;
                if (this.m_Line.charAt(n3) == ' ') {
                    n5 = n3;
                }
                if ((n6 = (int)TextWrapperER3.this.m_FontMeasurer.getWidth(string = this.m_Line.substring(n2, n3))) < n) {
                    continue;
                }
                if (n5 >= 0) {
                    n3 = n5 + 1;
                    break;
                }
                if (n3 - 1 == n2) break;
                --n3;
                break;
            }
            this.m_Position = n3;
        }
    }
}

