/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreePageListener
implements PageListener {
    private PageListener m_Next;
    private List<PS> m_PageSequences = new ArrayList<PS>();
    private PS m_CurrentPageSequence;

    public TreePageListener(PageListener pageListener) {
        this.m_Next = pageListener;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_PageSequences.clear();
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_CurrentPageSequence = new PS(pageSequence);
        this.m_PageSequences.add(this.m_CurrentPageSequence);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        this.m_CurrentPageSequence.pages.add(page);
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_CurrentPageSequence = null;
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        this.m_Next.startReport(pageSource);
        for (PS pS : this.m_PageSequences) {
            this.m_Next.startPageSequence(pS.ps);
            Iterator<Page> iterator = pS.pages.iterator();
            while (iterator.hasNext()) {
                this.m_Next.addPage(iterator.next());
            }
            this.m_Next.endPageSequence(pS.ps);
        }
        this.m_Next.endReport(pageSource);
        this.m_Next = null;
        this.m_PageSequences = null;
        this.m_CurrentPageSequence = null;
    }

    private static class PS {
        public PageSequence ps;
        public List<Page> pages = new ArrayList<Page>();

        public PS(PageSequence pageSequence) {
            this.ps = pageSequence;
        }
    }
}

