/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.callback;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.g.GraphicsToGlint;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.callback.Callback;
import com.elixirtech.report2.logical.callback.CallbackContext;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.ControlSource;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.View;
import javax.swing.text.rtf.RTFEditorKit;

public class RTFCallback
implements Callback {
    public static final String START_RTF = "$\\{";
    public static final String END_RTF = "\\}";
    private RTFEditorKit m_RTFEditorKit;
    private JEditorPane m_EditorPane = new JEditorPane();
    private Document m_Document;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RTFCallback.class);

    public RTFCallback() {
        this.m_RTFEditorKit = new RTFEditorKit();
        this.m_EditorPane.setEditorKit(this.m_RTFEditorKit);
        this.m_Document = this.m_EditorPane.getDocument();
        this.m_EditorPane.updateUI();
    }

    @Override
    public synchronized void render(CallbackElement callbackElement, CallbackContext callbackContext) {
        Dimension dimension = callbackContext.getSize();
        int n = dimension.width / 20;
        int n2 = dimension.height / 20;
        if (n <= 0 || n2 <= 0) {
            return;
        }
        this.m_EditorPane.setLocation(0, 0);
        this.m_EditorPane.setSize(new Dimension(n, n2));
        try {
            ControlSource controlSource = callbackElement.getControlSource();
            Object object = ControlSourceProcessor.getData(controlSource);
            String string = String.valueOf(object);
            string = callbackContext.substitute(string, START_RTF, END_RTF);
            this.m_Document.remove(0, this.m_Document.getLength());
            StringReader stringReader = new StringReader(string);
            this.m_RTFEditorKit.read(stringReader, this.m_Document, 0);
            View view = this.m_EditorPane.getUI().getRootView(this.m_EditorPane);
            IGlint iGlint = callbackContext.getGlint();
            GraphicsToGlint graphicsToGlint = new GraphicsToGlint(iGlint, new Rectangle(0, 0, n, n2));
            view.paint(graphicsToGlint, new Rectangle(0, 0, n, n2));
            iGlint.flush();
        }
        catch (Exception exception) {
            m_Log.error((Object)exception.toString());
            exception.printStackTrace();
        }
    }

    @Override
    public void renderDesign(CallbackElement callbackElement, Graphics2D graphics2D, Rectangle rectangle) {
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

