/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.callback.html2;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.callback.Callback;
import com.elixirtech.report2.logical.callback.CallbackContext;
import com.elixirtech.report2.logical.callback.HTMLCallback;
import com.elixirtech.report2.logical.callback.html2.ASLayoutBlock;
import com.elixirtech.report2.logical.callback.html2.HTMLCallback2$;
import com.elixirtech.report2.logical.callback.html2.HTMLToAttributedString$;
import com.elixirtech.report2.logical.callback.html2.LayoutBlock;
import com.elixirtech.report2.logical.callback.html2.NestedLayoutBlock;
import com.elixirtech.report2.logical.callback.html2.RenderAttributedString$;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.ControlSource;
import com.typesafe.config.Config;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class HTMLCallback2
implements Callback {
    public static final long OFFSET$_m_13 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_12 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("optLoading$lzy1"));
    public static final long OFFSET$_m_11 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("optIcon$lzy1"));
    public static final long OFFSET$_m_10 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("TableLine$lzy1"));
    public static final long OFFSET$_m_9 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("TableMargin$lzy1"));
    public static final long OFFSET$_m_8 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("WhiteBackground$lzy1"));
    public static final long OFFSET$_m_7 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("TBMargin$lzy1"));
    public static final long OFFSET$_m_6 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("DefaultFontSize$lzy1"));
    public static final long OFFSET$_m_5 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("DefaultFontFamily$lzy1"));
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("Indent$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("Scale$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("isEnabled$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("html2Config$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HTMLCallback2$.class.getDeclaredField("config$lzy1"));

    public static String DefaultFontFamily() {
        return HTMLCallback2$.MODULE$.DefaultFontFamily();
    }

    public static int DefaultFontSize() {
        return HTMLCallback2$.MODULE$.DefaultFontSize();
    }

    public static int Indent() {
        return HTMLCallback2$.MODULE$.Indent();
    }

    public static int Scale() {
        return HTMLCallback2$.MODULE$.Scale();
    }

    public static int TBMargin() {
        return HTMLCallback2$.MODULE$.TBMargin();
    }

    public static Option<Color> TableLine() {
        return HTMLCallback2$.MODULE$.TableLine();
    }

    public static int TableMargin() {
        return HTMLCallback2$.MODULE$.TableMargin();
    }

    public static boolean WhiteBackground() {
        return HTMLCallback2$.MODULE$.WhiteBackground();
    }

    public static Config config() {
        return HTMLCallback2$.MODULE$.config();
    }

    public static Config html2Config() {
        return HTMLCallback2$.MODULE$.html2Config();
    }

    public static boolean isEnabled() {
        return HTMLCallback2$.MODULE$.isEnabled();
    }

    public static boolean isEnabledJ() {
        return HTMLCallback2$.MODULE$.isEnabledJ();
    }

    public static LoggingInterface log() {
        return HTMLCallback2$.MODULE$.log();
    }

    public static Option<ImageIcon> optIcon() {
        return HTMLCallback2$.MODULE$.optIcon();
    }

    public static Option<JLabel> optLoading() {
        return HTMLCallback2$.MODULE$.optLoading();
    }

    public static AtomicInteger serialId() {
        return HTMLCallback2$.MODULE$.serialId();
    }

    @Override
    public void render(CallbackElement e, CallbackContext cxt) {
        block3: {
            HTMLCallback2$.MODULE$.log().info(HTMLCallback2::render$$anonfun$1, Line$.MODULE$.apply(70), FullName$.MODULE$.apply("com.elixirtech.report2.logical.callback.html2.HTMLCallback2.render"));
            try {
                ControlSource csrc = e.getControlSource();
                String ctype = csrc.getType();
                if ("URL".equals(ctype)) {
                    HTMLCallback old = new HTMLCallback();
                    old.render1(e, cxt);
                    break block3;
                }
                String rawText = String.valueOf(ControlSourceProcessor.getData(csrc));
                String text = cxt.substitute(rawText, HTMLCallback2$.com$elixirtech$report2$logical$callback$html2$HTMLCallback2$$$START, HTMLCallback2$.com$elixirtech$report2$logical$callback$html2$HTMLCallback2$$$END);
                this.renderText((Option<CallbackElement>)Some$.MODULE$.apply((Object)e), text, cxt);
            }
            catch (Error ex) {
                HTMLCallback2$.MODULE$.log().error(() -> HTMLCallback2.render$$anonfun$2(ex), (Throwable)ex, Line$.MODULE$.apply(91), FullName$.MODULE$.apply("com.elixirtech.report2.logical.callback.html2.HTMLCallback2.render"));
            }
        }
    }

    public void renderText(Option<CallbackElement> optE, String text, CallbackContext cxt) {
        List asList = HTMLToAttributedString$.MODULE$.run(text).filterNot((Function1 & Serializable)lb -> this.isEmpty((LayoutBlock)lb));
        int fullWidth = (int)cxt.getSize().getWidth();
        int pxWidth = (int)package$.MODULE$.ceil(Float$.MODULE$.float2double((float)fullWidth / 20.0f));
        IntRef y = IntRef.create((int)0);
        ((List)asList.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                LayoutBlock blk = (LayoutBlock)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                int availableWidth = fullWidth - blk.pxIndentWidth() * 20;
                int pxHeight = blk.pxHeight(availableWidth);
                BufferedImage img = new BufferedImage(pxWidth * HTMLCallback2$.MODULE$.Scale(), pxHeight * HTMLCallback2$.MODULE$.Scale(), 2);
                Graphics2D g2d = RenderAttributedString$.MODULE$.setupGraphics(img.createGraphics());
                g2d.scale(Int$.MODULE$.int2double(HTMLCallback2$.MODULE$.Scale()), Int$.MODULE$.int2double(HTMLCallback2$.MODULE$.Scale()));
                if (HTMLCallback2$.MODULE$.WhiteBackground()) {
                    g2d.setColor(Color.WHITE);
                    g2d.fillRect(0, 0, pxWidth, pxHeight);
                }
                g2d.setColor(Color.BLACK);
                g2d.translate(blk.pxIndentWidth(), blk.pxMargins().top());
                blk.prefix().foreach((Function1)(JProcedure1 & Serializable)p -> {
                    g2d.translate(-p.pxWidth(), 0);
                    LayoutBlock layoutBlock = blk;
                    if (layoutBlock instanceof ASLayoutBlock) {
                        ASLayoutBlock asblk = (ASLayoutBlock)layoutBlock;
                        p.render(g2d, asblk.as());
                    }
                    g2d.translate(p.pxWidth(), 0);
                });
                RenderAttributedString$.MODULE$.run(g2d, blk, availableWidth);
                g2d.dispose();
                this.setImage(cxt, y$1.elem, img);
                y$1.elem += img.getHeight() / HTMLCallback2$.MODULE$.Scale();
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        optE.foreach((Function1)(JProcedure1 & Serializable)e -> {
            int eh = e.getHeight();
            int newh = y$2.elem * 20;
            if (e.isShrinkable() && eh > newh) {
                cxt.setHeight(newh);
            }
            if (e.isGrowable() && eh < newh) {
                cxt.setHeight(newh);
                return;
            }
        });
    }

    public boolean isEmpty(LayoutBlock lb) {
        LayoutBlock layoutBlock = lb;
        if (layoutBlock instanceof NestedLayoutBlock) {
            NestedLayoutBlock n = (NestedLayoutBlock)layoutBlock;
            return n.columns().isEmpty();
        }
        return false;
    }

    public void setImage(CallbackContext cxt, int y, BufferedImage img) {
        Image image = new Image();
        Rectangle rc = cxt.getRect();
        image.setLeft(rc.x);
        image.setTop(rc.y + y * 20);
        image.setWidth(rc.width);
        image.setHeight(img.getHeight() * 20 / HTMLCallback2$.MODULE$.Scale());
        image.setRaw(cxt.getRaw());
        image.setPicture("HTML2CallbackImage" + HTMLCallback2$.MODULE$.serialId().incrementAndGet());
        image.setSizeMode("Zoom");
        image.setHorizontalAlign(Alignment.CENTER.NAME);
        image.setVerticalAlign(Alignment.CENTER.NAME);
        image.setImage(img);
        cxt.addOutput(image);
    }

    @Override
    public void renderDesign(CallbackElement cxt, Graphics2D g, Rectangle rc) {
        HTMLCallback2$.MODULE$.optLoading().foreach((Function1)(JProcedure1 & Serializable)loading -> {
            Shape oldClip = g.getClip();
            g.clip(rc);
            g.translate(rc$1.x, rc$1.y);
            g.scale(20.0, 20.0);
            loading.paint(g);
            g.scale(0.05, 0.05);
            g.translate(-rc$1.x, -rc$1.y);
            g.setClip(oldClip);
        });
    }

    private static final Object render$$anonfun$1() {
        return "Rendering with HTMLCallback2";
    }

    private static final Object render$$anonfun$2(Error ex$1) {
        return "Error rendering HTML: " + ex$1;
    }
}

