/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.model;

import com.elixirtech.jdom.Element;
import com.elixirtech.report2.logical.model.ClipUtil;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.ITOCElement;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Rectangle
extends LogicalElement
implements IBean,
ILogicalElementHolder,
ITOCElement {
    protected List<LogicalElement> m_LogicalElement = new ArrayList<LogicalElement>();
    protected String m_BackgroundColor;
    protected String m_BorderStyle;
    protected int m_BorderWidth;
    protected String m_BorderColor;
    protected boolean m_BorderLeft;
    protected boolean m_BorderTop;
    protected boolean m_BorderRight;
    protected boolean m_BorderBottom;
    protected int m_BorderRadius;
    protected int m_PaddingLeft;
    protected int m_PaddingRight;
    protected int m_PaddingTop;
    protected int m_PaddingBottom;
    protected boolean m_CurvedClip;
    protected boolean m_PaddedClip;
    protected boolean m_NoClip;
    protected boolean m_TableOfContents;
    protected String m_TOCTitle;
    protected int m_TOCLevel;
    protected transient Object m_RawValue;

    public static boolean isHidden(String string) {
        return false;
    }

    public Rectangle() {
        this.setBorderLeft(true);
        this.setBorderTop(true);
        this.setBorderRight(true);
        this.setBorderBottom(true);
    }

    @Override
    public String getTagName() {
        return "rect";
    }

    @Override
    public void loaded() {
        super.loaded();
        Iterator<LogicalElement> iterator = this.m_LogicalElement.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_LogicalElement != null) {
            Iterator<LogicalElement> iterator = this.m_LogicalElement.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_LogicalElement = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_BackgroundColor != null) {
            element.setAttribute("Back_Color", this.m_BackgroundColor);
        }
        if (this.m_BorderStyle != null) {
            element.setAttribute("Border_Style", this.m_BorderStyle);
        }
        element.setAttribute("Border_Width", Integer.toString(this.m_BorderWidth));
        if (this.m_BorderColor != null) {
            element.setAttribute("Border_Color", this.m_BorderColor);
        }
        element.setAttribute("Left_Border", this.m_BorderLeft ? "Yes" : "No");
        element.setAttribute("Top_Border", this.m_BorderTop ? "Yes" : "No");
        element.setAttribute("Right_Border", this.m_BorderRight ? "Yes" : "No");
        element.setAttribute("Bottom_Border", this.m_BorderBottom ? "Yes" : "No");
        element.setAttribute("Border_Radius", Integer.toString(this.m_BorderRadius));
        element.setAttribute("padding-left", Integer.toString(this.m_PaddingLeft));
        element.setAttribute("padding-right", Integer.toString(this.m_PaddingRight));
        element.setAttribute("padding-top", Integer.toString(this.m_PaddingTop));
        element.setAttribute("padding-bottom", Integer.toString(this.m_PaddingBottom));
        element.setAttribute("curved-clip", this.m_CurvedClip ? "Yes" : "No");
        element.setAttribute("padded-clip", this.m_PaddedClip ? "Yes" : "No");
        element.setAttribute("no-clip", this.m_NoClip ? "Yes" : "No");
        element.setAttribute("Table_of_Contents", this.m_TableOfContents ? "Yes" : "No");
        if (this.m_TOCTitle != null) {
            element.setAttribute("TOC_Title", this.m_TOCTitle);
        }
        element.setAttribute("TOC_Level", Integer.toString(this.m_TOCLevel));
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Rectangle rectangle = (Rectangle)super.shallowCopy();
        rectangle.m_BackgroundColor = this.m_BackgroundColor;
        rectangle.m_BorderStyle = this.m_BorderStyle;
        rectangle.m_BorderWidth = this.m_BorderWidth;
        rectangle.m_BorderColor = this.m_BorderColor;
        rectangle.m_BorderLeft = this.m_BorderLeft;
        rectangle.m_BorderTop = this.m_BorderTop;
        rectangle.m_BorderRight = this.m_BorderRight;
        rectangle.m_BorderBottom = this.m_BorderBottom;
        rectangle.m_BorderRadius = this.m_BorderRadius;
        rectangle.m_PaddingLeft = this.m_PaddingLeft;
        rectangle.m_PaddingRight = this.m_PaddingRight;
        rectangle.m_PaddingTop = this.m_PaddingTop;
        rectangle.m_PaddingBottom = this.m_PaddingBottom;
        rectangle.m_CurvedClip = this.m_CurvedClip;
        rectangle.m_PaddedClip = this.m_PaddedClip;
        rectangle.m_NoClip = this.m_NoClip;
        rectangle.m_TableOfContents = this.m_TableOfContents;
        rectangle.m_TOCTitle = this.m_TOCTitle;
        rectangle.m_TOCLevel = this.m_TOCLevel;
        rectangle.m_RawValue = this.m_RawValue;
        return rectangle;
    }

    @Override
    public void clip(int n) {
        this.m_Height = n;
        ClipUtil.clipHolder(this);
    }

    public int getLeftMargin() {
        int n = this.getPaddingLeft();
        if (this.isBorderLeft() && !"None".equals(this.getBorderStyle())) {
            n += this.getBorderWidth();
        }
        return n;
    }

    public int getTopMargin() {
        int n = this.getPaddingTop();
        if (this.isBorderTop() && !"None".equals(this.getBorderStyle())) {
            n += this.getBorderWidth();
        }
        return n;
    }

    public int getRightMargin() {
        int n = this.getPaddingRight();
        if (this.isBorderRight() && !"None".equals(this.getBorderStyle())) {
            n += this.getBorderWidth();
        }
        return n;
    }

    public int getBottomMargin() {
        int n = this.getPaddingBottom();
        if (this.isBorderBottom() && !"None".equals(this.getBorderStyle())) {
            n += this.getBorderWidth();
        }
        return n;
    }

    public String toString() {
        return "Rect(" + this.getLeft() + "," + this.getTop() + "," + this.getWidth() + "," + this.getHeight() + ")";
    }

    @Override
    public void addLogicalElement(LogicalElement logicalElement) {
        this.m_LogicalElement.add(logicalElement);
    }

    public void addLogicalElement(int n, LogicalElement logicalElement) {
        this.m_LogicalElement.add(n, logicalElement);
    }

    public void addAllLogicalElements(Collection<LogicalElement> collection) {
        this.m_LogicalElement.addAll(collection);
    }

    public int indexOfLogicalElement(LogicalElement logicalElement) {
        return this.m_LogicalElement.indexOf(logicalElement);
    }

    public void removeLogicalElement(LogicalElement logicalElement) {
        this.m_LogicalElement.remove(logicalElement);
    }

    public void removeAllLogicalElements(Collection collection) {
        this.m_LogicalElement.removeAll(collection);
    }

    public void removeAllLogicalElements() {
        this.m_LogicalElement.clear();
    }

    public LogicalElement getLogicalElement(int n) {
        return this.m_LogicalElement.get(n);
    }

    public int getLogicalElementCount() {
        return this.m_LogicalElement.size();
    }

    @Override
    public Iterator<LogicalElement> getLogicalElementIterator() {
        return this.m_LogicalElement.iterator();
    }

    @Override
    public List<LogicalElement> getLogicalElementList() {
        return this.m_LogicalElement;
    }

    public void setLogicalElementList(List<LogicalElement> list) {
        this.m_LogicalElement = list;
    }

    public String getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    public void setBackgroundColor(String string) {
        this.m_BackgroundColor = string;
    }

    public String getBorderStyle() {
        return this.m_BorderStyle;
    }

    public void setBorderStyle(String string) {
        this.m_BorderStyle = string;
    }

    public int getBorderWidth() {
        return this.m_BorderWidth;
    }

    public void setBorderWidth(int n) {
        this.m_BorderWidth = n;
    }

    public String getBorderColor() {
        return this.m_BorderColor;
    }

    public void setBorderColor(String string) {
        this.m_BorderColor = string;
    }

    public boolean isBorderLeft() {
        return this.m_BorderLeft;
    }

    public void setBorderLeft(boolean bl) {
        this.m_BorderLeft = bl;
    }

    public boolean isBorderTop() {
        return this.m_BorderTop;
    }

    public void setBorderTop(boolean bl) {
        this.m_BorderTop = bl;
    }

    public boolean isBorderRight() {
        return this.m_BorderRight;
    }

    public void setBorderRight(boolean bl) {
        this.m_BorderRight = bl;
    }

    public boolean isBorderBottom() {
        return this.m_BorderBottom;
    }

    public void setBorderBottom(boolean bl) {
        this.m_BorderBottom = bl;
    }

    public int getBorderRadius() {
        return this.m_BorderRadius;
    }

    public void setBorderRadius(int n) {
        this.m_BorderRadius = n;
    }

    public int getPaddingLeft() {
        return this.m_PaddingLeft;
    }

    public void setPaddingLeft(int n) {
        this.m_PaddingLeft = n;
    }

    public int getPaddingRight() {
        return this.m_PaddingRight;
    }

    public void setPaddingRight(int n) {
        this.m_PaddingRight = n;
    }

    public int getPaddingTop() {
        return this.m_PaddingTop;
    }

    public void setPaddingTop(int n) {
        this.m_PaddingTop = n;
    }

    public int getPaddingBottom() {
        return this.m_PaddingBottom;
    }

    public void setPaddingBottom(int n) {
        this.m_PaddingBottom = n;
    }

    public boolean isCurvedClip() {
        return this.m_CurvedClip;
    }

    public void setCurvedClip(boolean bl) {
        this.m_CurvedClip = bl;
    }

    public boolean isPaddedClip() {
        return this.m_PaddedClip;
    }

    public void setPaddedClip(boolean bl) {
        this.m_PaddedClip = bl;
    }

    public boolean isNoClip() {
        return this.m_NoClip;
    }

    public void setNoClip(boolean bl) {
        this.m_NoClip = bl;
    }

    @Override
    public boolean isTableOfContents() {
        return this.m_TableOfContents;
    }

    @Override
    public void setTableOfContents(boolean bl) {
        this.m_TableOfContents = bl;
    }

    @Override
    public String getTOCTitle() {
        return this.m_TOCTitle;
    }

    public void setTOCTitle(String string) {
        this.m_TOCTitle = string;
    }

    @Override
    public int getTOCLevel() {
        return this.m_TOCLevel;
    }

    @Override
    public void setTOCLevel(int n) {
        this.m_TOCLevel = n;
    }

    public Object getRawValue() {
        return this.m_RawValue;
    }

    public void setRawValue(Object object) {
        this.m_RawValue = object;
    }

    @Override
    public Rectangle deepCopy() {
        Rectangle rectangle = new Rectangle();
        this.copyInto(rectangle);
        return rectangle;
    }

    protected void copyInto(Rectangle rectangle) {
        super.copyInto(rectangle);
        rectangle.m_BackgroundColor = this.m_BackgroundColor;
        rectangle.m_BorderStyle = this.m_BorderStyle;
        rectangle.m_BorderWidth = this.m_BorderWidth;
        rectangle.m_BorderColor = this.m_BorderColor;
        rectangle.m_BorderLeft = this.m_BorderLeft;
        rectangle.m_BorderTop = this.m_BorderTop;
        rectangle.m_BorderRight = this.m_BorderRight;
        rectangle.m_BorderBottom = this.m_BorderBottom;
        rectangle.m_BorderRadius = this.m_BorderRadius;
        rectangle.m_PaddingLeft = this.m_PaddingLeft;
        rectangle.m_PaddingRight = this.m_PaddingRight;
        rectangle.m_PaddingTop = this.m_PaddingTop;
        rectangle.m_PaddingBottom = this.m_PaddingBottom;
        rectangle.m_CurvedClip = this.m_CurvedClip;
        rectangle.m_PaddedClip = this.m_PaddedClip;
        rectangle.m_NoClip = this.m_NoClip;
        rectangle.m_TableOfContents = this.m_TableOfContents;
        rectangle.m_TOCTitle = this.m_TOCTitle;
        rectangle.m_TOCLevel = this.m_TOCLevel;
        rectangle.m_RawValue = this.m_RawValue;
        rectangle.m_LogicalElement = new ArrayList<LogicalElement>();
        for (LogicalElement logicalElement : this.m_LogicalElement) {
            rectangle.addLogicalElement(logicalElement.deepCopy());
        }
    }
}

