/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.report2.logical.renderer.TextTree;
import com.elixirtech.report2.logical.renderer.WidthEqualizer;
import java.util.Iterator;

class FixedRowWidthEqualizer
implements WidthEqualizer {
    private int m_TotalDepth;
    private int m_Width;
    private int m_Depth;
    private boolean m_BlankRoot = false;

    public FixedRowWidthEqualizer(TextTree textTree, int n) {
        this.m_Width = n;
        this.m_TotalDepth = textTree.getDepth();
        this.applyWidths(textTree.getRoot(), n, 0);
    }

    @Override
    public int[] getWidths() {
        int[] nArray = new int[this.m_Depth + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.m_Width;
        }
        if (this.m_BlankRoot) {
            nArray[0] = 0;
        }
        return nArray;
    }

    private void applyWidths(TextTree.TextEx textEx, int n, int n2) {
        if (this.m_Depth < n2) {
            this.m_Depth = n2;
        }
        if (textEx.hasText() || n2 > 0) {
            if (textEx.hasChildren()) {
                textEx.setWidth(n);
            } else if (n2 < this.m_TotalDepth) {
                textEx.setWidth(n * (this.m_TotalDepth - n2));
            }
        } else {
            this.m_BlankRoot = true;
        }
        Iterator<TextTree.TextEx> iterator = textEx.getChildIterator();
        while (iterator.hasNext()) {
            this.applyWidths(iterator.next(), n, n2 + 1);
        }
    }
}

