/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.graphics.Graphics2DWrapper;
import com.elixirtech.graphics.IGraphics2D;
import com.elixirtech.js.BasicScope;
import com.elixirtech.js.PrivilegedJavaProxy;
import com.elixirtech.js.ScriptException;
import com.elixirtech.js.ScriptManager;
import com.elixirtech.map.model.MapFile;
import com.elixirtech.map.sax.MapFileLoader;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.logical.renderer.ReportMapView;
import com.elixirtech.report2.raw.model.MapElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLRepository;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.Scriptable;

public class MapRenderer
extends BasicLogicalRenderer {
    public static long i = 0L;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MapRenderer.class);
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        MapElement mapElement = (MapElement)rawModelElement;
        if (mapElement.isVisible()) {
            try {
                ReportSubstitution reportSubstitution = new ReportSubstitution();
                Rectangle rectangle = MapRenderer.buildRect(mapElement);
                rectangle.setCurvedClip(true);
                rectangle.setPaddedClip(true);
                com.elixirtech.report2.logical.model.Image image = new com.elixirtech.report2.logical.model.Image();
                image.setRaw(mapElement);
                this.insetBorder(mapElement, image);
                image.setSizeMode("Clip");
                image.setHorizontalAlign("Left");
                image.setVerticalAlign("Top");
                Script script = mapElement.getScript();
                if (!Script.isEmpty(script)) {
                    this.drawScriptedImage(logicalRenderContext, mapElement, image, script, reportSubstitution);
                } else {
                    MapRenderer.loadMap(logicalRenderContext, mapElement, image, reportSubstitution);
                }
                rectangle.addLogicalElement(image);
                logicalRenderContext.addElement(rectangle);
            }
            catch (Throwable throwable) {
                m_Log.error((Object)("Can't render map " + mapElement.getName() + ": " + throwable.getMessage()));
                m_Log.warn((Object)"Stack Trace", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawScriptedImage(LogicalRenderContext logicalRenderContext, MapElement mapElement, com.elixirtech.report2.logical.model.Image image, Script script, ReportSubstitution reportSubstitution) throws IOException {
        java.awt.Rectangle rectangle = MapRenderer.loadMap(logicalRenderContext, mapElement, image, reportSubstitution);
        if (mapElement.isLoadError()) {
            m_Log.warn((Object)("Load map error" + mapElement.getName()));
            return;
        }
        Image image2 = image.getImage();
        Graphics2D graphics2D = (Graphics2D)image2.getGraphics();
        try {
            int n = image2.getHeight(null);
            int n2 = image2.getWidth(null);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            IGraphics2D iGraphics2D = PrivilegedJavaProxy.getProxy(IGraphics2D.class, new Graphics2DWrapper(graphics2D));
            java.awt.Rectangle rectangle2 = new java.awt.Rectangle(0, 0, n2, n);
            hashMap.put("g", iGraphics2D);
            hashMap.put("rc", rectangle2);
            hashMap.put("plotrc", rectangle);
            BasicScope basicScope = new BasicScope(hashMap);
            this.execute(basicScope, "MapPaint", ArgumentMap.substitute(script.getText(), reportSubstitution));
            image.setPicture(image.getPicture() + i++);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public Object execute(BasicScope basicScope, String string, String string2) {
        try {
            ArrayList<Scriptable> arrayList = new ArrayList<Scriptable>();
            arrayList.add((Scriptable)basicScope);
            ScriptManager scriptManager = new ScriptManager(string);
            return scriptManager.evaluate(arrayList, string, string2);
        }
        catch (ScriptException scriptException) {
            m_JSLog.warn((Object)(string + ": " + String.valueOf(scriptException)));
            return null;
        }
    }

    public static java.awt.Rectangle loadMap(LogicalRenderContext logicalRenderContext, MapElement mapElement, com.elixirtech.report2.logical.model.Image image, ReportSubstitution reportSubstitution) {
        RMLRepository rMLRepository = (RMLRepository)Elixir.get(RMLRepository.class);
        RMLFileObject rMLFileObject = rMLRepository.getFileJ(mapElement.getMapFile());
        MapFile mapFile = null;
        if (rMLFileObject != null) {
            try {
                mapFile = MapFileLoader.readMap(rMLFileObject);
            }
            catch (IOException iOException) {
                mapElement.setLoadError(true);
                m_Log.error((Object)("Unable to load mapfile \"" + mapElement.getMapFile() + "\": " + String.valueOf(iOException)), (Throwable)iOException);
                return null;
            }
        }
        if (mapFile != null) {
            ReportMapView reportMapView = new ReportMapView(logicalRenderContext, mapElement, mapFile, reportSubstitution);
            reportMapView.refresh();
            int n = image.getWidth() / 20;
            int n2 = image.getHeight() / 20;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            reportMapView.paint(graphics2D, new Dimension(n, n2));
            graphics2D.dispose();
            image.setImage(bufferedImage);
            java.awt.Rectangle rectangle = reportMapView.getPlotRect();
            return rectangle;
        }
        mapElement.setLoadError(true);
        return null;
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

