/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.datasource.filter.Filter;
import com.elixirtech.data2.datasource.filter.FilteredDefinition;
import com.elixirtech.data2.datasource.filter.JavaScriptFilter;
import com.elixirtech.data2.olap.CubeGrouping;
import com.elixirtech.data2.olap.TreeNode;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.js.BasicScope;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.Label;
import com.elixirtech.report2.raw.model.CellRender;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.FormatUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.mozilla.javascript.Scriptable;

public class TextTable {
    private DataTable m_Table;
    private DataSchema m_Schema;
    private IFontMeasurer[] m_FontMeasurers;
    private int m_SkipCols;
    private int m_ColLevels;
    private int m_LineHeight;
    private Column[] m_Columns;
    private BasicScope m_BaseScope;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TextTable.class);

    public TextTable(CubeGrouping cubeGrouping, CubeGrouping cubeGrouping2, boolean bl, boolean bl2, DataTable dataTable, IFontMeasurer[] iFontMeasurerArray, CubeMeasure[] cubeMeasureArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        this.m_Table = dataTable;
        this.m_FontMeasurers = iFontMeasurerArray;
        this.m_SkipCols = n;
        this.m_ColLevels = n2;
        this.m_LineHeight = n3;
        this.m_Schema = this.m_Table.getSchema();
        this.m_BaseScope = new BasicScope();
        FilterHolder[] filterHolderArray = new FilterHolder[cubeMeasureArray.length];
        for (n6 = 0; n6 < filterHolderArray.length; ++n6) {
            filterHolderArray[n6] = new FilterHolder(cubeMeasureArray[n6], this.m_Schema.getColumnType(this.m_SkipCols + n6));
        }
        n6 = this.m_Schema.getColumnCount();
        this.m_Columns = new Column[n6 - this.m_SkipCols];
        for (int i = 0; i < this.m_Columns.length; ++i) {
            this.m_Columns[i] = new Column();
            this.m_Columns[i].setLevel(new Integer(this.getLevel(i)));
        }
        List<TreeNode> list = TextTable.buildNodes(cubeGrouping.getRoot(), bl);
        List<TreeNode> list2 = TextTable.buildNodes(cubeGrouping2.getRoot(), bl2);
        DataRecord[] dataRecordArray = this.m_Table.getRecords();
        for (n5 = 0; n5 < dataRecordArray.length; ++n5) {
            n4 = !list.get(n5).isLeaf() ? 1 : 0;
            for (int i = 0; i < this.m_Columns.length; ++i) {
                Object[] objectArray;
                boolean bl3 = n4 != 0 || !list2.get(i / cubeMeasureArray.length).isLeaf();
                CubeMeasure cubeMeasure = cubeMeasureArray[i % cubeMeasureArray.length];
                FilterHolder filterHolder = filterHolderArray[i % cubeMeasureArray.length];
                Object object = dataRecordArray[n5].getData(this.m_SkipCols + i);
                Label label = new Label();
                label.setBackgroundColor(cubeMeasure.getBackgroundColor());
                Rectangle rectangle = label.getRectangle();
                rectangle.setBorderLeft(cubeMeasure.isBorderLeft());
                rectangle.setBorderRight(cubeMeasure.isBorderRight());
                rectangle.setBorderTop(cubeMeasure.isBorderTop());
                rectangle.setBorderBottom(cubeMeasure.isBorderBottom());
                rectangle.setBorderColor(cubeMeasure.getBorderColor());
                rectangle.setBorderStyle(cubeMeasure.getBorderStyle());
                rectangle.setBorderWidth(cubeMeasure.getBorderWidth());
                rectangle.setPaddingLeft(cubeMeasure.getPaddingLeft());
                rectangle.setPaddingTop(cubeMeasure.getPaddingTop());
                rectangle.setPaddingRight(cubeMeasure.getPaddingRight());
                rectangle.setPaddingBottom(cubeMeasure.getPaddingBottom());
                rectangle.setKeepTogether(true);
                if (cubeMeasure.isShowText() && object != null) {
                    objectArray = this.getFormattedString(object, cubeMeasure);
                    label.setText(this.m_FontMeasurers[n5 % cubeMeasureArray.length], (String)objectArray, cubeMeasure.getTextAlignment());
                    label.setFontColor(cubeMeasure.getFontColor());
                    label.setFontName(cubeMeasure.getFontName());
                    label.setFontBold(cubeMeasure.isFontBold());
                    label.setFontItalic(cubeMeasure.isFontItalic());
                    label.setFontSize(cubeMeasure.getFontSize());
                    label.setFontUnderline(cubeMeasure.isFontUnderline());
                    label.setFontStrikethrough(cubeMeasure.isFontStrikethrough());
                }
                objectArray = new Object[]{object};
                DataRecord dataRecord = new DataRecord(filterHolder.schema, objectArray);
                this.m_BaseScope.put("Row", new Integer(n5));
                this.m_BaseScope.put("Column", new Integer(i));
                int n7 = 0;
                for (int j = this.m_SkipCols - 1; j >= 0 && dataRecordArray[n5].getData(j) == null; --j) {
                    ++n7;
                }
                this.m_BaseScope.put("RowLevel", new Integer(n7));
                Integer n8 = this.m_Columns[i].getLevel();
                this.m_BaseScope.put("ColumnLevel", n8);
                if (!bl3) {
                    try {
                        for (int j = 0; j < filterHolder.filters.length; ++j) {
                            if (!filterHolder.filters[j].accept(dataRecord)) continue;
                            CellRender cellRender = cubeMeasure.getCellRender(j);
                            label.setBackgroundColor(cellRender.getBackground());
                            label.setFontColor(cellRender.getForeground());
                            if (cubeMeasure.isShowIcon() && StringUtil.notEmpty(cellRender.getIconName())) {
                                label.setImage(cellRender.getIconName(), cubeMeasure.getIconAlignment());
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        m_Log.warn((Object)("problem during cell render processing: " + String.valueOf(throwable)), throwable);
                    }
                }
                label.layout();
                label.setHeight(this.m_LineHeight);
                this.m_Columns[i].addLabel(label);
            }
        }
        n5 = 0;
        for (n4 = 0; n4 < this.m_Columns.length; ++n4) {
            this.m_Columns[n4].setLeft(n5);
            this.m_Columns[n4].setWidths();
            n5 += this.m_Columns[n4].getWidth();
        }
    }

    private static List<TreeNode> buildNodes(TreeNode treeNode, boolean bl) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        TextTable.buildNodes(treeNode, arrayList, bl);
        return arrayList;
    }

    private static void buildNodes(TreeNode treeNode, List<TreeNode> list, boolean bl) {
        if (bl) {
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                TextTable.buildNodes(treeNode2, list, bl);
            }
            if (treeNode.isLeaf() || treeNode.isShowTotals()) {
                list.add(treeNode);
            }
        } else {
            if (treeNode.isLeaf() || treeNode.isShowTotals()) {
                list.add(treeNode);
            }
            for (TreeNode treeNode3 : treeNode.getChildren()) {
                TextTable.buildNodes(treeNode3, list, bl);
            }
        }
    }

    public void adjustColumns(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.m_Columns.length; ++i) {
            int n4;
            int n5 = n3;
            int n6 = this.m_Columns[i].getWidth();
            if (n5 < n && n5 + n6 > n) {
                n4 = n + 20;
                this.m_Columns[i].setLeft(n4);
                n3 = n4 + n6;
                continue;
            }
            if (n5 > n) {
                n5 -= n;
                n4 = n;
                while (n5 > n2) {
                    n5 -= n2;
                    n4 += n2;
                }
                if (n5 < n2 && n5 + n6 > n2) {
                    int n7 = n4 + n2 + 20;
                    this.m_Columns[i].setLeft(n7);
                    n3 = n7 + n6;
                    continue;
                }
                this.m_Columns[i].setLeft(n3);
                n3 += n6;
                continue;
            }
            this.m_Columns[i].setLeft(n3);
            n3 += n6;
        }
    }

    private int getLevel(int n) {
        String string = this.m_Schema.getColumnName(this.m_SkipCols + n);
        String[] stringArray = string.split("/");
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!StringUtil.notEmpty(stringArray[i])) continue;
            ++n2;
        }
        return this.m_ColLevels - n2 + 1;
    }

    private String getFormattedString(Object object, CubeMeasure cubeMeasure) {
        if (object != null && !(object instanceof String)) {
            Serializable serializable;
            if (object instanceof Double ? ((Double)(serializable = (Double)object)).isNaN() || ((Double)serializable).isInfinite() : object instanceof Float && (((Float)(serializable = (Float)object)).isNaN() || ((Float)serializable).isInfinite())) {
                return "";
            }
            serializable = cubeMeasure.getFormat();
            if (serializable != null && ((Format)serializable).getType() != "None") {
                java.text.Format format = ((Format)serializable).getFormatter();
                if (format == null) {
                    Locale locale = cubeMeasure.getLocale();
                    format = FormatUtil.buildFormatter((Format)serializable, locale);
                    ((Format)serializable).setFormatter(format);
                }
                if (format != null) {
                    object = format.format(object);
                }
            }
        }
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_Columns.length;
    }

    public int getColumnLeft(int n) {
        return this.m_Columns[n].getLeft();
    }

    public int getColumnWidth(int n) {
        return this.m_Columns[n].getWidth();
    }

    public void setColumnWidth(int n, int n2) {
        int n3 = n2 - this.m_Columns[n].getWidth();
        this.m_Columns[n].setWidth(n2);
        for (int i = n + 1; i < this.m_Columns.length; ++i) {
            this.m_Columns[i].shiftLeft(n3);
        }
    }

    public Iterator<Label> getLabelIterator() {
        ArrayList<Label> arrayList = new ArrayList<Label>();
        for (int i = 0; i < this.m_Columns.length; ++i) {
            this.m_Columns[i].buildAll(arrayList);
        }
        return arrayList.iterator();
    }

    private class FilterHolder {
        public Filter[] filters;
        public DataSchema schema;

        public FilterHolder(CubeMeasure cubeMeasure, DataType dataType) {
            DefaultPushContext defaultPushContext = new DefaultPushContext();
            this.schema = new DataSchema(true, new String[]{"Value"}, new DataType[]{dataType});
            this.filters = new Filter[cubeMeasure.getCellRenderCount()];
            for (int i = 0; i < this.filters.length; ++i) {
                CellRender cellRender = cubeMeasure.getCellRender(i);
                this.filters[i] = FilteredDefinition.getFilter("Value", cellRender.getWhen(), cellRender.getTest());
                try {
                    if (this.filters[i] instanceof JavaScriptFilter) {
                        ((JavaScriptFilter)this.filters[i]).setBaseScope((Scriptable)TextTable.this.m_BaseScope);
                    }
                    this.filters[i].setSchema(defaultPushContext, this.schema);
                    continue;
                }
                catch (Exception exception) {
                    m_Log.warn((Object)("Can't set test schema: " + String.valueOf(exception)));
                }
            }
        }
    }

    private static class Column {
        private int m_Width;
        private int m_X = 0;
        private int m_Y = 0;
        private List<Label> m_Labels = new ArrayList<Label>();
        private Integer m_Level;

        private Column() {
        }

        public int getLeft() {
            return this.m_X;
        }

        public int getWidth() {
            return this.m_Width;
        }

        public void setWidth(int n) {
            this.m_Width = n;
            this.setWidths();
        }

        public void setLeft(int n) {
            this.m_X = n;
            Iterator<Label> iterator = this.m_Labels.iterator();
            while (iterator.hasNext()) {
                iterator.next().setLeft(n);
            }
        }

        public void shiftLeft(int n) {
            for (Label label : this.m_Labels) {
                label.setLeft(label.getLeft() + n);
            }
        }

        public void buildAll(List<Label> list) {
            list.addAll(this.m_Labels);
        }

        public void addLabel(Label label) {
            label.setTop(this.m_Y);
            this.m_Y += label.getHeight();
            this.m_Labels.add(label);
            if (label.getWidth() > this.m_Width) {
                this.m_Width = label.getWidth();
            }
        }

        public void setWidths() {
            Iterator<Label> iterator = this.m_Labels.iterator();
            while (iterator.hasNext()) {
                iterator.next().setWidth(this.m_Width);
            }
        }

        public void setLevel(Integer n) {
            this.m_Level = n;
        }

        public Integer getLevel() {
            return this.m_Level;
        }
    }
}

