/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.graphics.font.AWTFontMeasurerFactory;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.IFontMeasurerFactory;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.RenderContext;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.physical.PhysicalRenderer;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.util.VariableSubstitution;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class PhysicalRenderContext
extends RenderContext {
    protected PhysicalRenderer m_Renderer;
    protected IFontMeasurerFactory m_FontMeasurerFactory;
    protected Page m_Page;
    protected String m_MimeType;
    protected VariableSubstitution m_VariableSubstitution;
    protected int m_HPageNo;
    protected int m_HShift;
    protected String m_PageNumber;
    protected String m_PageCount;

    public PhysicalRenderContext(PhysicalRenderer physicalRenderer, int n, Page page, Map<String, Object> map) {
        super(map);
        this.m_Renderer = physicalRenderer;
        this.m_FontMeasurerFactory = new AWTFontMeasurerFactory();
        this.m_Page = page;
        this.m_HPageNo = n;
        this.buildVariableSubstitution();
        PageSetup pageSetup = page.getPageSetup();
        int n2 = pageSetup.getLeft();
        int n3 = pageSetup.getRight();
        int n4 = pageSetup.getWidth();
        this.m_HShift = (n4 - n2 - n3) * (this.m_HPageNo - 1);
    }

    public RenderDetails getRenderDetails(MimeType mimeType) {
        return this.m_Renderer.getRenderDetails(mimeType);
    }

    public Page getPage() {
        return this.m_Page;
    }

    public int getHShift() {
        return this.m_HShift;
    }

    public abstract Point getOffset();

    public String substituteVariables(String string) {
        string = StringUtil.findAndReplace(string, RenderConstants.PAGE_NUMBER_STRING, this.m_PageNumber);
        string = StringUtil.findAndReplace(string, RenderConstants.PAGE_COUNT_STRING, this.m_PageCount);
        return this.m_VariableSubstitution.substitute(string);
    }

    public void render(Iterator<LogicalElement> iterator) {
        while (iterator.hasNext()) {
            this.m_Renderer.render2(this, iterator.next());
        }
    }

    public IFontMeasurer getFontMeasurer(Font font) {
        return this.m_FontMeasurerFactory.getInstance(font);
    }

    @Override
    public void dispose() {
    }

    protected void buildVariableSubstitution() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.m_PageNumber = Integer.toString(this.m_Page.getPageNumber());
        this.m_PageCount = Integer.toString(this.m_Page.getPageCount());
        hashMap.put("#", this.m_PageNumber);
        hashMap.put("##", this.m_PageCount);
        hashMap.put("@", this.m_PageNumber + " of " + this.m_PageCount);
        this.m_VariableSubstitution = new VariableSubstitution(hashMap);
    }
}

