/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.docx;

import com.elixirtech.cell.CellStructure;
import com.elixirtech.opc.doc.FileBasedDocument;
import com.elixirtech.opc.doc.SectionProperties;
import com.elixirtech.opc.doc.SectionProperties$;
import com.elixirtech.opc.doc.Table;
import com.elixirtech.opc.doc.VGap;
import com.elixirtech.report2.js.IProperties;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.physical.docx.CSBuilder;
import com.elixirtech.report2.physical.docx.ChunkAnalysis;
import com.elixirtech.report2.physical.docx.ChunkAnalysis$;
import com.elixirtech.report2.physical.docx.DocxGenerator$;
import com.elixirtech.report2.physical.docx.PageInfo;
import com.elixirtech.report2.physical.docx.PageInfo$;
import com.elixirtech.report2.physical.docx.TableBuilder;
import com.elixirtech.report2.physical.docx.poi.Conformer$;
import com.elixirtech.report2.physical.docx.poi.Watermarker$;
import com.elixirtech.report2.raw.model.PageSetup;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class DocxGenerator {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DocxGenerator.class.getDeclaredField("document$lzy1"));
    private final LogicalRenderContext cxt;
    private boolean _addPageBreakBefore;
    private Option<Page> _currentPage;
    private final Queue<Page> cachedPages;
    private volatile Object document$lzy1;

    public static List<String> Namespaces() {
        return DocxGenerator$.MODULE$.Namespaces();
    }

    public static void hex(StringBuilder stringBuilder, int n) {
        DocxGenerator$.MODULE$.hex(stringBuilder, n);
    }

    public static String hexColor(Color color) {
        return DocxGenerator$.MODULE$.hexColor(color);
    }

    public static String lookupBorderStyle(String string) {
        return DocxGenerator$.MODULE$.lookupBorderStyle(string);
    }

    public DocxGenerator(LogicalRenderContext cxt) {
        this.cxt = cxt;
        this._addPageBreakBefore = false;
        this._currentPage = None$.MODULE$;
        this.cachedPages = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
    }

    public FileBasedDocument document() {
        Object object = this.document$lzy1;
        if (object instanceof FileBasedDocument) {
            return (FileBasedDocument)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FileBasedDocument)this.document$lzyINIT1();
    }

    private Object document$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.document$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FileBasedDocument fileBasedDocument = null;
                    try {
                        fileBasedDocument = new FileBasedDocument(this){
                            private final /* synthetic */ DocxGenerator $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public void append(String s) {
                                super.append(this.$outer.com$elixirtech$report2$physical$docx$DocxGenerator$$reduce(s));
                            }
                        };
                        object2 = fileBasedDocument == null ? LazyVals.NullValue$.MODULE$ : fileBasedDocument;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.document$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return fileBasedDocument;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void startPageSequence(PageSequence ps) {
    }

    public void endPageSequence(PageSequence ps) {
    }

    public void renderPage(Page p) {
        this.cachedPages.$plus$eq((Object)p);
    }

    public int pageCount() {
        return this.cachedPages.size();
    }

    public void outputPage(Page p, PageInfo pageInfo) {
        this._currentPage.foreach((Function1)(JProcedure1 & Serializable)cp -> {
            this._addPageBreakBefore = true;
        });
        this._currentPage = Some$.MODULE$.apply((Object)p);
        Option$.MODULE$.apply((Object)p.getPageHeader()).foreach((Function1)(JProcedure1 & Serializable)holder -> this.render((LogicalElementHolder)holder, pageInfo));
        Option$.MODULE$.apply((Object)p.getBody()).foreach((Function1)(JProcedure1 & Serializable)_$1 -> CollectionConverters$.MODULE$.ListHasAsScala(_$1.getBodyPartList()).asScala().foreach((Function1)(JProcedure1 & Serializable)holder -> this.render((LogicalElementHolder)holder, pageInfo)));
        Option$.MODULE$.apply((Object)p.getPageFooter()).foreach((Function1)(JProcedure1 & Serializable)pf -> {
            PageSetup ps = p.getPageSetup();
            int headerHeight = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)p.getPageHeader()).map((Function1 & Serializable)_$2 -> _$2.getHeight()).getOrElse(DocxGenerator::$anonfun$2));
            int usedHeight = headerHeight + BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.ListHasAsScala(p.getBody().getBodyPartList()).asScala().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> DocxGenerator.$anonfun$3(BoxesRunTime.unboxToInt((Object)x$1), (BodyPart)x$2)));
            int bodyHeight = ps.getHeight() - ps.getBottom() - ps.getTop();
            int gap = bodyHeight - usedHeight - pf.getHeight();
            this.document().add(new VGap(ps.getWidth() - ps.getLeft() - ps.getRight(), gap));
            this.render((LogicalElementHolder)pf, pageInfo);
        });
        Option$.MODULE$.apply((Object)p.getPageHeader()).foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.removeAllLogicalElements());
        Option$.MODULE$.apply((Object)p.getBody()).foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.removeAllBodyParts());
        Option$.MODULE$.apply((Object)p.getPageFooter()).foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.removeAllLogicalElements());
    }

    public void endReport() {
        int pageCount = this.cachedPages.size();
        int pageNo = 0;
        while (this.cachedPages.nonEmpty()) {
            Page p2 = (Page)this.cachedPages.dequeue();
            this.outputPage(p2, PageInfo$.MODULE$.apply(pageNo, pageCount));
            ++pageNo;
        }
        this._currentPage.foreach((Function1)(JProcedure1 & Serializable)p -> this.document().add(this.getSectionProperties((Page)p)));
    }

    public void writeTo(OutputStream os) {
        IProperties props = this.cxt.getProperties();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.document().output(baos);
        Option option = Option$.MODULE$.apply((Object)props.get("elx.rml.docx.watermark.text"));
        if (option instanceof Some) {
            String txt = (String)((Some)option).value();
            String color = (String)Option$.MODULE$.apply((Object)props.get("elx.rml.docx.watermark.color")).getOrElse(DocxGenerator::$anonfun$4);
            Watermarker$.MODULE$.addWatermark(baos.toByteArray(), txt, color, os);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Conformer$.MODULE$.conform(baos.toByteArray(), os);
            return;
        }
        throw new MatchError((Object)option);
    }

    private void render(LogicalElementHolder holder, PageInfo pageInfo) {
        if (holder.getHeight() == 0) {
            return;
        }
        ChunkAnalysis analysis = ChunkAnalysis$.MODULE$.apply(holder);
        CSBuilder csb = new CSBuilder(pageInfo, this.cxt, this.document());
        CellStructure cs = csb.render(analysis, holder);
        TableBuilder tb = new TableBuilder(this.cxt, this.document());
        Table table = tb.render(analysis, cs);
        if (this._addPageBreakBefore) {
            table.setPageBreakBefore();
            this._addPageBreakBefore = false;
        }
        this.document().add(table);
    }

    private SectionProperties getSectionProperties(Page p) {
        PageSetup ps = p.getPageSetup();
        SectionProperties sectionProperties = new SectionProperties();
        String string = ps.getOrientation();
        String string2 = "Portrait";
        sectionProperties.orientation_$eq(!(string != null ? !string.equals(string2) : string2 != null) ? SectionProperties$.MODULE$.Portrait() : SectionProperties$.MODULE$.Landscape());
        sectionProperties.width_$eq(ps.getWidth());
        sectionProperties.height_$eq(ps.getHeight());
        sectionProperties.top_$eq(ps.getTop());
        sectionProperties.left_$eq(ps.getLeft());
        sectionProperties.bottom_$eq(ps.getBottom() / 2);
        sectionProperties.right_$eq(ps.getRight());
        sectionProperties.header_$eq(0);
        sectionProperties.footer_$eq(0);
        return sectionProperties;
    }

    public String com$elixirtech$report2$physical$docx$DocxGenerator$$reduce(String s2) {
        return (String)DocxGenerator$.MODULE$.Namespaces().foldLeft((Object)s2, (Function2 & Serializable)(s, ns) -> s.replace((CharSequence)ns, ""));
    }

    private static final int $anonfun$2() {
        return 0;
    }

    private static final /* synthetic */ int $anonfun$3(int x$1, BodyPart x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            int h = BoxesRunTime.unboxToInt((Object)tuple2._1());
            BodyPart bp = (BodyPart)tuple2._2();
            return h + bp.getHeight();
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String $anonfun$4() {
        return "#999999";
    }
}

