/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.glint;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.glint.BasicPhysicalRenderer;
import com.elixirtech.report2.raw.constants.Alignment;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageRenderer
extends BasicPhysicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ImageRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        Object object;
        com.elixirtech.report2.logical.model.Image image = (com.elixirtech.report2.logical.model.Image)logicalElement;
        GlintRenderContext glintRenderContext = (GlintRenderContext)physicalRenderContext;
        IGlint iGlint = glintRenderContext.getGlint();
        int n = image.getLeft();
        int n2 = image.getTop();
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        String string = image.getPicture();
        Image image2 = null;
        IGlint.ImageId imageId = null;
        CacheItem cacheItem = (CacheItem)physicalRenderContext.getCache(string);
        if (cacheItem != null) {
            imageId = cacheItem.imageId;
            image2 = cacheItem.image;
            if (imageId == null) {
                cacheItem.imageId = imageId = iGlint.defineImage(image2);
            }
        } else if (image.getImage() == null) {
            try {
                object = URLLoader.load(string);
                image2 = Image.getInstance((byte[])object, string);
                imageId = iGlint.defineImage(image2);
                glintRenderContext.setCache(string, new CacheItem(imageId, image2));
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Can't load " + string + ": " + String.valueOf(iOException)));
            }
        } else {
            try {
                object = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((Object)image.getImage()), "PNG", (OutputStream)object);
                image2 = Image.getInstance(((ByteArrayOutputStream)object).toByteArray(), string);
                imageId = iGlint.defineImage(image2);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't generate image: " + String.valueOf(exception)));
            }
        }
        if (image2 != null) {
            int n5 = Alignment.getAlignmentId(image.getHorizontalAlign(), image.getVerticalAlign());
            String string2 = image.getSizeMode();
            int n6 = image2.getWidth();
            int n7 = image2.getHeight();
            Dimension dimension = new Dimension(n6 * 20, n7 * 20);
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            if (string2.equals("Clip")) {
                Rectangle rectangle2 = new Rectangle(0, 0, n6 * 20, n7 * 20);
                Rectangle rectangle3 = new Rectangle(n, n2, n3, n4);
                Alignment.clipImageRect(rectangle2, rectangle3, n5);
                iGlint.drawSubImage(imageId, rectangle3.x, rectangle3.y, rectangle2.x / 20, rectangle2.y / 20, rectangle2.width / 20, rectangle2.height / 20);
            } else if (string2.equals("Stretch")) {
                iGlint.drawScaledImage(imageId, n, n2, n3, n4);
            } else if (string2.equals("Zoom")) {
                double d = (double)n3 / (double)dimension.width;
                double d2 = (double)n4 / (double)dimension.height;
                if (d >= d2) {
                    dimension.width = (int)(d2 * (double)dimension.width);
                    dimension.height = n4;
                } else {
                    dimension.width = n3;
                    dimension.height = (int)(d * (double)dimension.height);
                }
                rectangle = Alignment.positionRect(rectangle, dimension, n5);
                iGlint.drawScaledSubImage(imageId, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, n6, n7);
            }
        } else {
            object = new IGlint.ColorId(0);
            IGlint.PenId penId = iGlint.definePen(Pen.newInstance(Color.BLACK, 1));
            m_Log.warn((Object)("Can't locate image: " + string));
            iGlint.drawRect(penId, (IGlint.ColorId)object, n, n2, n3, n4);
            iGlint.drawLine(penId, n, n2, n + n3 - 1, n2 + n4 - 1);
            iGlint.drawLine(penId, n + n3 - 1, n2, n, n2 + n4 - 1);
        }
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    public static class CacheItem {
        public IGlint.ImageId imageId;
        public Image image;

        public CacheItem(IGlint.ImageId imageId, Image image) {
            this.imageId = imageId;
            this.image = image;
        }
    }
}

