/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.glint;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.ColorManager;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Pen;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.glint.BasicPhysicalRenderer;
import java.util.Iterator;

public class RectRenderer
extends BasicPhysicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RectRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        Iterator<LogicalElement> iterator;
        int n;
        Rectangle rectangle = (Rectangle)logicalElement;
        int n2 = rectangle.getLeft();
        int n3 = rectangle.getTop();
        int n4 = rectangle.getWidth();
        int n5 = rectangle.getHeight();
        int n6 = rectangle.getBorderRadius();
        if (n6 > (n = Math.min(n4 / 2, n5 / 2))) {
            n6 = n;
        }
        if (n5 <= 4 && "Below".equals(rectangle.getSplit())) {
            return;
        }
        int n7 = rectangle.getBorderWidth();
        if (n7 < 0) {
            n7 = 0;
        }
        int n8 = n7 / 2;
        GlintRenderContext glintRenderContext = (GlintRenderContext)physicalRenderContext;
        IGlint iGlint = glintRenderContext.getGlint();
        String string = rectangle.getBackgroundColor();
        Color color = ColorManager.lookup(string);
        Pen pen = Pen.NONE;
        int n9 = 0;
        BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
        if (borderStyle != null && borderStyle != BorderStyle.NONE && n7 > 0) {
            iterator = ColorManager.lookup(rectangle.getBorderColor());
            pen = Pen.newInstance((Color)((Object)iterator), n7, borderStyle.ID);
            if (rectangle.isBorderLeft()) {
                n9 |= 1;
            }
            if (rectangle.isBorderTop()) {
                n9 |= 2;
            }
            if (rectangle.isBorderRight()) {
                n9 |= 4;
            }
            if (rectangle.isBorderBottom()) {
                n9 |= 8;
            }
        }
        if (n6 == 0) {
            iGlint.drawCellRect(iGlint.definePen(pen), iGlint.defineColor(color), n2, n3, n4, n5, n9);
        } else {
            iGlint.drawRoundCellRect(iGlint.definePen(pen), iGlint.defineColor(color), n2, n3, n4, n5, n6, n6, n9);
        }
        if (rectangle.isNoClip()) {
            iterator = rectangle.getLogicalElementIterator();
            glintRenderContext.render(iterator);
        } else {
            iterator = rectangle.getLogicalElementIterator();
            if (iterator.hasNext()) {
                int n10 = n2 + n4;
                int n11 = n3 + n5;
                if (borderStyle != BorderStyle.NONE && n7 > 0) {
                    if (rectangle.isBorderLeft()) {
                        n2 += n7;
                    }
                    if (rectangle.isBorderTop()) {
                        n3 += n7;
                    }
                    if (rectangle.isBorderRight()) {
                        n10 -= n7;
                    }
                    if (rectangle.isBorderBottom()) {
                        n11 -= n7;
                    }
                }
                if (rectangle.isPaddedClip() || rectangle.isCurvedClip()) {
                    n2 += rectangle.getPaddingLeft();
                    n3 += rectangle.getPaddingTop();
                    n10 -= rectangle.getPaddingRight();
                    n11 -= rectangle.getPaddingBottom();
                }
                if (n6 == 0 || !rectangle.isCurvedClip()) {
                    iGlint.pushClip(n2, n3, n10 - n2, n11 - n3);
                } else {
                    int n12 = n6 - (rectangle.getPaddingLeft() + rectangle.getPaddingRight()) / 2;
                    if ((n12 -= n8) < 0) {
                        n12 = 0;
                    }
                    int n13 = n6 - (rectangle.getPaddingTop() + rectangle.getPaddingBottom()) / 2;
                    iGlint.pushClip(n2, n3, n10 - n2, n11 - n3, n12, n13 -= n8, n9);
                }
                glintRenderContext.render(iterator);
                iGlint.popClip();
            }
        }
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

