/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.odf;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.ImageUtil;
import com.elixirtech.report2.physical.odf.OdfGenerator$;
import com.elixirtech.report2.physical.odf.OdfImage;
import com.elixirtech.report2.physical.odf.OdfRectangle;
import com.elixirtech.report2.physical.odf.OdfRenderContext;
import com.elixirtech.report2.physical.odf.OdfSheet;
import com.elixirtech.report2.physical.odf.OdfText;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.util.ImageLoader;
import com.elixirtech.report2.util.VariableSubstitution;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class OdfGenerator
implements SLF4J,
LoggingHelper {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(OdfGenerator.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final LogicalReport report;
    private final OdfRenderContext m_RenderContext;
    private final VariableSubstitution m_VariableSubstitution;
    private boolean m_Snap;
    private final ListBuffer<OdfSheet> m_Pages;
    private String m_PageNumber;
    private String m_PageCount;

    public static int BigSnap() {
        return OdfGenerator$.MODULE$.BigSnap();
    }

    public static int NoSnap() {
        return OdfGenerator$.MODULE$.NoSnap();
    }

    public OdfGenerator(LogicalReport report, OutputStream output) {
        this.report = report;
        this.m_RenderContext = new OdfRenderContext(this, report, output);
        this.m_VariableSubstitution = new VariableSubstitution();
        this.m_Snap = false;
        this.m_Pages = new ListBuffer();
        this.m_PageNumber = "";
        this.m_PageCount = "";
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void setSnap(boolean b) {
        this.m_Snap = b;
    }

    public int getPageCount() {
        return this.m_Pages.size();
    }

    public void renderPage(Page page) {
        Map<String, String> map = this.m_VariableSubstitution.getMap();
        this.m_PageNumber = BoxesRunTime.boxToInteger((int)page.getPageNumber()).toString();
        this.m_PageCount = BoxesRunTime.boxToInteger((int)page.getPageCount()).toString();
        map.put("#", this.m_PageNumber);
        map.put("##", this.m_PageCount);
        map.put("@", this.m_PageNumber + " of " + this.m_PageCount);
        PageSetup ps = page.getPageSetup();
        OdfSheet sheet = this.newSheet(this.getTitle(page), ps);
        Option$.MODULE$.apply((Object)page.getPageHeader()).foreach((Function1)(JProcedure1 & Serializable)ph -> this.renderElements(sheet, (LogicalElementHolder)ph));
        CollectionConverters$.MODULE$.ListHasAsScala(page.getBody().getBodyPartList()).asScala().foreach((Function1)(JProcedure1 & Serializable)bp -> this.renderElements(sheet, (LogicalElementHolder)bp));
        Option$.MODULE$.apply((Object)page.getPageFooter()).foreach((Function1)(JProcedure1 & Serializable)pf -> {
            int y = ps.getHeight() - ps.getBottom() - pf.getHeight();
            sheet.offsetY(y - sheet.y());
            this.renderElements(sheet, (LogicalElementHolder)pf);
        });
        try {
            sheet.render(this.m_RenderContext);
            this.m_Pages.$plus$eq((Object)sheet);
            this.m_RenderContext.saveSheet();
        }
        catch (Exception ex) {
            this.error(() -> OdfGenerator.renderPage$$anonfun$4(ex), ex, Line$.MODULE$.apply(80), FullName$.MODULE$.apply("com.elixirtech.report2.physical.odf.OdfGenerator.renderPage"));
            throw new IOException("Error rendering sheet: " + ex, ex);
        }
    }

    public void close() {
        if (this.m_Pages.nonEmpty()) {
            this.m_RenderContext.close();
        }
        this.m_RenderContext.dispose();
    }

    public OdfSheet newSheet(String title, PageSetup ps) {
        return new OdfSheet(title, this.m_Snap ? OdfGenerator$.MODULE$.BigSnap() : OdfGenerator$.MODULE$.NoSnap(), ps);
    }

    public void renderElements(OdfSheet sheet, LogicalElementHolder holder) {
        LogicalElementHolder logicalElementHolder = holder;
        if (logicalElementHolder instanceof Columns) {
            Columns columns = (Columns)logicalElementHolder;
            int maxHeight = 0;
            int x = sheet.x();
            Iterator<Column> it = columns.getColumnIterator();
            while (it.hasNext()) {
                Column col = it.next();
                int colHeight = this.renderColumn(sheet, col);
                maxHeight = package$.MODULE$.max(maxHeight, colHeight);
                if (it.hasNext()) {
                    int width = col.getWidth() + col.getSpaceAfter();
                    sheet.offsetX(width);
                }
                sheet.offsetY(-colHeight);
            }
            sheet.offsetX(x - sheet.x());
            sheet.offsetY(maxHeight);
            return;
        }
        CollectionConverters$.MODULE$.ListHasAsScala(holder.getLogicalElementList()).asScala().foreach((Function1)(JProcedure1 & Serializable)element -> this.renderElement(sheet, (LogicalElement)element, (Option<Rectangle>)None$.MODULE$));
        sheet.offsetY(holder.getHeight());
    }

    public int renderColumn(OdfSheet sheet, Column column) {
        IntRef totalHeight = IntRef.create((int)0);
        CollectionConverters$.MODULE$.ListHasAsScala(column.getBodyPartList()).asScala().foreach((Function1)(JProcedure1 & Serializable)bp -> {
            this.renderElements(sheet, (LogicalElementHolder)bp);
            int height = bp.getHeight() + bp.getSpaceAfter();
            sheet.offsetY(bp.getSpaceAfter());
            totalHeight$1.elem += height;
        });
        return totalHeight.elem;
    }

    public void renderElement(OdfSheet sheet, LogicalElement e, Option<Rectangle> enclosingRect) {
        LogicalElement logicalElement = e;
        if (logicalElement instanceof Rectangle) {
            Rectangle rc = (Rectangle)logicalElement;
            if (rc.getLogicalElementCount() == 0) {
                Color c = StandardColor.lookup(rc.getBackgroundColor());
                if (c.getAlpha() > 0 || rc.getBorderStyle() != null) {
                    sheet.add(new OdfRectangle(rc));
                    return;
                }
                return;
            }
            LogicalElement logicalElement2 = rc.getLogicalElement(0);
            if (logicalElement2 instanceof Text) {
                Text txt = (Text)logicalElement2;
                sheet.add(new OdfText(rc));
                return;
            }
            CollectionConverters$.MODULE$.ListHasAsScala(rc.getLogicalElementList()).asScala().foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.renderElement(sheet, (LogicalElement)_$1, (Option<Rectangle>)Some$.MODULE$.apply((Object)rc)));
            return;
        }
        int left = BoxesRunTime.unboxToInt((Object)enclosingRect.map((Function1 & Serializable)_$2 -> _$2.getLeft()).getOrElse(() -> OdfGenerator.$anonfun$2(e)));
        int top = BoxesRunTime.unboxToInt((Object)enclosingRect.map((Function1 & Serializable)_$3 -> _$3.getTop()).getOrElse(() -> OdfGenerator.$anonfun$4(e)));
        int width = BoxesRunTime.unboxToInt((Object)enclosingRect.map((Function1 & Serializable)_$4 -> _$4.getWidth()).getOrElse(() -> OdfGenerator.$anonfun$6(e)));
        int height = BoxesRunTime.unboxToInt((Object)enclosingRect.map((Function1 & Serializable)_$5 -> _$5.getHeight()).getOrElse(() -> OdfGenerator.$anonfun$8(e)));
        java.awt.Rectangle outRc = new java.awt.Rectangle(left, top, width, height);
        LogicalElement logicalElement3 = e;
        if (logicalElement3 instanceof Image) {
            Image im = (Image)logicalElement3;
            this.handleImage(im, sheet, enclosingRect, outRc);
            return;
        }
        if (logicalElement3 instanceof Glint) {
            Glint glint = (Glint)logicalElement3;
            this.handleGlint(glint, sheet, outRc);
            return;
        }
        if (logicalElement3 instanceof SVG) {
            SVG svg = (SVG)logicalElement3;
            this.handleSvg(svg, sheet, enclosingRect, outRc);
            return;
        }
    }

    private void handleImage(Image im, OdfSheet sheet, Option<Rectangle> enclosingRect, java.awt.Rectangle outRc) {
        Option actualImage = Option$.MODULE$.apply((Object)((BufferedImage)im.getImage())).orElse(() -> this.$anonfun$9(im));
        Option option = actualImage;
        if (option instanceof Some) {
            BufferedImage bim = (BufferedImage)((Some)option).value();
            im.setImage(bim);
            OdfImage img = new OdfImage(ImageUtil.getImage((Rectangle)enclosingRect.getOrElse(OdfGenerator::$anonfun$10), im, 72), outRc);
            sheet.add(img);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.warn(() -> OdfGenerator.handleImage$$anonfun$1(im), Line$.MODULE$.apply(167), FullName$.MODULE$.apply("com.elixirtech.report2.physical.odf.OdfGenerator.handleImage"));
            return;
        }
        throw new MatchError((Object)option);
    }

    private void handleGlint(Glint glint, OdfSheet sheet, java.awt.Rectangle outRc) {
        if (glint.getWidth() > 0 && glint.getHeight() > 0) {
            int imageResolution = glint.getImageResolution();
            if (imageResolution > 0) {
                OdfImage img = new OdfImage(ImageUtil.getImage(glint, imageResolution), outRc);
                sheet.add(img);
                return;
            }
            return;
        }
    }

    public void handleSvg(SVG svg, OdfSheet sheet, Option<Rectangle> enclosingRect, java.awt.Rectangle outRc) {
        if (svg.getWidth() > 0 && svg.getHeight() > 0) {
            int imageResolution = svg.getImageResolution();
            if (imageResolution > 0) {
                OdfImage img = new OdfImage(ImageUtil.getImage((Rectangle)enclosingRect.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), svg, imageResolution), outRc);
                sheet.add(img);
                return;
            }
            return;
        }
    }

    private BufferedImage toBufferedImage(java.awt.Image img) {
        java.awt.Image image = img;
        if (image instanceof BufferedImage) {
            BufferedImage bim = (BufferedImage)image;
            return bim;
        }
        BufferedImage actIm = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics g = actIm.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return actIm;
    }

    private String getTitle(Page page) {
        Object object;
        if (StringUtil.isEmpty(page.getName())) {
            String caption = this.report.getCaption();
            String ext = " Page " + this.getPageNo();
            String trunc = caption.length() + ext.length() > 31 ? caption.substring(0, 31 - ext.length()) : caption;
            object = trunc + ext;
        } else {
            object = page.getName();
        }
        String ret = object;
        return this.ensureNameHasValidChars(ret);
    }

    private int getPageNo() {
        return this.m_Pages.size() + 1;
    }

    public String substitute(String s) {
        String s1 = StringUtil.findAndReplace(s, RenderConstants.PAGE_NUMBER_STRING, this.m_PageNumber);
        String s2 = StringUtil.findAndReplace(s1, RenderConstants.PAGE_COUNT_STRING, this.m_PageCount);
        return this.m_VariableSubstitution.substitute(s2);
    }

    private String ensureNameHasValidChars(String name) {
        String n2 = name.replace('/', '_').replace('\\', '_').replace('?', '_').replace('*', '_').replace('[', '_').replace(']', '_').replace(':', '_').replace('{', '_');
        if (n2.length() > 31) {
            return n2.substring(0, 31);
        }
        return n2;
    }

    private static final Object renderPage$$anonfun$4(Exception ex$1) {
        return "Error rendering sheet: " + ex$1;
    }

    private static final int $anonfun$2(LogicalElement e$1) {
        return e$1.getLeft();
    }

    private static final int $anonfun$4(LogicalElement e$2) {
        return e$2.getTop();
    }

    private static final int $anonfun$6(LogicalElement e$3) {
        return e$3.getWidth();
    }

    private static final int $anonfun$8(LogicalElement e$4) {
        return e$4.getHeight();
    }

    private final Option $anonfun$9(Image im$1) {
        return Option$.MODULE$.apply((Object)ImageLoader.loadFromPath(this.m_RenderContext, im$1.getPicture())).map((Function1 & Serializable)img -> this.toBufferedImage((java.awt.Image)img));
    }

    private static final Rectangle $anonfun$10() {
        return null;
    }

    private static final Object handleImage$$anonfun$1(Image im$2) {
        return "image is null for " + im$2.getPicture();
    }
}

