/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.report2.engine.PDFPipeline;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.physical.PhysicalRenderer;
import com.elixirtech.report2.physical.pdf.PDFGenerator;
import com.elixirtech.report2.physical.pdf.PDFRenderContext;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFPhysicalRenderer
extends PhysicalRenderer {
    private PDFGenerator m_Generator;
    private PdfWriter m_Writer;
    private FontMapper m_FontMapper;
    private List<Integer> m_PageList = new ArrayList<Integer>();
    private Map<Image, PdfTemplate> m_Images = new HashMap<Image, PdfTemplate>();
    private Map<String, com.lowagie.text.Image> m_ITextImages = new HashMap<String, com.lowagie.text.Image>();

    public PDFPhysicalRenderer(PDFGenerator pDFGenerator, PdfWriter pdfWriter, FontMapper fontMapper) {
        super(PDFPipeline.FACTORY);
        this.m_Generator = pDFGenerator;
        this.m_Writer = pdfWriter;
        this.m_FontMapper = fontMapper;
    }

    public MimeType getMimeType() {
        return MimeTypes.PDF();
    }

    public PDFGenerator getGenerator() {
        return this.m_Generator;
    }

    public int lookupPageIndex(int n) {
        return this.m_PageList.indexOf(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderPage(Page page, int n, Graphics graphics) {
        this.m_PageList.add(page.getPageNumber());
        if (graphics instanceof PdfGraphics2D) {
            PDFRenderContext pDFRenderContext = new PDFRenderContext(this, graphics, this.m_Writer, n + 1, page, this.m_Cache);
            pDFRenderContext.setFontMapper(this.m_FontMapper);
            try {
                this.renderPage(pDFRenderContext, page);
            }
            finally {
                pDFRenderContext.dispose();
            }
        } else {
            super.renderPage(page, n, graphics);
        }
    }

    public void setImage(Image image, PdfTemplate pdfTemplate) {
        this.m_Images.put(image, pdfTemplate);
    }

    public PdfTemplate getImage(Image image) {
        return this.m_Images.get(image);
    }

    public com.lowagie.text.Image getITextImage(String string) {
        com.lowagie.text.Image image = this.m_ITextImages.get(string);
        if (image == null) {
            try {
                byte[] byArray = URLLoader.load(string);
                image = com.lowagie.text.Image.getInstance(byArray);
                this.m_ITextImages.put(string, image);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't load URL " + string + " : " + String.valueOf(exception)));
            }
        }
        return image;
    }
}

