/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.physical.GraphicalRenderContext;
import com.elixirtech.report2.physical.pdf.PDFGenerator;
import com.elixirtech.report2.physical.pdf.PDFPhysicalRenderer;
import com.elixirtech.report2.physical.pdf.PDFReportFontMapper;
import com.elixirtech.report2.raw.model.PageSetup;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PDFRenderContext
extends GraphicalRenderContext {
    private Set<String> m_TTCFontSet = new HashSet<String>();
    private PdfWriter m_Writer;
    private FontMapper m_FontMapper;
    private PDFGenerator m_Generator;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PDFRenderContext.class);

    PDFRenderContext(PDFPhysicalRenderer pDFPhysicalRenderer, Graphics graphics, PdfWriter pdfWriter, int n, Page page, Map<String, Object> map) {
        super(pDFPhysicalRenderer, graphics, n, page, map);
        this.m_Generator = pDFPhysicalRenderer.getGenerator();
        this.m_Writer = pdfWriter;
        if (this.m_Generator.useTemplatePageCount()) {
            this.m_VariableSubstitution.getMap().remove("##");
        }
    }

    public boolean isPostscriptNameTTCFont(String string) {
        return this.m_TTCFontSet.contains(string);
    }

    public boolean useTemplatePageCount() {
        return this.m_Generator.useTemplatePageCount();
    }

    public PdfWriter getWriter() {
        return this.m_Writer;
    }

    public boolean isUseFontSelector() {
        return PDFGenerator.m_IsSelector;
    }

    public void updateFontSelector(FontSelector fontSelector, com.lowagie.text.Font font) {
        float f = font.getSize();
        for (String string : PDFGenerator.m_SelectorFontNames) {
            Font font2 = new Font(string, font.getStyle(), (int)f);
            BaseFont baseFont = this.getFontMapper().awtToPdf(font2);
            if (baseFont == null) continue;
            com.lowagie.text.Font font3 = new com.lowagie.text.Font(baseFont, f);
            font3.setColor(font.getColor());
            fontSelector.addFont(font3);
        }
    }

    public void setFontMapper(FontMapper fontMapper) {
        if (fontMapper instanceof PDFReportFontMapper) {
            this.m_TTCFontSet = ((PDFReportFontMapper)fontMapper).getTTCList();
        }
        this.m_FontMapper = fontMapper;
    }

    public FontMapper getFontMapper() {
        return this.m_FontMapper;
    }

    public PdfContentByte getDirectContent() {
        return this.m_Writer.getDirectContent();
    }

    public int getPageHeight() {
        PageSetup pageSetup = this.m_Page.getPageSetup();
        return pageSetup.getHeight();
    }

    public int getLeftMargin() {
        PageSetup pageSetup = this.m_Page.getPageSetup();
        return pageSetup.getLeft();
    }

    public int getRightMargin() {
        PageSetup pageSetup = this.m_Page.getPageSetup();
        return pageSetup.getRight();
    }

    public int getTopMargin() {
        PageSetup pageSetup = this.m_Page.getPageSetup();
        return pageSetup.getTop();
    }

    public int getBottomMargin() {
        PageSetup pageSetup = this.m_Page.getPageSetup();
        return pageSetup.getBottom();
    }

    public com.lowagie.text.Image getITextImage(String string) {
        return ((PDFPhysicalRenderer)this.m_Renderer).getITextImage(string);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        PdfContentByte pdfContentByte = this.m_Writer.getDirectContent();
        PdfTemplate pdfTemplate = ((PDFPhysicalRenderer)this.m_Renderer).getImage(image);
        try {
            Object object;
            int n9;
            if (pdfTemplate == null) {
                int n10 = image.getWidth(null);
                n9 = image.getHeight(null);
                pdfTemplate = pdfContentByte.createTemplate(n10, n9);
                object = com.lowagie.text.Image.getInstance(image, null);
                pdfTemplate.addImage((com.lowagie.text.Image)object, n10, 0.0f, 0.0f, -n9, 0.0f, n9);
                ((PDFPhysicalRenderer)this.m_Renderer).setImage(image, pdfTemplate);
            }
            PageSetup pageSetup = this.m_Page.getPageSetup();
            n9 = pageSetup.getHeight() / 20;
            object = new double[6];
            AffineTransform affineTransform = this.getNormalizedMatrix(n9);
            affineTransform.concatenate(AffineTransform.getTranslateInstance(n - n5, n2 - n6));
            affineTransform.concatenate(AffineTransform.getScaleInstance((float)n3 / (float)n7, (float)n4 / (float)n8));
            affineTransform.getMatrix((double[])object);
            pdfContentByte.addTemplate(pdfTemplate, (float)object[0], (float)object[1], (float)object[2], (float)object[3], (float)object[4], (float)object[5]);
        }
        catch (Exception exception) {
            m_Log.error((Object)"PDF Shared image rendering failed, reverting to original rendering");
            this.m_Graphics.drawImage(image, n, n2, n + n3, n2 + n4, n5, n6, n5 + n7, n6 + n8, null);
        }
    }

    public void drawImage(com.lowagie.text.Image image, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        PdfContentByte pdfContentByte = this.m_Writer.getDirectContent();
        try {
            AffineTransform affineTransform = ((PdfGraphics2D)this.m_Graphics).getTransform();
            double d = affineTransform.getTranslateX() * 20.0;
            double d2 = affineTransform.getTranslateY() * 20.0;
            PageSetup pageSetup = this.m_Page.getPageSetup();
            float f = pageSetup.getHeight();
            float f2 = (float)(rectangle2D.getMinX() - rectangle2D2.getMinX() + d);
            float f3 = (float)((double)f - (rectangle2D.getMinY() - rectangle2D2.getMinY() + rectangle2D.getHeight()) - d2) - 19.0f;
            pdfContentByte.addImage(image, (float)rectangle2D.getWidth() / 20.0f, 0.0f, 0.0f, (float)rectangle2D.getHeight() / 20.0f, f2 / 20.0f, f3 / 20.0f);
        }
        catch (Exception exception) {
            m_Log.error((Object)"PDF Shared image rendering failed");
        }
    }

    public Point2D transform(float f, float f2) {
        PageSetup pageSetup = this.m_Page.getPageSetup();
        int n = pageSetup.getHeight() / 20;
        AffineTransform affineTransform = this.getNormalizedMatrix(n);
        double d = affineTransform.getTranslateX() + (double)f;
        double d2 = affineTransform.getTranslateY() - (double)f2;
        return new Point2D.Float((float)d, (float)d2);
    }

    public boolean hasPageCountTemplate() {
        return this.m_Generator.hasPageCountTemplate();
    }

    public void completePageCountTemplate(int n) {
        this.m_Generator.completePageCountTemplate(n);
    }

    public void definePageCountTemplate(BaseFont baseFont, float f) {
        this.m_Generator.definePageCountTemplate(baseFont, f);
    }

    public PdfTemplate getPageCountTemplate() {
        return this.m_Generator.getPageCountTemplate();
    }

    private AffineTransform getNormalizedMatrix(int n) {
        double[] dArray = new double[6];
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
        affineTransform.getMatrix(dArray);
        dArray[3] = -1.0;
        dArray[5] = n;
        affineTransform = new AffineTransform(dArray);
        affineTransform.concatenate(((PdfGraphics2D)this.m_Graphics).getTransform());
        return affineTransform;
    }
}

