/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.RTF;
import com.elixirtech.report2.physical.GraphicalRenderContext;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.pdf.BasicPhysicalRenderer;
import com.elixirtech.report2.util.MetricConvertor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.View;
import javax.swing.text.rtf.RTFEditorKit;

public class RTFRenderer
extends BasicPhysicalRenderer {
    private RTFEditorKit m_RTFEditorKit;
    private JEditorPane m_EditorPane = new JEditorPane();
    private Document m_Document;
    private int m_KeyId;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RTFRenderer.class);

    public RTFRenderer() {
        this.m_RTFEditorKit = new RTFEditorKit();
        this.m_EditorPane.setEditorKit(this.m_RTFEditorKit);
        this.m_Document = this.m_EditorPane.getDocument();
        this.m_EditorPane.updateUI();
    }

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        RTF rTF = (RTF)logicalElement;
        GraphicalRenderContext graphicalRenderContext = (GraphicalRenderContext)physicalRenderContext;
        Graphics graphics = graphicalRenderContext.getGraphics();
        int n = MetricConvertor.twipToPoint(rTF.getTop());
        int n2 = MetricConvertor.twipToPoint(rTF.getLeft());
        int n3 = MetricConvertor.twipToPoint(rTF.getWidth());
        int n4 = MetricConvertor.twipToPoint(rTF.getHeight());
        this.m_EditorPane.setLocation(0, 0);
        this.m_EditorPane.setSize(new Dimension(n3, n4));
        try {
            this.m_Document.remove(0, this.m_Document.getLength());
            StringReader stringReader = new StringReader(rTF.getText());
            this.m_RTFEditorKit.read(stringReader, this.m_Document, 0);
            View view = this.m_EditorPane.getUI().getRootView(this.m_EditorPane);
            if (rTF.isShowAsImage()) {
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                Graphics graphics2 = bufferedImage.getGraphics();
                graphics2.clipRect(0, 0, n3, n4);
                view.paint(graphics2, new Rectangle(0, 0, n3, n4));
                graphics2.dispose();
                this.drawImage(physicalRenderContext, graphics, "RTFkey" + this.m_KeyId, bufferedImage, n2, n);
                ++this.m_KeyId;
                bufferedImage.flush();
            } else {
                view.paint(graphics, new Rectangle(n2, n, n3, n4));
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)exception.toString());
            exception.printStackTrace();
        }
    }
}

