/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.pdf.ElxPdfGraphics2D;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.GraphicalRenderContext;
import com.elixirtech.report2.physical.PhysicalConstants;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.renderer.IPhysicalRenderer;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.ui.StandardColor;
import com.lowagie.text.pdf.PdfGraphics2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;

public class RectRenderer
implements IPhysicalRenderer,
PhysicalConstants {
    public static final boolean CLIPPING = true;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RectRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        int n;
        Object object;
        Object object2;
        BorderStyle borderStyle;
        com.elixirtech.report2.logical.model.Rectangle rectangle = (com.elixirtech.report2.logical.model.Rectangle)logicalElement;
        int n2 = rectangle.getLeft();
        int n3 = rectangle.getTop();
        int n4 = rectangle.getWidth();
        int n5 = rectangle.getHeight();
        int n6 = rectangle.getBorderRadius();
        int n7 = rectangle.getBorderWidth();
        int n8 = 0;
        int n9 = Math.min(n4 / 2, n5 / 2);
        if (n6 > n9) {
            n6 = n9;
        }
        if (n5 <= 4 && "Below".equals(rectangle.getSplit())) {
            return;
        }
        GRectangle gRectangle = new GRectangle(new Rectangle(n2, n3, n4, n5));
        gRectangle.setPadding(rectangle.getPaddingLeft(), rectangle.getPaddingTop(), rectangle.getPaddingRight(), rectangle.getPaddingBottom());
        gRectangle.setCurvedClip(rectangle.isCurvedClip());
        gRectangle.setPaddedClip(rectangle.isPaddedClip());
        String string = rectangle.getBackgroundColor();
        if (string != null) {
            gRectangle.setBackground(StandardColor.lookup(string));
        }
        if ((borderStyle = BorderStyle.get(rectangle.getBorderStyle())) != BorderStyle.NONE) {
            if (rectangle.isBorderLeft()) {
                n8 |= 1;
            }
            if (rectangle.isBorderTop()) {
                n8 |= 2;
            }
            if (rectangle.isBorderRight()) {
                n8 |= 4;
            }
            if (rectangle.isBorderBottom()) {
                n8 |= 8;
            }
            object2 = StandardColor.lookup(rectangle.getBorderColor());
            gRectangle.setBorder(borderStyle, n7, (Color)object2, n8);
        }
        if (n6 > 0) {
            gRectangle.setBorderRadius(n6, n6);
        }
        object2 = (ElxPdfGraphics2D)((GraphicalRenderContext)physicalRenderContext).getGraphics();
        boolean bl = gRectangle.hasBackground();
        boolean bl2 = gRectangle.hasBorder();
        if (bl || bl2) {
            ((PdfGraphics2D)object2).scale(0.05, 0.05);
            if (bl) {
                object = gRectangle.getBackground();
                n = ((Color)object).getAlpha();
                if (n != 255) {
                    ((ElxPdfGraphics2D)object2).setFillGState(n);
                }
                gRectangle.drawBackground((Graphics2D)object2);
                if (n != 255) {
                    ((ElxPdfGraphics2D)object2).setFillGState(255);
                }
            }
            if (bl2) {
                object = gRectangle.getBorderColor();
                n = ((Color)object).getAlpha();
                if (n != 255) {
                    ((ElxPdfGraphics2D)object2).setStrokeGState(n);
                }
                gRectangle.drawBorder((Graphics2D)object2);
                if (n != 255) {
                    ((ElxPdfGraphics2D)object2).setStrokeGState(255);
                }
            }
            ((PdfGraphics2D)object2).scale(20.0, 20.0);
        }
        if ((n = (object = rectangle.getLogicalElementIterator()).hasNext()) != 0) {
            Shape shape = null;
            shape = ((PdfGraphics2D)object2).getClip();
            ((PdfGraphics2D)object2).scale(0.05, 0.05);
            Shape shape2 = gRectangle.getChildClipShape();
            if (rectangle.getRaw() instanceof Field) {
                Rectangle rectangle2 = shape2.getBounds();
                rectangle2.x -= 200;
                rectangle2.y -= 200;
                rectangle2.width += 400;
                rectangle2.height += 400;
                shape2 = rectangle2;
            }
            ((PdfGraphics2D)object2).clip(shape2);
            ((PdfGraphics2D)object2).scale(20.0, 20.0);
            physicalRenderContext.render((Iterator<LogicalElement>)object);
            ((PdfGraphics2D)object2).setClip(shape);
        }
    }

    private static String color(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "(" + color.getAlpha() + ")";
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

