/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.physical.GraphicalRenderContext;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.pdf.BasicPhysicalRenderer;
import com.elixirtech.report2.util.MetricConvertor;
import com.elixirtech.svg.SVGToImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public final class SVGRenderer
extends BasicPhysicalRenderer {
    private GraphicalRenderContext m_Context;
    private SVG m_Element;
    private int m_Width;
    private int m_Height;
    private BufferedImage m_BufferedImage;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SVGRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        if (logicalElement == null) {
            throw new IllegalArgumentException("SVG element is null");
        }
        SVG sVG = (SVG)logicalElement;
        this.m_Context = (GraphicalRenderContext)physicalRenderContext;
        this.m_Element = sVG;
        this.m_Width = MetricConvertor.twipToPoint(sVG.getWidth()) + 1;
        this.m_Height = MetricConvertor.twipToPoint(sVG.getHeight()) + 1;
        this.refreshBufferImage(sVG);
        int n = MetricConvertor.twipToPoint(sVG.getLeft());
        int n2 = MetricConvertor.twipToPoint(sVG.getTop());
        this.paint(this.m_Context.getGraphics(), n, n2);
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.m_BufferedImage != null) {
            graphics.drawImage(this.m_BufferedImage, n, n2, this.m_Width, this.m_Height, null);
        }
    }

    public void refreshBufferImage(SVG sVG) {
        try {
            double d = (double)sVG.getImageResolution() / 72.0;
            int n = (int)((double)this.m_Width * d);
            int n2 = (int)((double)this.m_Height * d);
            this.m_BufferedImage = SVGToImage.convert(sVG.getDocument(), new Dimension(n, n2));
        }
        catch (Exception exception) {
            m_Log.error((Object)("Exception: " + String.valueOf(exception)), (Throwable)exception);
        }
    }
}

