/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.xlsx;

import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.physical.xlsx.CellFormat;
import com.elixirtech.report2.physical.xlsx.CellFormat$;
import com.elixirtech.report2.physical.xlsx.CellStyleManager;
import com.elixirtech.report2.physical.xlsx.Position;
import com.elixirtech.report2.physical.xlsx.Sheet;
import com.elixirtech.report2.physical.xlsx.XLSXGenerator;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.io.Serializable;
import java.util.Locale;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class Element
implements Comparable<Element> {
    private int left;
    private int top;
    private int width;
    private int height;
    private Sheet sheet;
    private Option cellRange;

    public Element(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.sheet = null;
        this.cellRange = None$.MODULE$;
    }

    public int left() {
        return this.left;
    }

    public void left_$eq(int x$1) {
        this.left = x$1;
    }

    public int top() {
        return this.top;
    }

    public void top_$eq(int x$1) {
        this.top = x$1;
    }

    public int width() {
        return this.width;
    }

    public void width_$eq(int x$1) {
        this.width = x$1;
    }

    public int height() {
        return this.height;
    }

    public void height_$eq(int x$1) {
        this.height = x$1;
    }

    public Sheet sheet() {
        return this.sheet;
    }

    public void sheet_$eq(Sheet x$1) {
        this.sheet = x$1;
    }

    public Option<CellRangeAddress> cellRange() {
        return this.cellRange;
    }

    public void cellRange_$eq(Option<CellRangeAddress> x$1) {
        this.cellRange = x$1;
    }

    public void offset(int x, int y) {
        this.left_$eq(this.left() + x);
        this.top_$eq(this.top() + y);
    }

    public void setSheet(Sheet sheet, Position colPosition, Position rowPosition) {
        this.sheet_$eq(sheet);
        colPosition.addRange(this.left(), this.left() + this.width());
        rowPosition.addRange(this.top(), this.top() + this.height());
    }

    @Override
    public int compareTo(Element rhs) {
        if (this.top() < rhs.top()) {
            return -1;
        }
        if (this.top() > rhs.top()) {
            return 1;
        }
        if (this.left() < rhs.left()) {
            return -1;
        }
        if (this.left() > rhs.left()) {
            return 1;
        }
        return 0;
    }

    public int right() {
        return this.left() + this.width();
    }

    public int bottom() {
        return this.top() + this.height();
    }

    public void render(XLSXGenerator gen) {
    }

    public XSSFCell renderAcrossSpans(XLSXGenerator gen, XSSFCellStyle style) {
        int rowSpan = this.sheet().getRowSpan(this);
        int colSpan = this.sheet().getColSpan(this);
        int rowNo = this.sheet().getRowIdx(this.top());
        int colNo = this.sheet().getColumnIdx(this.left());
        XSSFRow row = this.sheet().getRowFromPosition(this.top());
        XSSFCell mainCell = row.createCell(colNo);
        mainCell.setCellStyle((CellStyle)style);
        if (rowSpan > 1 || colSpan > 1) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(rowNo), rowNo + rowSpan).foreach((Function1)(JFunction1.mcVI.sp & Serializable)r -> {
                XSSFRow myrow = this.sheet().getRow(r);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(colNo), colNo + colSpan).foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> {
                    if (r > rowNo || c > colNo) {
                        myrow.createCell(c).setCellStyle((CellStyle)style);
                        return;
                    }
                });
            });
            this.sheet().mergeCells(colNo, colSpan, rowNo, rowSpan);
        }
        return mainCell;
    }

    public CellStyleManager.CellStyle createCellStyle(Rectangle rc) {
        Option<CellFormat> option;
        String borderStyle = rc.getBorderStyle();
        None$ optBorder = borderStyle != null && !"Transparent".equals(borderStyle) ? Some$.MODULE$.apply((Object)new CellStyleManager.MyBorder(rc.getBorderStyle(), rc.getBorderWidth(), rc.getBorderColor(), rc.isBorderLeft(), rc.isBorderTop(), rc.isBorderRight(), rc.isBorderBottom())) : None$.MODULE$;
        Option backgroundColor = Option$.MODULE$.apply((Object)rc.getBackgroundColor());
        Option optBackground = backgroundColor.map((Function1 & Serializable)_$1 -> new CellStyleManager.MyBackground((String)_$1));
        String string = rc.getRaw().getStyleName();
        String string2 = "locked";
        boolean locked = !(string != null ? !string.equals(string2) : string2 != null);
        RawModelElement rawModelElement = rc.getRaw();
        if (rawModelElement instanceof Field) {
            Field f = (Field)rawModelElement;
            option = this.setupNumberFormat(f);
        } else {
            option = None$.MODULE$;
        }
        Option<CellFormat> format = option;
        return new CellStyleManager.CellStyle((Option<CellStyleManager.MyBorder>)optBorder, (Option<CellStyleManager.MyFont>)None$.MODULE$, (Option<CellStyleManager.MyBackground>)optBackground, locked, format);
    }

    public Option<CellFormat> setupNumberFormat(Field f2) {
        Locale locale = Locale.getDefault();
        return Option$.MODULE$.apply((Object)f2.getFormat()).flatMap((Function1 & Serializable)f -> CellFormat$.MODULE$.getPattern(locale, (Format)f)).map((Function1 & Serializable)_$2 -> CellFormat$.MODULE$.apply((String)_$2));
    }
}

