/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.print;

import com.elixirtech.report2.print.PrintAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Sides;

public class PrintSides
extends PrintAttribute {
    public static final String NAME = "Sides";
    public static final String DEFAULT = "One Sided";
    public static final String[] ALL = new String[]{"Duplex", "Tumble", "Two Sided Long Edge", "Two Sided Short Edge", "One Sided"};
    public static final String[] KEYS = new String[]{"Print.Duplex", "Print.Tumble", "Print.TwoSidedLongEdge", "Print.TwoSidedShortEdge", "Print.OneSided"};
    private String m_Value = "One Sided";

    public static String getValue(int n) {
        if (Sides.DUPLEX.getValue() == n) {
            return "Duplex";
        }
        if (Sides.TUMBLE.getValue() == n) {
            return "Tumble";
        }
        if (Sides.TWO_SIDED_LONG_EDGE.getValue() == n) {
            return "Two Sided Long Edge";
        }
        if (Sides.TWO_SIDED_SHORT_EDGE.getValue() == n) {
            return "Two Sided Short Edge";
        }
        return DEFAULT;
    }

    @Override
    public void buildAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        if ("Duplex".equals(this.m_Value)) {
            printRequestAttributeSet.add(Sides.DUPLEX);
        } else if ("Tumble".equals(this.m_Value)) {
            printRequestAttributeSet.add(Sides.TUMBLE);
        } else if ("Two Sided Long Edge".equals(this.m_Value)) {
            printRequestAttributeSet.add(Sides.TWO_SIDED_LONG_EDGE);
        } else if ("Two Sided Short Edge".equals(this.m_Value)) {
            printRequestAttributeSet.add(Sides.TWO_SIDED_SHORT_EDGE);
        } else {
            printRequestAttributeSet.add(Sides.ONE_SIDED);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setValue(String string) {
        this.m_Value = string;
    }

    @Override
    public String getValue() {
        return this.m_Value;
    }

    @Override
    public String getValueKey() {
        for (int i = 0; i < ALL.length; ++i) {
            if (!ALL[i].equals(this.m_Value)) continue;
            return KEYS[i];
        }
        return null;
    }
}

