/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.processor;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.jdom.Element;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.processor.DocumentProcessor;
import java.util.HashMap;
import java.util.Map;

public class EmbeddedStorageCleaner
extends DocumentProcessor
implements RenderConstants {
    public static final String TABLE_CLASS = "com.elixirtech.report.customplugin.cachetableview.TableDataCacheViewer";
    public static final String MRDC_CLASS = "com.elixirtech.report.customplugin.cacheview.MultiRowDataCacheViewer";
    public static final String CHECKBOX_CLASS = "com.elixirtech.report.customplugin.checkbox.CheckBoxPluginComponent";
    public static final String BARCODE_CLASS = "com.elixirtech.report.customplugin.barcode.BarcodeView";
    public static final String CHART_CLASS = "com.elixirtech.report.customplugin.barcode.BarcodeView";
    public static final char BAR = '|';
    public static final String LEFT = "L";
    public static final String CENTER = "C";
    public static final String RIGHT = "R";
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(EmbeddedStorageCleaner.class);
    private static Map<String, String> m_NameMap = new HashMap<String, String>();

    @Override
    public void processElement(Element element) {
        if (element.getName().equals("model")) {
            if (TABLE_CLASS.equals(element.getAttributeValue("Class_Name"))) {
                EmbeddedStorageCleaner.processTableEmbeddedStorage(element);
            } else if (MRDC_CLASS.equals(element.getAttributeValue("Class_Name"))) {
                EmbeddedStorageCleaner.processMRDCEmbeddedStorage(element);
            } else if (CHECKBOX_CLASS.equals(element.getAttributeValue("Class_Name"))) {
                EmbeddedStorageCleaner.processCheckBoxEmbeddedStorage(element);
            } else if ("com.elixirtech.report.customplugin.barcode.BarcodeView".equals(element.getAttributeValue("Class_Name"))) {
                EmbeddedStorageCleaner.processBarcodeEmbeddedStorage(element);
            } else if ("Chart".equals(element.getAttributeValue("Name"))) {
                EmbeddedStorageCleaner.processChartEmbeddedStorage(element);
            }
        }
    }

    private static void processMRDCEmbeddedStorage(Element element) {
        String string = element.getAttributeValue("Embedded_Storage");
        String[] stringArray = StringUtil.arrayOfSubstrings(string, '|');
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = new Element("multi-row-column", NS_RML);
            element2.setAttribute("Field", stringArray[i]);
            element2.setAttribute("Start", stringArray[++i]);
            element2.setAttribute("End", stringArray[++i]);
            element2.setAttribute("Text_Align", EmbeddedStorageCleaner.align(stringArray[++i]));
            element.addContent(element2);
        }
    }

    private static String align(String string) {
        if (string.equals(LEFT)) {
            return "Left";
        }
        if (string.equals(CENTER)) {
            return "Center";
        }
        if (string.equals(RIGHT)) {
            return "Right";
        }
        return string;
    }

    private static void processCheckBoxEmbeddedStorage(Element element) {
        String string = element.getAttributeValue("Embedded_Storage");
        if (string == null || string.trim().length() == 0) {
            element.removeAttribute("Embedded_Storage");
        } else {
            m_Log.warn((Object)"Unexpected Embedded_Storage in CheckBox");
        }
    }

    private static void processBarcodeEmbeddedStorage(Element element) {
        String string = element.getAttributeValue("Embedded_Storage");
        if (string == null || string.trim().length() == 0) {
            element.removeAttribute("Embedded_Storage");
        } else {
            m_Log.warn((Object)"Unexpected Embedded_Storage in Barcode");
        }
    }

    private static void processChartEmbeddedStorage(Element element) {
    }

    private static void processTableEmbeddedStorage(Element element) {
        String string = element.getAttributeValue("Embedded_Storage");
        String[] stringArray = StringUtil.arrayOfSubstrings(string, '\u00c7');
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = new Element("storage", NS_RML);
            element.addContent(element2);
            String[] stringArray2 = StringUtil.arrayOfSubstrings(stringArray[i], '\u00b2');
            for (int j = 0; j < stringArray2.length; ++j) {
                String[] stringArray3 = StringUtil.arrayOfSubstrings(stringArray2[j], '\u00b3');
                if (stringArray3.length <= 2) continue;
                element2.setAttribute(EmbeddedStorageCleaner.name(stringArray3[0]), stringArray3[2]);
            }
        }
    }

    private static String name(String string) {
        String string2 = m_NameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        m_Log.warn((Object)("No name mapping for " + string));
        return string.replace(' ', '_');
    }

    static {
        m_NameMap.put("name", "Name");
        m_NameMap.put("bgcolor", "Back_Color");
        m_NameMap.put("Cache_Name", "Cache_Name");
        m_NameMap.put("transparent", "Transparent");
        m_NameMap.put("Border_Width", "Border_Width");
        m_NameMap.put("Border_Color", "Border_Color");
        m_NameMap.put("Control_Source", "Control_Source");
        m_NameMap.put("hide-duplicate", "Hide_Duplicates");
        m_NameMap.put("width", "Width");
        m_NameMap.put("height", "Height");
        m_NameMap.put("Cell_Type", "Cell_Type");
        m_NameMap.put("static", "Static");
        m_NameMap.put("Alignment", "Text_Align");
        m_NameMap.put("font-weight", "Font_Weight");
        m_NameMap.put("font-underline", "Font_Underline");
        m_NameMap.put("font-color", "Font_Color");
        m_NameMap.put("font-style", "Font_Style");
        m_NameMap.put("font-family", "Font_Family");
        m_NameMap.put("font-size", "Font_Size");
        m_NameMap.put("LB", "LB");
        m_NameMap.put("BB", "BB");
        m_NameMap.put("TB", "TB");
        m_NameMap.put("RB", "RB");
        m_NameMap.put("Locale", "Locale");
        m_NameMap.put("Format", "Format");
        m_NameMap.put("word_wrap", "Auto_Wrap");
        m_NameMap.put("Header", "Header");
        m_NameMap.put("Footer", "Footer");
        m_NameMap.put("Display_Table", "Display_Table");
    }
}

