/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CallbackElement
extends RawElement
implements IBean,
PropertyImplementor {
    protected ControlSource m_ControlSource;
    protected Document m_Document;
    protected Map<String, Parameter> m_Parameters = new HashMap<String, Parameter>();
    protected Boolean m_ShowAsImage;
    protected Integer m_ImageResolution;
    protected String m_Type;
    protected transient Object m_CachedRender;
    protected String m_Text = "";
    private static String[] m_PropertyNameStrings = new String[]{"Common.ShowAsImage".intern(), "Common.ImageResolution".intern(), "CallbackElement.ControlSource".intern(), "CallbackElement.Text".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Boolean", "Integer", "ControlSource", "String"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "callback";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_ControlSource != null) {
            this.m_ControlSource.loaded();
        }
        if (this.m_Document != null) {
            // empty if block
        }
        for (IBean iBean : this.m_Parameters.values()) {
            iBean.loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_ControlSource != null) {
            if (this.m_ControlSource != null) {
                this.m_ControlSource.dispose();
            }
            this.m_ControlSource = null;
        }
        if (this.m_Document != null) {
            this.m_Document = null;
        }
        if (this.m_Parameters != null) {
            for (IBean iBean : this.m_Parameters.values()) {
                iBean.dispose();
            }
        }
        this.m_Parameters = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_ShowAsImage != null) {
            element.setAttribute("show-as-image", this.m_ShowAsImage != false ? "Yes" : "No");
        }
        if (this.m_ImageResolution != null) {
            element.setAttribute("image-resolution", this.m_ImageResolution.toString());
        }
        if (this.m_Type != null) {
            element.setAttribute("type", this.m_Type);
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        CallbackElement callbackElement = (CallbackElement)super.shallowCopy();
        callbackElement.m_Type = this.m_Type;
        callbackElement.m_CachedRender = this.m_CachedRender;
        return callbackElement;
    }

    public String getString(String string) {
        Parameter parameter = this.getParameter(string);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    public int getInt(String string, int n) {
        int n2 = n;
        Parameter parameter = this.getParameter(string);
        if (parameter != null) {
            try {
                n2 = Integer.parseInt(parameter.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public double getDouble(String string, double d) {
        double d2 = d;
        Parameter parameter = this.getParameter(string);
        if (parameter != null) {
            try {
                d2 = Double.parseDouble(parameter.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d2;
    }

    public Document getDocument() {
        return this.m_Document;
    }

    public void setDocument(Document document) {
        this.m_Document = document;
    }

    public void addParameter(Parameter parameter) {
        String string = parameter.getKey();
        this.m_Parameters.put(string, parameter);
        this.m_CachedRender = null;
    }

    public void removeParameter(Parameter parameter) {
        String string = parameter.getKey();
        this.m_Parameters.remove(string);
        this.m_CachedRender = null;
    }

    public Parameter getParameter(String string) {
        return this.m_Parameters.get(string);
    }

    public Iterator<Parameter> getParameterIterator() {
        return this.m_Parameters.values().iterator();
    }

    public int getParameterCount() {
        return this.m_Parameters.size();
    }

    public Map<String, Parameter> getParameterMap() {
        return this.m_Parameters;
    }

    public void setParameterMap(Map<String, Parameter> map) {
        this.m_Parameters = map;
        this.m_CachedRender = null;
    }

    public String getType() {
        return this.m_Type;
    }

    public void setType(String string) {
        this.m_Type = string;
        if (this.m_Type != null) {
            this.m_Type = this.m_Type.trim();
        }
    }

    public Object getCachedRender() {
        return this.m_CachedRender;
    }

    public void setCachedRender(Object object) {
        this.m_CachedRender = object;
    }

    public void addText(String string) {
        this.m_Text = this.m_Text == null ? string : this.m_Text + string;
        this.m_CachedRender = null;
    }

    public void setText(String string) {
        this.m_Text = string;
        this.m_CachedRender = null;
    }

    public String getText() {
        return this.m_Text;
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public ControlSource getControlSource() {
        if (this.m_ControlSource != null) {
            return this.m_ControlSource;
        }
        return (ControlSource)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
    }

    public void setControlSource(ControlSource controlSource) {
        this.m_ControlSource = controlSource;
        this.m_CachedRender = null;
    }

    public boolean isShowAsImage() {
        Boolean bl = this.m_ShowAsImage;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
        }
        return bl;
    }

    public void setShowAsImage(boolean bl) {
        this.m_ShowAsImage = bl;
    }

    public void setShowAsImage(Boolean bl) {
        this.m_ShowAsImage = bl;
    }

    public int getImageResolution() {
        Integer n = this.m_ImageResolution;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
        }
        return n;
    }

    public void setImageResolution(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_ImageResolution = n;
    }

    public void setImageResolution(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_ImageResolution = n;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_ShowAsImage = (Boolean)object;
                        break;
                    }
                    case 1: {
                        this.setImageResolution((Integer)object);
                        break;
                    }
                    case 2: {
                        this.m_ControlSource = (ControlSource)object;
                        this.m_CachedRender = null;
                        break;
                    }
                    case 3: {
                        this.m_Text = (String)object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + String.valueOf(this.getClass()));
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + String.valueOf(object) + "(" + String.valueOf(object.getClass()) + ") : " + String.valueOf(exception));
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_ShowAsImage;
            }
            case 1: {
                return this.m_ImageResolution;
            }
            case 2: {
                return this.m_ControlSource;
            }
            case 3: {
                return this.m_Text;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + String.valueOf(this.getClass()));
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public CallbackElement deepCopy() {
        CallbackElement callbackElement = new CallbackElement();
        this.copyInto(callbackElement);
        return callbackElement;
    }

    protected void copyInto(CallbackElement callbackElement) {
        super.copyInto(callbackElement);
        callbackElement.m_ShowAsImage = this.m_ShowAsImage;
        callbackElement.m_ImageResolution = this.m_ImageResolution;
        callbackElement.m_Type = this.m_Type;
        callbackElement.m_CachedRender = this.m_CachedRender;
        if (this.m_ControlSource != null) {
            callbackElement.m_ControlSource = this.m_ControlSource.deepCopy();
        }
        if (this.m_Document != null) {
            callbackElement.m_Document = (Document)this.m_Document.clone();
        }
        callbackElement.m_Parameters = new HashMap<String, Parameter>();
        for (Map.Entry<String, Parameter> entry : this.m_Parameters.entrySet()) {
            callbackElement.addParameter(entry.getValue().deepCopy());
        }
        callbackElement.m_Text = this.m_Text;
    }

    static {
        try {
            m_IndexOffset = RawElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                CallbackElement.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                CallbackElement.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            CallbackElement.logError("Error in property initialization", throwable);
        }
    }
}

