/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.awt.Image;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;

public class Chart
extends RawElement
implements IBean,
PropertyImplementor {
    protected Document m_Document;
    protected Locale m_Locale;
    protected String m_URL;
    protected String m_URLDescription;
    protected String m_URLTarget;
    protected Integer m_ImageResolution;
    protected Boolean m_Preview = Boolean.TRUE;
    protected String m_DataSource;
    protected String m_DataRange = "Group";
    protected String m_ChartURL;
    protected transient Image m_Image;
    protected transient com.elixirtech.chart2.model.Chart m_CachedChart;
    private static String[] m_PropertyNameStrings = new String[]{"Common.Locale".intern(), "Common.URL".intern(), "Common.URLDescription".intern(), "Common.URLTarget".intern(), "Common.ImageResolution".intern(), "Common.Preview".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Locale", "String", "String", "Choice.URLTarget", "Integer", "Boolean"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        if (BeanUtil.methodMatches(string, "RawElement.Growable")) {
            return true;
        }
        return BeanUtil.methodMatches(string, "RawElement.Shrinkable");
    }

    @Override
    public String getTagName() {
        return "chart";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Document != null) {
            // empty if block
        }
    }

    @Override
    public void dispose() {
        if (this.m_Image != null) {
            this.m_Image.flush();
            this.m_Image = null;
        }
        if (this.m_Document != null) {
            this.m_Document = null;
        }
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Locale != null) {
            element.setAttribute("locale", this.m_Locale.toString());
        }
        if (this.m_URL != null) {
            element.setAttribute("url", this.m_URL);
        }
        if (this.m_URLDescription != null) {
            element.setAttribute("url-description", this.m_URLDescription);
        }
        if (this.m_URLTarget != null) {
            element.setAttribute("url-target", this.m_URLTarget);
        }
        if (this.m_ImageResolution != null) {
            element.setAttribute("image-resolution", this.m_ImageResolution.toString());
        }
        if (this.m_Preview != null) {
            element.setAttribute("preview", this.m_Preview != false ? "Yes" : "No");
        }
        if (this.m_DataSource != null) {
            element.setAttribute("datasource", this.m_DataSource);
        }
        if (this.m_DataRange != null) {
            element.setAttribute("datarange", this.m_DataRange);
        }
        if (this.m_ChartURL != null) {
            element.setAttribute("chart-url", this.m_ChartURL);
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Chart chart = (Chart)super.shallowCopy();
        chart.m_DataSource = this.m_DataSource;
        chart.m_DataRange = this.m_DataRange;
        chart.m_ChartURL = this.m_ChartURL;
        chart.m_Image = this.m_Image;
        chart.m_CachedChart = this.m_CachedChart;
        return chart;
    }

    @Override
    protected void invalidateImageCache() {
        this.m_Image = null;
    }

    public Document getDocument() {
        return this.m_Document;
    }

    public void setDocument(Document document) {
        this.m_Document = document;
        this.m_Image = null;
    }

    public String getDataSource() {
        return this.m_DataSource;
    }

    public void setDataSource(String string) {
        this.m_DataSource = string;
    }

    public String getDataRange() {
        return this.m_DataRange;
    }

    public void setDataRange(String string) {
        this.m_DataRange = string;
    }

    public String getChartURL() {
        return this.m_ChartURL;
    }

    public void setChartURL(String string) {
        this.m_ChartURL = string;
    }

    public Image getImage() {
        return this.m_Image;
    }

    public void setImage(Image image) {
        this.m_Image = image;
    }

    public com.elixirtech.chart2.model.Chart getCachedChart() {
        return this.m_CachedChart;
    }

    public void setCachedChart(com.elixirtech.chart2.model.Chart chart) {
        this.m_CachedChart = chart;
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public Locale getLocale() {
        if (this.m_Locale != null) {
            return this.m_Locale;
        }
        return (Locale)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    public void setLocale(Locale locale) {
        this.m_Locale = locale;
    }

    public String getURL() {
        if (this.m_URL != null) {
            return this.m_URL;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
    }

    public void setURL(String string) {
        this.m_URL = string;
        if (this.m_URL != null) {
            this.m_URL = this.m_URL.trim();
        }
    }

    public String getURLDescription() {
        if (this.m_URLDescription != null) {
            return this.m_URLDescription;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
    }

    public void setURLDescription(String string) {
        this.m_URLDescription = string;
    }

    public String getURLTarget() {
        if (this.m_URLTarget != null) {
            return this.m_URLTarget;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 4 - 1);
    }

    public void setURLTarget(String string) {
        this.m_URLTarget = string;
    }

    public int getImageResolution() {
        Integer n = this.m_ImageResolution;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 5 - 1);
        }
        return n;
    }

    public void setImageResolution(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_ImageResolution = n;
    }

    public void setImageResolution(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_ImageResolution = n;
    }

    public boolean isPreview() {
        Boolean bl = this.m_Preview;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 6 - 1);
        }
        return bl;
    }

    public void setPreview(boolean bl) {
        this.m_Preview = bl;
    }

    public void setPreview(Boolean bl) {
        this.m_Preview = bl;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
        set.remove(Name.apply("RawElement.Growable", ""));
        set.remove(Name.apply("RawElement.Shrinkable", ""));
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_Locale = (Locale)object;
                        break;
                    }
                    case 1: {
                        this.m_URL = (String)object;
                        if (this.m_URL != null) {
                            this.m_URL = this.m_URL.trim();
                        }
                        break;
                    }
                    case 2: {
                        this.m_URLDescription = (String)object;
                        break;
                    }
                    case 3: {
                        this.m_URLTarget = (String)object;
                        break;
                    }
                    case 4: {
                        this.setImageResolution((Integer)object);
                        break;
                    }
                    case 5: {
                        this.m_Preview = (Boolean)object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + String.valueOf(this.getClass()));
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + String.valueOf(object) + "(" + String.valueOf(object.getClass()) + ") : " + String.valueOf(exception));
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_Locale;
            }
            case 1: {
                return this.m_URL;
            }
            case 2: {
                return this.m_URLDescription;
            }
            case 3: {
                return this.m_URLTarget;
            }
            case 4: {
                return this.m_ImageResolution;
            }
            case 5: {
                return this.m_Preview;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + String.valueOf(this.getClass()));
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public Chart deepCopy() {
        Chart chart = new Chart();
        this.copyInto(chart);
        return chart;
    }

    protected void copyInto(Chart chart) {
        super.copyInto(chart);
        chart.m_Locale = this.m_Locale;
        chart.m_URL = this.m_URL;
        chart.m_URLDescription = this.m_URLDescription;
        chart.m_URLTarget = this.m_URLTarget;
        chart.m_ImageResolution = this.m_ImageResolution;
        chart.m_Preview = this.m_Preview;
        chart.m_DataSource = this.m_DataSource;
        chart.m_DataRange = this.m_DataRange;
        chart.m_ChartURL = this.m_ChartURL;
        chart.m_Image = this.m_Image;
        chart.m_CachedChart = this.m_CachedChart;
        if (this.m_Document != null) {
            chart.m_Document = (Document)this.m_Document.clone();
        }
    }

    static {
        try {
            m_IndexOffset = RawElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                Chart.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                Chart.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            Chart.logError("Error in property initialization", throwable);
        }
    }
}

