/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Element;
import com.elixirtech.report2.raw.model.CubeLevel;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CubeHierarchy
implements IBean {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CubeHierarchy.class);
    protected boolean m_IsLoaded;
    protected List<CubeLevel> m_Level = new ArrayList<CubeLevel>();
    protected String m_Name;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "cube-hierarchy";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        Iterator<CubeLevel> iterator = this.m_Level.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Level != null) {
            Iterator<CubeLevel> iterator = this.m_Level.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Level = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        CubeHierarchy cubeHierarchy = (CubeHierarchy)this.getClass().newInstance();
        cubeHierarchy.m_Name = this.m_Name;
        return cubeHierarchy;
    }

    public void addLevel(CubeLevel cubeLevel) {
        this.m_Level.add(cubeLevel);
    }

    public void addLevel(int n, CubeLevel cubeLevel) {
        this.m_Level.add(n, cubeLevel);
    }

    public void addAllLevels(Collection<CubeLevel> collection) {
        this.m_Level.addAll(collection);
    }

    public int indexOfLevel(CubeLevel cubeLevel) {
        return this.m_Level.indexOf(cubeLevel);
    }

    public void removeLevel(CubeLevel cubeLevel) {
        this.m_Level.remove(cubeLevel);
    }

    public void removeAllLevels(Collection collection) {
        this.m_Level.removeAll(collection);
    }

    public void removeAllLevels() {
        this.m_Level.clear();
    }

    public CubeLevel getLevel(int n) {
        return this.m_Level.get(n);
    }

    public int getLevelCount() {
        return this.m_Level.size();
    }

    public Iterator<CubeLevel> getLevelIterator() {
        return this.m_Level.iterator();
    }

    public List<CubeLevel> getLevelList() {
        return this.m_Level;
    }

    public void setLevelList(List<CubeLevel> list) {
        this.m_Level = list;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public CubeHierarchy deepCopy() {
        CubeHierarchy cubeHierarchy = new CubeHierarchy();
        this.copyInto(cubeHierarchy);
        return cubeHierarchy;
    }

    protected void copyInto(CubeHierarchy cubeHierarchy) {
        cubeHierarchy.m_Name = this.m_Name;
        cubeHierarchy.m_Level = new ArrayList<CubeLevel>();
        for (CubeLevel cubeLevel : this.m_Level) {
            cubeHierarchy.addLevel(cubeLevel.deepCopy());
        }
    }
}

