/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.awt.Image;
import java.util.Arrays;
import java.util.Set;

public class MapElement
extends RawElement
implements IBean,
PropertyImplementor {
    protected Script m_Script;
    protected String m_MapFile;
    protected String m_DataKey;
    protected String m_DataColumn;
    protected String m_DataSource;
    protected String m_DataRange;
    protected transient Image m_Image;
    protected transient boolean m_LoadError;
    private static String[] m_PropertyNameStrings = new String[]{"MapElement.MapFile".intern(), "MapElement.DataKey".intern(), "MapElement.DataColumn".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Wizard", "Wizard", "Wizard"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        if (BeanUtil.methodMatches(string, "RawElement.Growable")) {
            return true;
        }
        return BeanUtil.methodMatches(string, "RawElement.Shrinkable");
    }

    @Override
    public String getTagName() {
        return "map";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Script != null) {
            this.m_Script.loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Image != null) {
            this.m_Image.flush();
            this.m_Image = null;
        }
        if (this.m_Script != null) {
            if (this.m_Script != null) {
                this.m_Script.dispose();
            }
            this.m_Script = null;
        }
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_MapFile != null) {
            element.setAttribute("map", this.m_MapFile);
        }
        if (this.m_DataKey != null) {
            element.setAttribute("data-key", this.m_DataKey);
        }
        if (this.m_DataColumn != null) {
            element.setAttribute("data-column", this.m_DataColumn);
        }
        if (this.m_DataSource != null) {
            element.setAttribute("datasource", this.m_DataSource);
        }
        if (this.m_DataRange != null) {
            element.setAttribute("datarange", this.m_DataRange);
        }
        element.setAttribute("", this.m_LoadError ? "Yes" : "No");
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        MapElement mapElement = (MapElement)super.shallowCopy();
        mapElement.m_DataSource = this.m_DataSource;
        mapElement.m_DataRange = this.m_DataRange;
        mapElement.m_Image = this.m_Image;
        mapElement.m_LoadError = this.m_LoadError;
        return mapElement;
    }

    public Script getScript() {
        return this.m_Script;
    }

    public void setScript(Script script) {
        this.m_Script = script;
    }

    public String getDataSource() {
        return this.m_DataSource;
    }

    public void setDataSource(String string) {
        this.m_DataSource = string;
    }

    public String getDataRange() {
        return this.m_DataRange;
    }

    public void setDataRange(String string) {
        this.m_DataRange = string;
    }

    public Image getImage() {
        return this.m_Image;
    }

    public void setImage(Image image) {
        this.m_Image = image;
    }

    public boolean isLoadError() {
        return this.m_LoadError;
    }

    public void setLoadError(boolean bl) {
        this.m_LoadError = bl;
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public String getMapFile() {
        if (this.m_MapFile != null) {
            return this.m_MapFile;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    public void setMapFile(String string) {
        this.m_MapFile = string;
    }

    public String getDataKey() {
        if (this.m_DataKey != null) {
            return this.m_DataKey;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
    }

    public void setDataKey(String string) {
        this.m_DataKey = string;
    }

    public String getDataColumn() {
        if (this.m_DataColumn != null) {
            return this.m_DataColumn;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
    }

    public void setDataColumn(String string) {
        this.m_DataColumn = string;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
        set.remove(Name.apply("RawElement.Growable", ""));
        set.remove(Name.apply("RawElement.Shrinkable", ""));
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_MapFile = (String)object;
                        break;
                    }
                    case 1: {
                        this.m_DataKey = (String)object;
                        break;
                    }
                    case 2: {
                        this.m_DataColumn = (String)object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + String.valueOf(this.getClass()));
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + String.valueOf(object) + "(" + String.valueOf(object.getClass()) + ") : " + String.valueOf(exception));
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_MapFile;
            }
            case 1: {
                return this.m_DataKey;
            }
            case 2: {
                return this.m_DataColumn;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + String.valueOf(this.getClass()));
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public MapElement deepCopy() {
        MapElement mapElement = new MapElement();
        this.copyInto(mapElement);
        return mapElement;
    }

    protected void copyInto(MapElement mapElement) {
        super.copyInto(mapElement);
        mapElement.m_MapFile = this.m_MapFile;
        mapElement.m_DataKey = this.m_DataKey;
        mapElement.m_DataColumn = this.m_DataColumn;
        mapElement.m_DataSource = this.m_DataSource;
        mapElement.m_DataRange = this.m_DataRange;
        mapElement.m_Image = this.m_Image;
        mapElement.m_LoadError = this.m_LoadError;
        if (this.m_Script != null) {
            mapElement.m_Script = this.m_Script.deepCopy();
        }
    }

    static {
        try {
            m_IndexOffset = RawElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                MapElement.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                MapElement.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            MapElement.logError("Error in property initialization", throwable);
        }
    }
}

