/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;

public class PageSetup
implements IBean {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PageSetup.class);
    protected boolean m_IsLoaded;
    public static final String PORTRAIT = "Portrait";
    public static final String LANDSCAPE = "Landscape";
    public static final String ACROSS_THEN_DOWN = "Across Then Down";
    public static final String DOWN_THEN_ACROSS = "Down Then Across";
    protected String m_Name = "";
    protected String m_Paper;
    protected int m_Width;
    protected int m_Height;
    protected String m_Orientation = "Portrait";
    protected int m_HorizontalPageCount;
    protected int m_Top;
    protected int m_Left;
    protected int m_Bottom;
    protected int m_Right;
    protected int m_ColumnCount;
    protected int m_ColumnSpacing;
    protected int m_RowSpacing;
    protected String m_ColumnLayout = "Down Then Across";

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "page-setup";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
    }

    @Override
    public void dispose() {
    }

    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
        if (this.m_Paper != null) {
            element.setAttribute("paper", this.m_Paper);
        }
        element.setAttribute("page-width", Integer.toString(this.m_Width));
        element.setAttribute("page-height", Integer.toString(this.m_Height));
        if (this.m_Orientation != null) {
            element.setAttribute("orientation", this.m_Orientation);
        }
        element.setAttribute("horizontal-page-count", Integer.toString(this.m_HorizontalPageCount));
        element.setAttribute("margin-top", Integer.toString(this.m_Top));
        element.setAttribute("margin-left", Integer.toString(this.m_Left));
        element.setAttribute("margin-bottom", Integer.toString(this.m_Bottom));
        element.setAttribute("margin-right", Integer.toString(this.m_Right));
        element.setAttribute("column-count", Integer.toString(this.m_ColumnCount));
        element.setAttribute("column-spacing", Integer.toString(this.m_ColumnSpacing));
        element.setAttribute("row-spacing", Integer.toString(this.m_RowSpacing));
        if (this.m_ColumnLayout != null) {
            element.setAttribute("column-layout", this.m_ColumnLayout);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        PageSetup pageSetup = (PageSetup)this.getClass().newInstance();
        pageSetup.m_Name = this.m_Name;
        pageSetup.m_Paper = this.m_Paper;
        pageSetup.m_Width = this.m_Width;
        pageSetup.m_Height = this.m_Height;
        pageSetup.m_Orientation = this.m_Orientation;
        pageSetup.m_HorizontalPageCount = this.m_HorizontalPageCount;
        pageSetup.m_Top = this.m_Top;
        pageSetup.m_Left = this.m_Left;
        pageSetup.m_Bottom = this.m_Bottom;
        pageSetup.m_Right = this.m_Right;
        pageSetup.m_ColumnCount = this.m_ColumnCount;
        pageSetup.m_ColumnSpacing = this.m_ColumnSpacing;
        pageSetup.m_RowSpacing = this.m_RowSpacing;
        pageSetup.m_ColumnLayout = this.m_ColumnLayout;
        return pageSetup;
    }

    public boolean isAcrossThenDown() {
        return ACROSS_THEN_DOWN.equals(this.m_ColumnLayout);
    }

    public boolean isDownThenAcross() {
        return DOWN_THEN_ACROSS.equals(this.m_ColumnLayout);
    }

    public String toString() {
        return this.m_Name;
    }

    public int getBodyWidth() {
        return (this.m_Width - this.m_Left - this.m_Right) * this.m_HorizontalPageCount;
    }

    public int getUsablePageWidth() {
        return this.m_Width - this.m_Left - this.m_Right;
    }

    public int getColumnWidth() {
        int n = (this.m_Width - this.m_Left - this.m_Right) * this.m_HorizontalPageCount;
        int n2 = (this.m_ColumnCount - 1) * this.m_ColumnSpacing;
        return (n - n2) / this.m_ColumnCount;
    }

    public void copyFrom(PageSetup pageSetup) {
        this.m_Name = pageSetup.m_Name;
        this.m_Paper = pageSetup.m_Paper;
        this.m_Width = pageSetup.m_Width;
        this.m_Height = pageSetup.m_Height;
        this.m_Orientation = pageSetup.m_Orientation;
        this.m_HorizontalPageCount = pageSetup.m_HorizontalPageCount;
        this.m_Top = pageSetup.m_Top;
        this.m_Left = pageSetup.m_Left;
        this.m_Bottom = pageSetup.m_Bottom;
        this.m_Right = pageSetup.m_Right;
        this.m_ColumnCount = pageSetup.m_ColumnCount;
        this.m_ColumnSpacing = pageSetup.m_ColumnSpacing;
        this.m_RowSpacing = pageSetup.m_RowSpacing;
        this.m_ColumnLayout = pageSetup.m_ColumnLayout;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
        if (this.m_Name != null) {
            this.m_Name = this.m_Name.trim();
        }
    }

    public String getPaper() {
        return this.m_Paper;
    }

    public void setPaper(String string) {
        this.m_Paper = string;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public void setWidth(int n) {
        this.m_Width = n;
    }

    public int getHeight() {
        return this.m_Height;
    }

    public void setHeight(int n) {
        this.m_Height = n;
    }

    public String getOrientation() {
        return this.m_Orientation;
    }

    public void setOrientation(String string) {
        this.m_Orientation = string;
    }

    public int getHorizontalPageCount() {
        return this.m_HorizontalPageCount;
    }

    public void setHorizontalPageCount(int n) {
        this.m_HorizontalPageCount = n;
    }

    public int getTop() {
        return this.m_Top;
    }

    public void setTop(int n) {
        this.m_Top = n;
    }

    public int getLeft() {
        return this.m_Left;
    }

    public void setLeft(int n) {
        this.m_Left = n;
    }

    public int getBottom() {
        return this.m_Bottom;
    }

    public void setBottom(int n) {
        this.m_Bottom = n;
    }

    public int getRight() {
        return this.m_Right;
    }

    public void setRight(int n) {
        this.m_Right = n;
    }

    public int getColumnCount() {
        return this.m_ColumnCount;
    }

    public void setColumnCount(int n) {
        this.m_ColumnCount = n;
    }

    public int getColumnSpacing() {
        return this.m_ColumnSpacing;
    }

    public void setColumnSpacing(int n) {
        this.m_ColumnSpacing = n;
    }

    public int getRowSpacing() {
        return this.m_RowSpacing;
    }

    public void setRowSpacing(int n) {
        this.m_RowSpacing = n;
    }

    public String getColumnLayout() {
        return this.m_ColumnLayout;
    }

    public void setColumnLayout(String string) {
        this.m_ColumnLayout = string;
    }

    public PageSetup deepCopy() {
        PageSetup pageSetup = new PageSetup();
        this.copyInto(pageSetup);
        return pageSetup;
    }

    protected void copyInto(PageSetup pageSetup) {
        pageSetup.m_Name = this.m_Name;
        pageSetup.m_Paper = this.m_Paper;
        pageSetup.m_Width = this.m_Width;
        pageSetup.m_Height = this.m_Height;
        pageSetup.m_Orientation = this.m_Orientation;
        pageSetup.m_HorizontalPageCount = this.m_HorizontalPageCount;
        pageSetup.m_Top = this.m_Top;
        pageSetup.m_Left = this.m_Left;
        pageSetup.m_Bottom = this.m_Bottom;
        pageSetup.m_Right = this.m_Right;
        pageSetup.m_ColumnCount = this.m_ColumnCount;
        pageSetup.m_ColumnSpacing = this.m_ColumnSpacing;
        pageSetup.m_RowSpacing = this.m_RowSpacing;
        pageSetup.m_ColumnLayout = this.m_ColumnLayout;
    }
}

