/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.awt.Image;
import java.util.Arrays;
import java.util.Set;

public class SVG
extends RawElement
implements IBean,
PropertyImplementor {
    protected Document m_Document;
    protected String m_Location;
    protected Integer m_ImageResolution;
    protected Boolean m_Dynamic;
    protected transient Image m_Image;
    protected transient boolean m_LoadError;
    private static String[] m_PropertyNameStrings = new String[]{"SVG.Location".intern(), "Common.ImageResolution".intern(), "SVG.Dynamic".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"FilePath", "Integer", "Boolean"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        if (BeanUtil.methodMatches(string, "RawElement.Growable")) {
            return true;
        }
        return BeanUtil.methodMatches(string, "RawElement.Shrinkable");
    }

    @Override
    public String getTagName() {
        return "svg";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Document != null) {
            // empty if block
        }
    }

    @Override
    public void dispose() {
        if (this.m_Image != null) {
            this.m_Image.flush();
            this.m_Image = null;
        }
        if (this.m_Document != null) {
            this.m_Document = null;
        }
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Location != null) {
            element.setAttribute("location", this.m_Location);
        }
        if (this.m_ImageResolution != null) {
            element.setAttribute("image-resolution", this.m_ImageResolution.toString());
        }
        if (this.m_Dynamic != null) {
            element.setAttribute("dynamic", this.m_Dynamic != false ? "Yes" : "No");
        }
        element.setAttribute("", this.m_LoadError ? "Yes" : "No");
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        SVG sVG = (SVG)super.shallowCopy();
        sVG.m_Image = this.m_Image;
        sVG.m_LoadError = this.m_LoadError;
        return sVG;
    }

    public Document getDocument() {
        return this.m_Document;
    }

    public void setDocument(Document document) {
        this.m_Document = document;
        this.m_Image = null;
        this.m_LoadError = false;
    }

    public Image getImage() {
        return this.m_Image;
    }

    public void setImage(Image image) {
        this.m_Image = image;
    }

    public boolean isLoadError() {
        return this.m_LoadError;
    }

    public void setLoadError(boolean bl) {
        this.m_LoadError = bl;
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public String getLocation() {
        if (this.m_Location != null) {
            return this.m_Location;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    public void setLocation(String string) {
        this.m_Location = string;
        if (this.m_Location != null) {
            this.m_Location = this.m_Location.trim();
        }
        this.m_Image = null;
        this.m_LoadError = false;
    }

    public int getImageResolution() {
        Integer n = this.m_ImageResolution;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
        }
        return n;
    }

    public void setImageResolution(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_ImageResolution = n;
    }

    public void setImageResolution(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_ImageResolution = n;
    }

    public boolean isDynamic() {
        Boolean bl = this.m_Dynamic;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
        }
        return bl;
    }

    public void setDynamic(boolean bl) {
        this.m_Dynamic = bl;
    }

    public void setDynamic(Boolean bl) {
        this.m_Dynamic = bl;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
        set.remove(Name.apply("RawElement.Growable", ""));
        set.remove(Name.apply("RawElement.Shrinkable", ""));
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_Location = (String)object;
                        if (this.m_Location != null) {
                            this.m_Location = this.m_Location.trim();
                        }
                        this.m_Image = null;
                        this.m_LoadError = false;
                        break;
                    }
                    case 1: {
                        this.setImageResolution((Integer)object);
                        break;
                    }
                    case 2: {
                        this.m_Dynamic = (Boolean)object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + String.valueOf(this.getClass()));
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + String.valueOf(object) + "(" + String.valueOf(object.getClass()) + ") : " + String.valueOf(exception));
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_Location;
            }
            case 1: {
                return this.m_ImageResolution;
            }
            case 2: {
                return this.m_Dynamic;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + String.valueOf(this.getClass()));
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public SVG deepCopy() {
        SVG sVG = new SVG();
        this.copyInto(sVG);
        return sVG;
    }

    protected void copyInto(SVG sVG) {
        super.copyInto(sVG);
        sVG.m_Location = this.m_Location;
        sVG.m_ImageResolution = this.m_ImageResolution;
        sVG.m_Dynamic = this.m_Dynamic;
        sVG.m_Image = this.m_Image;
        sVG.m_LoadError = this.m_LoadError;
        if (this.m_Document != null) {
            sVG.m_Document = (Document)this.m_Document.clone();
        }
    }

    static {
        try {
            m_IndexOffset = RawElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                SVG.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                SVG.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            SVG.logError("Error in property initialization", throwable);
        }
    }
}

