/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.ISplittableElement;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.TableBody;
import com.elixirtech.report2.raw.model.TableFooter;
import com.elixirtech.report2.raw.model.TableHeader;
import com.elixirtech.report2.raw.model.TableSection;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Table
extends RawElement
implements IBean,
PropertyImplementor,
IRawElementHolder,
ISplittableElement {
    public static final String RANGE_ALL = "All";
    public static final String RANGE_GROUP = "Group";
    public static final String RANGE_RECORD = "Record";
    protected TableHeader m_Header;
    protected TableBody m_Body;
    protected TableFooter m_Footer;
    protected Boolean m_ShowEmptyTable;
    protected Boolean m_KeepTogether;
    protected String m_Cache;
    protected String m_DataRange;
    private static String[] m_PropertyNameStrings = new String[]{"Table.ShowEmptyTable".intern(), "Common.KeepTogether".intern(), "Table.Cache".intern(), "Table.DataRange".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Boolean", "Boolean", "String", "Choice.DataRange"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "table";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Header != null) {
            this.m_Header.loaded();
        }
        if (this.m_Body != null) {
            this.m_Body.loaded();
        }
        if (this.m_Footer != null) {
            this.m_Footer.loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Header != null) {
            if (this.m_Header != null) {
                this.m_Header.dispose();
            }
            this.m_Header = null;
        }
        if (this.m_Body != null) {
            if (this.m_Body != null) {
                this.m_Body.dispose();
            }
            this.m_Body = null;
        }
        if (this.m_Footer != null) {
            if (this.m_Footer != null) {
                this.m_Footer.dispose();
            }
            this.m_Footer = null;
        }
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_ShowEmptyTable != null) {
            element.setAttribute("display-table", this.m_ShowEmptyTable != false ? "Yes" : "No");
        }
        if (this.m_KeepTogether != null) {
            element.setAttribute("keep-together", this.m_KeepTogether != false ? "Yes" : "No");
        }
        if (this.m_Cache != null) {
            element.setAttribute("cache", this.m_Cache);
        }
        if (this.m_DataRange != null) {
            element.setAttribute("datarange", this.m_DataRange);
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Table table = (Table)super.shallowCopy();
        return table;
    }

    @Override
    public int getRawElementCount() {
        return 3;
    }

    @Override
    public RawModelElement getRawElement(int n) {
        if (n == 0) {
            return this.getHeader();
        }
        if (n == 1) {
            return this.getBody();
        }
        if (n == 2) {
            return this.getFooter();
        }
        return null;
    }

    @Override
    public Iterator<RawModelElement> getRawElementIterator() {
        ArrayList<TableSection> arrayList = new ArrayList<TableSection>();
        arrayList.add(this.getHeader());
        arrayList.add(this.getBody());
        arrayList.add(this.getFooter());
        return arrayList.iterator();
    }

    @Override
    public List<RawModelElement> getRawElementList() {
        ArrayList<RawModelElement> arrayList = new ArrayList<RawModelElement>();
        arrayList.add(this.getHeader());
        arrayList.add(this.getBody());
        arrayList.add(this.getFooter());
        return arrayList;
    }

    @Override
    public int indexOfRawElement(RawModelElement rawModelElement) {
        if (rawModelElement == this.getHeader()) {
            return 0;
        }
        if (rawModelElement == this.getBody()) {
            return 1;
        }
        if (rawModelElement == this.getFooter()) {
            return 2;
        }
        return -1;
    }

    public TableHeader getHeader() {
        return this.m_Header;
    }

    public void setHeader(TableHeader tableHeader) {
        this.m_Header = tableHeader;
        this.m_Header.setParent(this);
    }

    public TableBody getBody() {
        return this.m_Body;
    }

    public void setBody(TableBody tableBody) {
        this.m_Body = tableBody;
        this.m_Body.setParent(this);
    }

    public TableFooter getFooter() {
        return this.m_Footer;
    }

    public void setFooter(TableFooter tableFooter) {
        this.m_Footer = tableFooter;
        this.m_Footer.setParent(this);
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public boolean isShowEmptyTable() {
        Boolean bl = this.m_ShowEmptyTable;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
        }
        return bl;
    }

    public void setShowEmptyTable(boolean bl) {
        this.m_ShowEmptyTable = bl;
    }

    public void setShowEmptyTable(Boolean bl) {
        this.m_ShowEmptyTable = bl;
    }

    @Override
    public boolean isKeepTogether() {
        Boolean bl = this.m_KeepTogether;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
        }
        return bl;
    }

    @Override
    public void setKeepTogether(boolean bl) {
        this.m_KeepTogether = bl;
    }

    @Override
    public void setKeepTogether(Boolean bl) {
        this.m_KeepTogether = bl;
    }

    public String getCache() {
        if (this.m_Cache != null) {
            return this.m_Cache;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
    }

    public void setCache(String string) {
        this.m_Cache = string;
    }

    public String getDataRange() {
        if (this.m_DataRange != null) {
            return this.m_DataRange;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 4 - 1);
    }

    public void setDataRange(String string) {
        this.m_DataRange = string;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_ShowEmptyTable = (Boolean)object;
                        break;
                    }
                    case 1: {
                        this.m_KeepTogether = (Boolean)object;
                        break;
                    }
                    case 2: {
                        this.m_Cache = (String)object;
                        break;
                    }
                    case 3: {
                        this.m_DataRange = (String)object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + String.valueOf(this.getClass()));
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + String.valueOf(object) + "(" + String.valueOf(object.getClass()) + ") : " + String.valueOf(exception));
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_ShowEmptyTable;
            }
            case 1: {
                return this.m_KeepTogether;
            }
            case 2: {
                return this.m_Cache;
            }
            case 3: {
                return this.m_DataRange;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + String.valueOf(this.getClass()));
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public Table deepCopy() {
        Table table = new Table();
        this.copyInto(table);
        return table;
    }

    protected void copyInto(Table table) {
        super.copyInto(table);
        table.m_ShowEmptyTable = this.m_ShowEmptyTable;
        table.m_KeepTogether = this.m_KeepTogether;
        table.m_Cache = this.m_Cache;
        table.m_DataRange = this.m_DataRange;
        if (this.m_Header != null) {
            table.m_Header = this.m_Header.deepCopy();
            table.m_Header.setParent(this);
        }
        if (this.m_Body != null) {
            table.m_Body = this.m_Body.deepCopy();
            table.m_Body.setParent(this);
        }
        if (this.m_Footer != null) {
            table.m_Footer = this.m_Footer.deepCopy();
            table.m_Footer.setParent(this);
        }
    }

    static {
        try {
            m_IndexOffset = RawElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                Table.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                Table.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            Table.logError("Error in property initialization", throwable);
        }
    }
}

