/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.property;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.grouping.GrouperFactory;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GlyphOrientation;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.i18n.I18NName;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.ChoicePropertyType;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SubReport;
import com.elixirtech.ui.property.I18N;
import com.elixirtech.ui.property.I18NChoicePropertyType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UiPropertyChoices {
    public static final ChoicePropertyType STYLE = new StylePropertyType();
    public static final ChoicePropertyType ARROW_END_STYLE = new ArrowEndPropertyType();
    public static final ChoicePropertyType BORDER_STYLE = new BorderStylePropertyType();
    public static final ChoicePropertyType LINE_STYLE = new LineStylePropertyType();
    public static final ChoicePropertyType BACKGROUND_STYLE = new BackgroundStylePropertyType();
    public static final ChoicePropertyType RECTANGLE_ALIGNMENT = new RectangleAlignmentPropertyType();
    public static final ChoicePropertyType RECTANGLE_SIZE = new RectangleSizePropertyType();
    public static final ChoicePropertyType TEXT_ALIGNMENT = new TextAlignmentPropertyType();
    public static final ChoicePropertyType ORIENTATION = new OrientationPropertyType();
    public static final ChoicePropertyType WRITING_MODE = new WritingModePropertyType();
    public static final ChoicePropertyType GRID_MODE = new GridModePropertyType();
    public static final ChoicePropertyType GLYPH_ORIENTATION = new GlyphOrientationPropertyType();
    public static final ChoicePropertyType HORIZONTAL_ALIGNMENT = new HorizontalAlignmentPropertyType();
    public static final ChoicePropertyType LEFT_RIGHT_ALIGNMENT = new LeftRightAlignmentPropertyType();
    public static final ChoicePropertyType VERTICAL_ALIGNMENT = new VerticalAlignmentPropertyType();
    public static final ChoicePropertyType SORT = new SortPropertyType();
    public static final ChoicePropertyType GROUP_ON = new GroupOnPropertyType();
    public static final ChoicePropertyType SECTION = new SectionPropertyType();
    public static final ChoicePropertyType FORCE_PAGE_BREAK = new ForcePageBreakPropertyType();
    public static final ChoicePropertyType PAGE_HEADER_FOOTER = new ShowPageHeaderFooterPropertyType();
    public static final ChoicePropertyType PAGE_SETUP = new PageSetupPropertyType();
    public static final ChoicePropertyType DATASOURCE = new DataSourcePropertyType();
    public static final ChoicePropertyType DATA_FIELD = new DataFieldPropertyType();
    public static final ChoicePropertyType METER_DISPLAY_STYLE = new MeterDisplayStylePropertyType();
    public static final ChoicePropertyType DATA_RANGE = new DataRangePropertyType();
    public static final ChoicePropertyType WIDTH_OVERRIDE = new WidthOverridePropertyType();
    public static final ChoicePropertyType URL_TARGET = new URLTargetPropertyType();
    public static final ChoicePropertyType GRAPH_LAYOUT = new GraphLayoutPropertyType();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(UiPropertyChoices.class);

    private static class StylePropertyType
    extends ChoicePropertyType {
        public StylePropertyType() {
            super("Choice.Style");
        }

        @Override
        public Object[] getChoices(List<? extends PropertyHolder> list) {
            if (list.size() == 0) {
                return new String[]{""};
            }
            RawModelElement rawModelElement = (RawModelElement)list.get(0);
            RawReport rawReport = (RawReport)rawModelElement.getResourceProvider();
            if (rawReport == null) {
                return new Object[0];
            }
            Object[] objectArray = rawReport.getStyleNames();
            return objectArray;
        }
    }

    private static class ArrowEndPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"None", "Arrow", "Diamond", "Open-Arrow", "Round", "Square", "Symmetric-Arrow"};
        private static final String[] KEYS = new String[]{"ArrowEnd.None", "ArrowEnd.Arrow", "ArrowEnd.Diamond", "ArrowEnd.OpenArrow", "ArrowEnd.Round", "ArrowEnd.Square", "ArrowEnd.SymmetricArrow"};

        public ArrowEndPropertyType() {
            super("Choice.ArrowEndStyle", IDS, I18N.ERD, KEYS);
        }
    }

    private static class BorderStylePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{BorderStyle.NONE.NAME, BorderStyle.SOLID.NAME, BorderStyle.DASHED.NAME, BorderStyle.DOTTED.NAME, BorderStyle.DOUBLE.NAME, BorderStyle.GROOVE.NAME, BorderStyle.RIDGE.NAME, BorderStyle.INSET.NAME, BorderStyle.OUTSET.NAME, BorderStyle.DOTDASH.NAME, BorderStyle.DOTDOTDASH.NAME, BorderStyle.WAVE.NAME};
        private static final String[] KEYS = new String[]{"BorderStyle.None", "BorderStyle.Solid", "BorderStyle.Dashed", "BorderStyle.Dotted", "BorderStyle.Double", "BorderStyle.Groove", "BorderStyle.Ridge", "BorderStyle.Inset", "BorderStyle.Outset", "BorderStyle.DotDash", "BorderStyle.DotDotDash", "BorderStyle.Wave"};

        public BorderStylePropertyType() {
            super("Choice.BorderStyle", IDS, I18N.ERD, KEYS);
        }
    }

    private static class LineStylePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{BorderStyle.NONE.NAME, BorderStyle.SOLID.NAME, BorderStyle.DASHED.NAME, BorderStyle.DOTTED.NAME, BorderStyle.DOUBLE.NAME, BorderStyle.DOTDASH.NAME, BorderStyle.DOTDOTDASH.NAME, BorderStyle.WAVE.NAME};
        private static final String[] KEYS = new String[]{"BorderStyle.None", "BorderStyle.Solid", "BorderStyle.Dashed", "BorderStyle.Dotted", "BorderStyle.Double", "BorderStyle.DotDash", "BorderStyle.DotDotDash", "BorderStyle.Wave"};

        public LineStylePropertyType() {
            super("Choice.LineStyle", IDS, I18N.ERD, KEYS);
        }
    }

    private static class BackgroundStylePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Solid", "Transparent"};
        private static final String[] KEYS = new String[]{"BackgroundStyle.Solid", "BackgroundStyle.Transparent"};

        public BackgroundStylePropertyType() {
            super("Choice.BackgroundStyle", IDS, I18N.ERD, KEYS);
        }
    }

    private static class RectangleAlignmentPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Top Left", "Top Right", "Bottom Left", "Bottom Right", "Center"};
        private static final String[] KEYS = new String[]{"Alignment.TopLeft", "Alignment.TopRight", "Alignment.BottomLeft", "Alignment.BottomRight", "Alignment.Center"};

        public RectangleAlignmentPropertyType() {
            super("Choice.RectangleAlignment", IDS, I18N.ERD, KEYS);
        }
    }

    private static class RectangleSizePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Clip", "Stretch", "Zoom"};
        private static final String[] KEYS = new String[]{"Size.Clip", "Size.Stretch", "Size.Zoom"};

        public RectangleSizePropertyType() {
            super("Choice.RectangleSize", IDS, I18N.ERD, KEYS);
        }
    }

    private static class TextAlignmentPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Left", "Right", "Center", "Justify"};
        private static final String[] KEYS = new String[]{"TextAlignment.Left", "TextAlignment.Right", "TextAlignment.Center", "TextAlignment.Justify"};

        public TextAlignmentPropertyType() {
            super("Choice.TextAlignment", IDS, I18N.ERD, KEYS);
        }
    }

    private static class OrientationPropertyType
    extends ChoicePropertyType {
        public OrientationPropertyType() {
            super("Choice.Orientation", new Integer[]{new Integer(0), new Integer(90), new Integer(180), new Integer(270)});
        }
    }

    private static class WritingModePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{WritingMode.LR_TB.getName(), WritingMode.TB_RL.getName(), WritingMode.RL_TB.getName(), WritingMode.TB_LR.getName()};
        private static final String[] KEYS = new String[]{"Grid.WritingMode.LR_TB", "Grid.WritingMode.TB_RL", "Grid.WritingMode.RL_TB", "Grid.WritingMode.TB_LR"};

        public WritingModePropertyType() {
            super("Choice.WritingMode", IDS, I18N.ERD, KEYS);
        }
    }

    private static class GridModePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"All", "Ideograph"};
        private static final String[] KEYS = new String[]{"GridMode.All", "GridMode.Ideograph"};

        public GridModePropertyType() {
            super("Choice.GridMode", IDS, I18N.ERD, KEYS);
        }
    }

    private static class GlyphOrientationPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{GlyphOrientation.AUTO.getName(), GlyphOrientation.INLINE.getName(), GlyphOrientation.UPRIGHT.getName()};
        private static final String[] KEYS = new String[]{"GlyphOrientation.Auto", "GlyphOrientation.Inline", "GlyphOrientation.Upright"};

        public GlyphOrientationPropertyType() {
            super("Choice.GlyphOrientation", IDS, I18N.ERD, KEYS);
        }
    }

    private static class HorizontalAlignmentPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Left", "Center", "Right"};
        private static final String[] KEYS = new String[]{"HorizontalAlignment.Left", "HorizontalAlignment.Center", "HorizontalAlignment.Right"};

        public HorizontalAlignmentPropertyType() {
            super("Choice.HorizontalAlignment", IDS, I18N.ERD, KEYS);
        }
    }

    private static class LeftRightAlignmentPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Left", "Right"};
        private static final String[] KEYS = new String[]{"Alignment.Left", "Alignment.Right"};

        public LeftRightAlignmentPropertyType() {
            super("Choice.LeftRightAlignment", IDS, I18N.ERD, KEYS);
        }
    }

    private static class VerticalAlignmentPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Top", "Center", "Bottom"};
        private static final String[] KEYS = new String[]{"VAlignment.Top", "VAlignment.Center", "VAlignment.Bottom"};

        public VerticalAlignmentPropertyType() {
            super("Choice.VerticalAlignment", IDS, I18N.ERD, KEYS);
        }
    }

    private static class SortPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"None", "Ascending", "Ascending-Lexicographic", "Descending", "Descending-Lexicographic"};
        private static final String[] KEYS = new String[]{"Sort.NONE", "Sort.ASCENDING", "Sort.ASCENDING_LEXICOGRAPHIC", "Sort.DESCENDING", "Sort.DESCENDING_LEXICOGRAPHIC"};

        public SortPropertyType() {
            super("Choice.Sort", IDS, I18N.ENSEMBLE, KEYS);
        }
    }

    private static class GroupOnPropertyType
    extends I18NChoicePropertyType {
        public GroupOnPropertyType() {
            super("Choice.GroupOn", GroupOnPropertyType.buildNames());
        }

        private static Name[] buildNames() {
            String[] stringArray = GrouperFactory.getGroupOnNames();
            Name[] nameArray = new Name[stringArray.length];
            for (int i = 0; i < nameArray.length; ++i) {
                String string = "Group." + stringArray[i].replace(' ', '_').toUpperCase(Locale.ENGLISH);
                nameArray[i] = I18NName.apply(stringArray[i], I18N.ENSEMBLE, string);
            }
            return nameArray;
        }
    }

    private static class SectionPropertyType
    extends ChoicePropertyType {
        public SectionPropertyType() {
            super("Choice.Section");
        }

        @Override
        public Object[] getChoices(List<? extends PropertyHolder> list) {
            Object[] objectArray;
            if (list.size() == 0) {
                return new String[0];
            }
            PropertyHolder propertyHolder = list.get(0);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (propertyHolder instanceof Section) {
                arrayList.add("");
                objectArray = (Section)propertyHolder;
                RawReport rawReport = (RawReport)objectArray.getRawReport();
                for (Section section : rawReport.getSectionList()) {
                    if (section == objectArray) continue;
                    arrayList.add(section.getName());
                }
            } else if (propertyHolder instanceof SubReport) {
                objectArray = (SubReport)propertyHolder;
                RawReport rawReport = (RawReport)objectArray.getResourceProvider();
                for (Section section : rawReport.getSectionList()) {
                    arrayList.add(section.getName());
                }
            }
            objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            return objectArray;
        }
    }

    private static class ForcePageBreakPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"None", "Before", "After", "Before and After"};
        private static final String[] KEYS = new String[]{"ForcePageBreak.None", "ForcePageBreak.Before", "ForcePageBreak.After", "ForcePageBreak.BeforeAndAfter"};

        public ForcePageBreakPropertyType() {
            super("Choice.ForcePageBreak", IDS, I18N.ERD, KEYS);
        }
    }

    private static class ShowPageHeaderFooterPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Always", "Not with Section Header", "Not with Section Footer", "Never"};
        private static final String[] KEYS = new String[]{"ShowPHF.Always", "ShowPHF.NotWithSectionHeader", "ShowPHF.NotWithSectionFooter", "ShowPHF.Never"};

        public ShowPageHeaderFooterPropertyType() {
            super("Choice.ShowPageHeaderFooter", IDS, I18N.ERD, KEYS);
        }
    }

    private static class PageSetupPropertyType
    extends ChoicePropertyType {
        public PageSetupPropertyType() {
            super("Choice.PageSetup");
        }

        @Override
        public Object[] getChoices(List<? extends PropertyHolder> list) {
            Object[] objectArray;
            if (list.size() == 0) {
                return new String[0];
            }
            PropertyHolder propertyHolder = list.get(0);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (propertyHolder instanceof Section) {
                objectArray = (Object[])propertyHolder;
                RawReport rawReport = (RawReport)objectArray.getRawReport();
                for (PageSetup pageSetup : rawReport.getPageSetupList()) {
                    arrayList.add(pageSetup.getName());
                }
            }
            objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            return objectArray;
        }
    }

    private static class DataSourcePropertyType
    extends ChoicePropertyType {
        public DataSourcePropertyType() {
            super("Choice.DataSource");
        }

        @Override
        public Object[] getChoices(List<? extends PropertyHolder> list) {
            Object[] objectArray;
            if (list.size() == 0) {
                return new String[]{""};
            }
            PropertyHolder propertyHolder = list.get(0);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            if (propertyHolder instanceof Section) {
                objectArray = (Section)propertyHolder;
                RawReport rawReport = (RawReport)objectArray.getRawReport();
                for (DataSource dataSource : rawReport.getDataSourceList()) {
                    arrayList.add(dataSource.getName());
                }
            } else if (propertyHolder instanceof SubReport) {
                objectArray = (SubReport)propertyHolder;
                RawReport rawReport = (RawReport)objectArray.getResourceProvider();
                for (DataSource dataSource : rawReport.getDataSourceList()) {
                    arrayList.add(dataSource.getName());
                }
            }
            objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            return objectArray;
        }
    }

    private static class DataFieldPropertyType
    extends ChoicePropertyType {
        public DataFieldPropertyType() {
            super("Choice.DataField");
        }

        @Override
        public Object[] getChoices(List<? extends PropertyHolder> list) {
            Object[] objectArray;
            ArrayList<String> arrayList;
            block10: {
                if (list.size() == 0) {
                    return new String[]{""};
                }
                PropertyHolder propertyHolder = list.get(0);
                arrayList = new ArrayList<String>();
                if (propertyHolder instanceof Section) {
                    objectArray = (Object[])propertyHolder;
                    RawReport rawReport = (RawReport)objectArray.getRawReport();
                    DataSource dataSource = rawReport.getDataSource(objectArray.getDataSource());
                    if (dataSource != null) {
                        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
                        try {
                            String string = dataSource.getDataSourceName();
                            if (string == null) break block10;
                            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
                            if (iDataSource != null) {
                                DataSchema dataSchema = iDataSource.getSchema();
                                int n = dataSchema.getColumnCount();
                                for (int i = 0; i < n; ++i) {
                                    arrayList.add(dataSchema.getColumnName(i));
                                }
                                break block10;
                            }
                            m_Log.error((Object)("No datasource " + dataSource.getDataSourceName() + " found"));
                        }
                        catch (Exception exception) {
                            m_Log.error((Object)("Exception populating DataFieldPropertyType : " + String.valueOf(exception)), (Throwable)exception);
                        }
                    } else {
                        m_Log.error((Object)("No DataSource " + objectArray.getDataSource() + " defined in report"));
                    }
                } else if (propertyHolder instanceof Map) {
                    // empty if block
                }
            }
            objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            return objectArray;
        }
    }

    private static class MeterDisplayStylePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"Pie", "Circle", "Chord"};
        private static final String[] KEYS = new String[]{"Meter.Pie", "Meter.Circle", "Meter.Chord"};

        public MeterDisplayStylePropertyType() {
            super("Choice.MeterDisplayStyle", IDS, I18N.ERD, KEYS);
        }
    }

    private static class DataRangePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"All", "Group", "Record"};
        private static final String[] KEYS = new String[]{"DataRange.All", "DataRange.Group", "DataRange.Record"};

        public DataRangePropertyType() {
            super("Choice.DataRange", IDS, I18N.ERD, KEYS);
        }
    }

    private static class WidthOverridePropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"BestFit", "Fixed", "Maximum", "Minimum"};
        private static final String[] KEYS = new String[]{"WidthOverride.BestFit", "WidthOverride.Fixed", "WidthOverride.Maximum", "WidthOverride.Minimum"};

        public WidthOverridePropertyType() {
            super("Choice.WidthOverride", IDS, I18N.ERD, KEYS);
        }
    }

    private static class URLTargetPropertyType
    extends ChoicePropertyType {
        public URLTargetPropertyType() {
            super("Choice.URLTarget");
        }

        @Override
        public Object[] getChoices(List<? extends PropertyHolder> list) {
            return new String[]{"", "_blank", "_parent", "_self", "_top"};
        }

        @Override
        public boolean isEditable() {
            return true;
        }
    }

    private static class GraphLayoutPropertyType
    extends I18NChoicePropertyType {
        private static final String[] IDS = new String[]{"fast-organic", "hierarchical"};
        private static final String[] KEYS = new String[]{"GraphLayout.FastOrganic", "GraphLayout.Hierarchical"};

        public GraphLayoutPropertyType() {
            super("Choice.GraphLayout", IDS, I18N.ERD, KEYS);
        }
    }
}

