/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.RTFChunk;
import com.elixirtech.rtf.RTFLine;
import com.elixirtech.rtf.RTFRect;
import com.elixirtech.rtf.RTFWriter;
import java.awt.Color;
import java.io.IOException;

public class RTFCellRect
extends RTFChunk {
    private String m_LineStyle;
    private int m_LineWidth;
    private Color m_LineColor;
    private Color m_FillColor;
    private int m_X;
    private int m_Y;
    private int m_Width;
    private int m_Height;
    private int m_Sides;

    public void setLineStyle(String string) {
        this.m_LineStyle = string;
    }

    public void setLineColor(Color color) {
        this.m_LineColor = color;
    }

    public void setFillColor(Color color) {
        this.m_FillColor = color;
    }

    public void setLineWidth(int n) {
        this.m_LineWidth = n;
    }

    public void setSides(int n) {
        this.m_Sides = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_X = n;
        this.m_Y = n2;
        this.m_Width = n3;
        this.m_Height = n4;
    }

    @Override
    public void write(RTFWriter rTFWriter) throws IOException {
        RTFChunk rTFChunk;
        if (this.m_FillColor != null) {
            rTFChunk = new RTFRect();
            ((RTFRect)rTFChunk).setBounds(this.m_X, this.m_Y, this.m_Width, this.m_Height);
            ((RTFRect)rTFChunk).setFillColor(this.m_FillColor);
            ((RTFRect)rTFChunk).write(rTFWriter);
        }
        if (this.m_LineColor != null && this.m_Sides != 0) {
            rTFChunk = new RTFLine();
            ((RTFLine)rTFChunk).setLineColor(this.m_LineColor);
            ((RTFLine)rTFChunk).setLineStyle(this.m_LineStyle);
            ((RTFLine)rTFChunk).setLineWidth(this.m_LineWidth);
            int n = this.m_LineWidth / 2;
            if ((this.m_Sides & 2) != 0) {
                ((RTFLine)rTFChunk).setEnds(this.m_X - n, this.m_Y, this.m_X + this.m_Width + n, this.m_Y);
                ((RTFLine)rTFChunk).write(rTFWriter);
            }
            if ((this.m_Sides & 4) != 0) {
                ((RTFLine)rTFChunk).setEnds(this.m_X + this.m_Width, this.m_Y - n, this.m_X + this.m_Width, this.m_Y + this.m_Height + n);
                ((RTFLine)rTFChunk).write(rTFWriter);
            }
            if ((this.m_Sides & 8) != 0) {
                ((RTFLine)rTFChunk).setEnds(this.m_X + this.m_Width + n, this.m_Y + this.m_Height, this.m_X - n, this.m_Y + this.m_Height);
                ((RTFLine)rTFChunk).write(rTFWriter);
            }
            if ((this.m_Sides & 1) != 0) {
                ((RTFLine)rTFChunk).setEnds(this.m_X, this.m_Y + this.m_Height + n, this.m_X, this.m_Y - n);
                ((RTFLine)rTFChunk).write(rTFWriter);
            }
        }
    }
}

