/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.RTFChunk;
import com.elixirtech.rtf.RTFWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TextBlock
extends RTFChunk {
    private List<String> m_Lines = new ArrayList<String>();
    private int m_FontId;
    private int m_FontStyle;
    private int m_FontSize;
    private int m_FontColor;
    private int m_X;
    private int m_Y;
    private int m_Width;
    private int m_Height;

    public void setFont(int n, int n2, int n3) {
        this.m_FontId = n;
        this.m_FontStyle = n2;
        this.m_FontSize = n3;
    }

    public void setFontColor(int n) {
        this.m_FontColor = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_X = n;
        this.m_Y = n2;
        this.m_Width = n3;
        this.m_Height = n4;
    }

    public void setAlignment() {
    }

    public void addLine(String string) {
        this.m_Lines.add(string);
    }

    @Override
    public void write(RTFWriter rTFWriter) throws IOException {
        rTFWriter.push();
        rTFWriter.command("pard");
        rTFWriter.command("pvpg");
        rTFWriter.command("phpg");
        rTFWriter.command("posx" + this.m_X);
        rTFWriter.command("posy" + this.m_Y);
        rTFWriter.command("absw" + this.m_Width);
        rTFWriter.command("absh-" + this.m_Height);
        rTFWriter.command("f" + this.m_FontId);
        rTFWriter.command("fs" + this.m_FontSize * 2);
        if ((this.m_FontStyle & 1) != 0) {
            rTFWriter.command("b");
        }
        if ((this.m_FontStyle & 2) != 0) {
            rTFWriter.command("i");
        }
        rTFWriter.command("cf" + this.m_FontColor);
        for (String string : this.m_Lines) {
            rTFWriter.text(string);
            rTFWriter.command("line");
        }
        rTFWriter.command("par");
        rTFWriter.pop();
    }
}

