/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.sax.delegates;

import com.elixirtech.arch.ByteUtil;
import com.elixirtech.sax.BasicSAXDelegate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EncryptedSAX
extends BasicSAXDelegate {
    private final BasicSAXDelegate m_Next;
    private StringBuffer m_StringBuffer = new StringBuffer();
    private boolean m_IsEncrypted;

    public EncryptedSAX(BasicSAXDelegate basicSAXDelegate) {
        this.m_Next = basicSAXDelegate;
    }

    @Override
    public Object getObject() {
        return this.m_Next.getObject();
    }

    @Override
    protected void doStart(String string, Attributes attributes) {
        if ("encrypted".equals(string)) {
            this.m_IsEncrypted = true;
        } else {
            this.m_Delegate = this.m_Next;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_IsEncrypted) {
            this.m_StringBuffer.append(new String(cArray, n, n2));
        } else {
            super.characters(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (this.m_IsEncrypted) {
            String string4 = this.m_StringBuffer.toString();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ByteUtil.decodeBase64(string4));
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse((InputStream)gZIPInputStream, (DefaultHandler)this.m_Next);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't decrypt data: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
    }
}

