/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.scm;

import com.elixirtech.scm.SchemeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputPort
extends SchemeUtils {
    static String EOF = "#!EOF";
    boolean isPushedToken = false;
    boolean isPushedChar = false;
    Object pushedToken = null;
    int pushedChar = -1;
    Reader in;
    StringBuffer buff = new StringBuffer();

    public InputPort(InputStream inputStream) throws UnsupportedEncodingException {
        this.in = new InputStreamReader(inputStream, "UTF-8");
    }

    public InputPort(Reader reader) {
        this.in = reader;
    }

    public Object readChar() {
        try {
            if (this.isPushedChar) {
                this.isPushedChar = false;
                if (this.pushedChar == -1) {
                    return EOF;
                }
                return InputPort.chr((char)this.pushedChar);
            }
            int n = this.in.read();
            if (n == -1) {
                return EOF;
            }
            return InputPort.chr((char)n);
        }
        catch (IOException iOException) {
            InputPort.warn("On input, exception: " + String.valueOf(iOException));
            return EOF;
        }
    }

    public Object peekChar() {
        int n = this.peekCh();
        if (n == -1) {
            return EOF;
        }
        return InputPort.chr((char)n);
    }

    int pushChar(int n) {
        this.isPushedChar = true;
        this.pushedChar = n;
        return this.pushedChar;
    }

    int popChar() {
        this.isPushedChar = false;
        return this.pushedChar;
    }

    public int peekCh() {
        try {
            return this.isPushedChar ? this.pushedChar : this.pushChar(this.in.read());
        }
        catch (IOException iOException) {
            InputPort.warn("On input, exception: " + String.valueOf(iOException));
            return -1;
        }
    }

    public Object read() {
        try {
            Object object = this.nextToken();
            if (object == "(") {
                return this.readTail(false);
            }
            if (object == ")") {
                InputPort.warn("Extra ) ignored.");
                return this.read();
            }
            if (object == ".") {
                InputPort.warn("Extra . ignored.");
                return this.read();
            }
            if (object == "'") {
                return InputPort.list("quote", this.read());
            }
            if (object == "`") {
                return InputPort.list("quasiquote", this.read());
            }
            if (object == ",") {
                return InputPort.list("unquote", this.read());
            }
            if (object == ",@") {
                return InputPort.list("unquote-splicing", this.read());
            }
            return object;
        }
        catch (IOException iOException) {
            InputPort.warn("On input, exception: " + String.valueOf(iOException));
            return EOF;
        }
    }

    public Object close() {
        try {
            this.in.close();
            return TRUE;
        }
        catch (IOException iOException) {
            return InputPort.error("IOException: " + String.valueOf(iOException));
        }
    }

    public static boolean isEOF(Object object) {
        return object == EOF;
    }

    Object readTail(boolean bl) throws IOException {
        Object object = this.nextToken();
        if (object == EOF) {
            return InputPort.error("EOF during read.");
        }
        if (object == ")") {
            return null;
        }
        if (object == ".") {
            Object object2 = this.read();
            object = this.nextToken();
            if (object != ")") {
                InputPort.warn("Where's the ')'? Got " + String.valueOf(object) + " after .");
            }
            return object2;
        }
        this.isPushedToken = true;
        this.pushedToken = object;
        return InputPort.cons(this.read(), this.readTail(true));
    }

    Object nextToken() throws IOException {
        if (this.isPushedToken) {
            this.isPushedToken = false;
            return this.pushedToken;
        }
        int n = this.isPushedChar ? this.popChar() : this.in.read();
        while (Character.isWhitespace((char)n)) {
            n = this.in.read();
        }
        switch (n) {
            case -1: {
                return EOF;
            }
            case 40: {
                return "(";
            }
            case 41: {
                return ")";
            }
            case 39: {
                return "'";
            }
            case 96: {
                return "`";
            }
            case 44: {
                n = this.in.read();
                if (n == 64) {
                    return ",@";
                }
                this.pushChar(n);
                return ",";
            }
            case 59: {
                while (n != -1 && n != 10 && n != 13) {
                    n = this.in.read();
                }
                return this.nextToken();
            }
            case 34: {
                this.buff.setLength(0);
                while ((n = this.in.read()) != 34 && n != -1) {
                    this.buff.append((char)(n == 92 ? this.in.read() : n));
                }
                if (n == -1) {
                    InputPort.warn("EOF inside of a string.");
                }
                return this.buff.toString().toCharArray();
            }
            case 35: {
                n = this.in.read();
                switch (n) {
                    case 84: 
                    case 116: {
                        return TRUE;
                    }
                    case 70: 
                    case 102: {
                        return FALSE;
                    }
                    case 40: {
                        this.pushChar(40);
                        return InputPort.listToVector(this.read());
                    }
                    case 92: {
                        n = this.in.read();
                        if (n == 115 || n == 83 || n == 110 || n == 78) {
                            this.pushChar(n);
                            Object object = this.nextToken();
                            if (object == "space") {
                                return InputPort.chr(' ');
                            }
                            if (object == "newline") {
                                return InputPort.chr('\n');
                            }
                            this.isPushedToken = true;
                            this.pushedToken = object;
                            return InputPort.chr((char)n);
                        }
                        return InputPort.chr((char)n);
                    }
                    case 100: 
                    case 101: 
                    case 105: {
                        return this.nextToken();
                    }
                    case 98: 
                    case 111: 
                    case 120: {
                        InputPort.warn("#" + (char)n + " not implemented, ignored.");
                        return this.nextToken();
                    }
                }
                InputPort.warn("#" + (char)n + " not recognized, ignored.");
                return this.nextToken();
            }
        }
        this.buff.setLength(0);
        int n2 = n;
        do {
            this.buff.append((char)n);
        } while (!Character.isWhitespace((char)(n = this.in.read())) && n != -1 && n != 40 && n != 41 && n != 39 && n != 59 && n != 34 && n != 44 && n != 96);
        this.pushChar(n);
        if (n2 == 46 || n2 == 43 || n2 == 45 || n2 >= 48 && n2 <= 57) {
            try {
                return new Double(this.buff.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.buff.toString().toLowerCase().intern();
    }
}

