/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.svg;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.svg.BufferedImageTranscoder;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGToImage {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SVGToImage.class);

    public static void toJpeg(SVGDocument sVGDocument) throws Exception {
        TranscoderInput transcoderInput = new TranscoderInput((Document)sVGDocument);
        JPEGTranscoder jPEGTranscoder = new JPEGTranscoder();
        jPEGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)Float.valueOf(0.8f));
        FileOutputStream fileOutputStream = new FileOutputStream("/home/jon/Downloads/Batik/test.jpg");
        TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)fileOutputStream);
        jPEGTranscoder.transcode(transcoderInput, transcoderOutput);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static BufferedImage convert(SVGDocument sVGDocument, Dimension dimension) {
        m_Log.info((Object)("convert to svg (" + dimension.width + "," + dimension.height + ")"));
        TranscoderInput transcoderInput = new TranscoderInput((Document)sVGDocument);
        BufferedImageTranscoder bufferedImageTranscoder = new BufferedImageTranscoder();
        try {
            bufferedImageTranscoder.addTranscodingHint(BufferedImageTranscoder.KEY_WIDTH, Float.valueOf(dimension.width));
            bufferedImageTranscoder.addTranscodingHint(BufferedImageTranscoder.KEY_HEIGHT, Float.valueOf(dimension.height));
            bufferedImageTranscoder.transcode(transcoderInput, null);
            return bufferedImageTranscoder.getImage();
        }
        catch (TranscoderException transcoderException) {
            m_Log.error((Object)("Error in transcoder: " + String.valueOf((Object)transcoderException)), (Throwable)transcoderException);
            return null;
        }
    }

    private static RenderingHints getRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(null);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        return renderingHints;
    }
}

