/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.tree;

import com.elixirtech.tree.TModel;
import com.elixirtech.tree.TNode;
import com.elixirtech.tree.TParent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TLeaf
implements TNode {
    protected TParent m_Parent;
    protected String m_Name;
    protected Icon m_Icon;

    public TLeaf(TParent tParent, String string, Icon icon) {
        this.m_Parent = tParent;
        this.m_Name = string;
        this.m_Icon = icon;
        if (this.m_Parent != null) {
            this.m_Parent.addChild(this);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getRenderableName() {
        return this.getName();
    }

    public Icon getRenderableIcon() {
        return this.m_Icon;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public Icon getIcon(boolean bl) {
        return null;
    }

    @Override
    public TreePath getTreePath() {
        ArrayList<TNode> arrayList = new ArrayList<TNode>();
        arrayList.add(this);
        for (TNode tNode = this.getParent(); tNode != null; tNode = tNode.getParent()) {
            arrayList.add(0, tNode);
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        return new TreePath(objectArray);
    }

    @Override
    public TModel getTreeModel() {
        return this.m_Parent.getTreeModel();
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return null;
    }

    @Override
    public void doDoubleClick() {
    }

    @Override
    public String getFullName() {
        String string = this.m_Parent.getFullName();
        if (string.length() == 0) {
            return this.m_Name;
        }
        return string + File.separator + this.m_Name;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TNode getChildAt(int n) {
        return null;
    }

    @Override
    public List<TNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndex(TNode tNode) {
        return -1;
    }

    @Override
    public TNode getParent() {
        return this.m_Parent;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public void fireChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TModel tModel = TLeaf.this.getTreeModel();
                if (TLeaf.this.m_Parent == null) {
                    tModel.fireChangedEvent(TLeaf.this.getTreePath());
                } else {
                    tModel.fireChangedEvent(TLeaf.this.m_Parent.getTreePath(), new int[]{TLeaf.this.m_Parent.getIndex(TLeaf.this)}, new Object[]{TLeaf.this});
                }
            }
        });
    }

    public void fireStructureChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TModel tModel = TLeaf.this.getTreeModel();
                tModel.fireStructureChangedEvent(TLeaf.this.getTreePath());
            }
        });
    }

    @Override
    public void sortChildren(Comparator<TNode> comparator) {
    }
}

