/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.tree;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.tree.ITreeManipulation;
import com.elixirtech.tree.TreeDropTarget;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import javax.swing.JTree;

public class TreeDropTargetEx<T>
extends TreeDropTarget {
    private ITreeManipulation<T> m_Manipulation;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TreeDropTargetEx.class);

    public TreeDropTargetEx(JTree jTree, ITreeManipulation<T> iTreeManipulation) {
        super(jTree);
        this.m_Manipulation = iTreeManipulation;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        if (n >= 0 && dropTargetDragEvent.isDataFlavorSupported(this.m_Manipulation.getPreferredFlavor())) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        block7: {
            if (dropTargetDragEvent.isDataFlavorSupported(this.m_Manipulation.getPreferredFlavor())) {
                super.dragOver(dropTargetDragEvent);
                Point point = this.getMostRecentDragLocation();
                int n = this.m_Tree.getRowForPath(this.m_Tree.getClosestPathForLocation(point.x, point.y));
                int n2 = this.getMostRecentInsert();
                if (n == 0 && n2 != 2) {
                    dropTargetDragEvent.rejectDrag();
                } else {
                    try {
                        T t = this.m_Manipulation.get(dropTargetDragEvent.getTransferable());
                        T t2 = this.m_Manipulation.get(n);
                        int n3 = dropTargetDragEvent.getDropAction();
                        if (this.m_Manipulation.isAllowed(t, t2, n3, n2)) {
                            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                            break block7;
                        }
                        dropTargetDragEvent.rejectDrag();
                    }
                    catch (Exception exception) {
                        dropTargetDragEvent.rejectDrag();
                    }
                }
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        super.drop(dropTargetDropEvent);
        Point point = this.getMostRecentDragLocation();
        int n = this.m_Tree.getRowForPath(this.m_Tree.getClosestPathForLocation(point.x, point.y));
        int n2 = this.getMostRecentInsert();
        if (dropTargetDropEvent.isDataFlavorSupported(this.m_Manipulation.getPreferredFlavor())) {
            try {
                T t = this.m_Manipulation.get(dropTargetDropEvent.getTransferable());
                T t2 = this.m_Manipulation.get(n);
                int n3 = dropTargetDropEvent.getDropAction();
                if (this.m_Manipulation.isAllowed(t, t2, n3, n2)) {
                    if (n3 == 1) {
                        t = this.m_Manipulation.createCopy(t);
                    } else if (n3 == 2) {
                        this.m_Manipulation.disconnect(t);
                    }
                    this.m_Manipulation.add(t, t2, n2);
                    dropTargetDropEvent.acceptDrop(n3);
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception exception) {
                m_Log.warn((Object)("drop failed: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
        dropTargetDropEvent.rejectDrop();
        dropTargetDropEvent.dropComplete(false);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }
}

