/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

import java.util.ArrayList;
import java.util.List;

public class IntRange {
    private List<IRange> m_Ranges = new ArrayList<IRange>();

    public IntRange() {
    }

    public IntRange(String string) {
        string = string.trim();
        if (string.length() > 0) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                int n = stringArray[i].indexOf("-");
                if (n >= 0) {
                    if (n == 0) {
                        stringArray[i] = stringArray[i].substring(1).trim();
                        this.addLTE(Integer.parseInt(stringArray[i]));
                        continue;
                    }
                    if (n == stringArray[i].length() - 1) {
                        stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 1).trim();
                        this.addGTE(Integer.parseInt(stringArray[i]));
                        continue;
                    }
                    int n2 = stringArray[i].indexOf(45);
                    int n3 = Integer.parseInt(stringArray[i].substring(0, n2).trim());
                    int n4 = Integer.parseInt(stringArray[i].substring(n2 + 1).trim());
                    this.addRange(n3, n4);
                    continue;
                }
                this.add(Integer.parseInt(stringArray[i]));
            }
        }
    }

    public boolean contains(int n) {
        for (IRange iRange : this.m_Ranges) {
            if (!iRange.contains(n)) continue;
            return true;
        }
        return false;
    }

    public void add(int n) {
        this.m_Ranges.add(new Value(n));
    }

    public void addGTE(int n) {
        this.m_Ranges.add(new GTE(n));
    }

    public void addLTE(int n) {
        this.m_Ranges.add(new LTE(n));
    }

    public void addRange(int n, int n2) {
        this.m_Ranges.add(new Range(n, n2));
    }

    private static interface IRange {
        public boolean contains(int var1);
    }

    private static class Value
    implements IRange {
        private final int m_Value;

        public Value(int n) {
            this.m_Value = n;
        }

        @Override
        public boolean contains(int n) {
            return n == this.m_Value;
        }
    }

    private static class GTE
    implements IRange {
        private final int m_Value;

        public GTE(int n) {
            this.m_Value = n;
        }

        @Override
        public boolean contains(int n) {
            return n >= this.m_Value;
        }
    }

    private static class LTE
    implements IRange {
        private final int m_Value;

        public LTE(int n) {
            this.m_Value = n;
        }

        @Override
        public boolean contains(int n) {
            return n <= this.m_Value;
        }
    }

    private static class Range
    implements IRange {
        private final int m_Min;
        private final int m_Max;

        public Range(int n, int n2) {
            this.m_Min = n;
            this.m_Max = n2;
        }

        @Override
        public boolean contains(int n) {
            return n >= this.m_Min && n <= this.m_Max;
        }
    }
}

