/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util.glyph;

import com.elixirtech.util.glyph.CRGlyph;
import com.elixirtech.util.glyph.CharGlyph;
import com.elixirtech.util.glyph.ColorGlyph;
import com.elixirtech.util.glyph.ColumnBreakGlyph;
import com.elixirtech.util.glyph.EndGlyph;
import com.elixirtech.util.glyph.FontGlyph;
import com.elixirtech.util.glyph.Glyph;
import com.elixirtech.util.glyph.GlyphVisitor;
import com.elixirtech.util.glyph.HardCRGlyph;
import com.elixirtech.util.glyph.PageBreakGlyph;
import com.elixirtech.util.glyph.SelectOffGlyph;
import com.elixirtech.util.glyph.SelectOnGlyph;
import com.elixirtech.util.glyph.SoftCRGlyph;
import com.elixirtech.util.glyph.SoftEndGlyph;
import com.elixirtech.util.glyph.SpaceGlyph;

public class GlyphWrapper
implements GlyphVisitor {
    int m_Width;
    int m_CurrentX;
    Glyph m_LastSpace;

    public GlyphWrapper(int n) {
        this.m_Width = n;
    }

    @Override
    public boolean visitCharGlyph(CharGlyph charGlyph) {
        assert (false);
        int n = charGlyph.getDimension().width;
        if (this.m_CurrentX + n < this.m_Width) {
            this.m_CurrentX += n;
        } else if (this.m_LastSpace == null) {
            SoftCRGlyph softCRGlyph = new SoftCRGlyph();
            softCRGlyph.addBefore(charGlyph);
            this.m_CurrentX = n;
        } else {
            SoftCRGlyph softCRGlyph = new SoftCRGlyph();
            softCRGlyph.addAfter(this.m_LastSpace);
            this.m_CurrentX = 0;
            Glyph glyph = softCRGlyph;
            while (glyph != charGlyph) {
                this.m_CurrentX += glyph.getDimension().width;
                glyph = glyph.m_Next;
            }
            this.m_CurrentX += n;
            this.m_LastSpace = null;
        }
        return true;
    }

    @Override
    public boolean visitSpaceGlyph(SpaceGlyph spaceGlyph) {
        this.m_LastSpace = spaceGlyph;
        int n = spaceGlyph.getDimension().width;
        if (this.m_CurrentX + n < this.m_Width) {
            this.m_CurrentX += n;
        } else {
            SoftCRGlyph softCRGlyph = new SoftCRGlyph();
            softCRGlyph.addAfter(spaceGlyph);
            this.m_CurrentX = 0;
        }
        return true;
    }

    @Override
    public boolean visitColorGlyph(ColorGlyph colorGlyph) {
        return true;
    }

    @Override
    public boolean visitCRGlyph(CRGlyph cRGlyph) {
        this.m_LastSpace = null;
        this.m_CurrentX = 0;
        return true;
    }

    @Override
    public boolean visitHardCRGlyph(HardCRGlyph hardCRGlyph) {
        this.m_LastSpace = null;
        this.m_CurrentX = 0;
        return true;
    }

    @Override
    public boolean visitFontGlyph(FontGlyph fontGlyph) {
        return true;
    }

    @Override
    public boolean visitSelectOnGlyph(SelectOnGlyph selectOnGlyph) {
        return true;
    }

    @Override
    public boolean visitSelectOffGlyph(SelectOffGlyph selectOffGlyph) {
        return true;
    }

    @Override
    public boolean visitEndGlyph(EndGlyph endGlyph) {
        return true;
    }

    @Override
    public boolean visitSoftEndGlyph(SoftEndGlyph softEndGlyph) {
        return true;
    }

    @Override
    public boolean visitPageBreakGlyph(PageBreakGlyph pageBreakGlyph) {
        return true;
    }

    @Override
    public boolean visitColumnBreakGlyph(ColumnBreakGlyph columnBreakGlyph) {
        return true;
    }

    public void setWidth(int n) {
        this.m_Width = n;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public int getCurrentWidth() {
        return this.m_Width;
    }

    public void setCurrentWidth(int n) {
        this.m_Width = n;
    }
}

