/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Image;
import com.lowagie.text.LargeElement;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTableEvent;
import com.lowagie.text.pdf.events.PdfPTableEventForwarder;
import java.util.ArrayList;

public class PdfPTable
implements LargeElement {
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    protected ArrayList rows = new ArrayList();
    protected float totalHeight = 0.0f;
    protected PdfPCell[] currentRow;
    protected int currentRowIdx = 0;
    protected PdfPCell defaultCell = new PdfPCell((Phrase)null);
    protected float totalWidth = 0.0f;
    protected float[] relativeWidths;
    protected float[] absoluteWidths;
    protected PdfPTableEvent tableEvent;
    protected int headerRows;
    protected float widthPercentage = 80.0f;
    private int horizontalAlignment = 1;
    private boolean skipFirstHeader = false;
    private boolean skipLastFooter = false;
    protected boolean isColspan = false;
    protected int runDirection = 0;
    private boolean lockedWidth = false;
    private boolean splitRows = true;
    protected float spacingBefore;
    protected float spacingAfter;
    private boolean extendLastRow;
    private boolean headersInEvent;
    private boolean splitLate = true;
    private boolean keepTogether;
    protected boolean complete = true;
    private int footerRows;
    protected boolean rowCompleted = true;

    protected PdfPTable() {
    }

    public PdfPTable(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("The widths array in PdfPTable constructor can not be null.");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("The widths array in PdfPTable constructor can not have zero length.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.keepTogether = false;
    }

    public PdfPTable(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of columns in PdfPTable constructor must be greater than zero.");
        }
        this.relativeWidths = new float[n];
        for (int i = 0; i < n; ++i) {
            this.relativeWidths[i] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.keepTogether = false;
    }

    public PdfPTable(PdfPTable pdfPTable) {
        int n;
        this.copyFormat(pdfPTable);
        for (n = 0; n < this.currentRow.length && pdfPTable.currentRow[n] != null; ++n) {
            this.currentRow[n] = new PdfPCell(pdfPTable.currentRow[n]);
        }
        for (n = 0; n < pdfPTable.rows.size(); ++n) {
            PdfPRow pdfPRow = (PdfPRow)pdfPTable.rows.get(n);
            if (pdfPRow != null) {
                pdfPRow = new PdfPRow(pdfPRow);
            }
            this.rows.add(pdfPRow);
        }
    }

    public static PdfPTable shallowCopy(PdfPTable pdfPTable) {
        PdfPTable pdfPTable2 = new PdfPTable();
        pdfPTable2.copyFormat(pdfPTable);
        return pdfPTable2;
    }

    protected void copyFormat(PdfPTable pdfPTable) {
        this.relativeWidths = new float[pdfPTable.getNumberOfColumns()];
        this.absoluteWidths = new float[pdfPTable.getNumberOfColumns()];
        System.arraycopy(pdfPTable.relativeWidths, 0, this.relativeWidths, 0, this.getNumberOfColumns());
        System.arraycopy(pdfPTable.absoluteWidths, 0, this.absoluteWidths, 0, this.getNumberOfColumns());
        this.totalWidth = pdfPTable.totalWidth;
        this.totalHeight = pdfPTable.totalHeight;
        this.currentRowIdx = 0;
        this.tableEvent = pdfPTable.tableEvent;
        this.runDirection = pdfPTable.runDirection;
        this.defaultCell = new PdfPCell(pdfPTable.defaultCell);
        this.currentRow = new PdfPCell[pdfPTable.currentRow.length];
        this.isColspan = pdfPTable.isColspan;
        this.splitRows = pdfPTable.splitRows;
        this.spacingAfter = pdfPTable.spacingAfter;
        this.spacingBefore = pdfPTable.spacingBefore;
        this.headerRows = pdfPTable.headerRows;
        this.footerRows = pdfPTable.footerRows;
        this.lockedWidth = pdfPTable.lockedWidth;
        this.extendLastRow = pdfPTable.extendLastRow;
        this.headersInEvent = pdfPTable.headersInEvent;
        this.widthPercentage = pdfPTable.widthPercentage;
        this.splitLate = pdfPTable.splitLate;
        this.skipFirstHeader = pdfPTable.skipFirstHeader;
        this.skipLastFooter = pdfPTable.skipLastFooter;
        this.horizontalAlignment = pdfPTable.horizontalAlignment;
        this.keepTogether = pdfPTable.keepTogether;
        this.complete = pdfPTable.complete;
    }

    public void setWidths(float[] fArray) throws DocumentException {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights(true);
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        this.setWidths(fArray);
    }

    protected void calculateWidths() {
        int n;
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float f = 0.0f;
        int n2 = this.getNumberOfColumns();
        for (n = 0; n < n2; ++n) {
            f += this.relativeWidths[n];
        }
        for (n = 0; n < n2; ++n) {
            this.absoluteWidths[n] = this.totalWidth * this.relativeWidths[n] / f;
        }
    }

    public void setTotalWidth(float f) {
        if (this.totalWidth == f) {
            return;
        }
        this.totalWidth = f;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights(true);
    }

    public void setTotalWidth(float[] fArray) throws DocumentException {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.totalWidth = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            this.totalWidth += fArray[i];
        }
        this.setWidths(fArray);
    }

    public void setWidthPercentage(float[] fArray, Rectangle rectangle) throws DocumentException {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new IllegalArgumentException("Wrong number of columns.");
        }
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        this.widthPercentage = f / (rectangle.getRight() - rectangle.getLeft()) * 100.0f;
        this.setWidths(fArray);
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    public float calculateHeights(boolean bl) {
        if (this.totalWidth <= 0.0f) {
            return 0.0f;
        }
        this.totalHeight = 0.0f;
        for (int i = 0; i < this.rows.size(); ++i) {
            this.totalHeight += this.getRowHeight(i, bl);
        }
        return this.totalHeight;
    }

    public void calculateHeightsFast() {
        this.calculateHeights(false);
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public void addCell(PdfPCell pdfPCell) {
        int n;
        this.rowCompleted = false;
        PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
        int n2 = pdfPCell2.getColspan();
        n2 = Math.max(n2, 1);
        n2 = Math.min(n2, this.currentRow.length - this.currentRowIdx);
        pdfPCell2.setColspan(n2);
        if (n2 != 1) {
            this.isColspan = true;
        }
        if ((n = pdfPCell2.getRunDirection()) == 0) {
            pdfPCell2.setRunDirection(this.runDirection);
        }
        this.skipColsWithRowspanAbove();
        boolean bl = false;
        if (this.currentRowIdx < this.currentRow.length) {
            this.currentRow[this.currentRowIdx] = pdfPCell2;
            this.currentRowIdx += n2;
            bl = true;
        }
        this.skipColsWithRowspanAbove();
        if (this.currentRowIdx >= this.currentRow.length) {
            Object object;
            int n3 = this.getNumberOfColumns();
            if (this.runDirection == 3) {
                object = new PdfPCell[n3];
                int n4 = this.currentRow.length;
                for (int i = 0; i < this.currentRow.length; ++i) {
                    PdfPCell pdfPCell3 = this.currentRow[i];
                    int n5 = pdfPCell3.getColspan();
                    object[n4 -= n5] = pdfPCell3;
                    i += n5 - 1;
                }
                this.currentRow = object;
            }
            object = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                ((PdfPRow)object).setWidths(this.absoluteWidths);
                this.totalHeight += ((PdfPRow)object).getMaxHeights();
            }
            this.rows.add(object);
            this.currentRow = new PdfPCell[n3];
            this.currentRowIdx = 0;
            this.rowCompleted = true;
        }
        if (!bl) {
            this.currentRow[this.currentRowIdx] = pdfPCell2;
            this.currentRowIdx += n2;
        }
    }

    private void skipColsWithRowspanAbove() {
        int n = 1;
        if (this.runDirection == 3) {
            n = -1;
        }
        while (this.rowSpanAbove(this.rows.size(), this.currentRowIdx)) {
            this.currentRowIdx += n;
        }
    }

    boolean rowSpanAbove(int n, int n2) {
        if (n2 >= this.getNumberOfColumns() || n2 < 0 || n == 0) {
            return false;
        }
        int n3 = n - 1;
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n3);
        if (pdfPRow == null) {
            return false;
        }
        PdfPCell pdfPCell = pdfPRow.getCells()[n2];
        while (pdfPCell == null && n3 > 0) {
            if ((pdfPRow = (PdfPRow)this.rows.get(--n3)) == null) {
                return false;
            }
            pdfPCell = pdfPRow.getCells()[n2];
        }
        int n4 = n - n3;
        if (pdfPCell == null) {
            int n5 = n2 - 1;
            pdfPCell = pdfPRow.getCells()[n5];
            while (pdfPCell == null && n3 > 0) {
                pdfPCell = pdfPRow.getCells()[--n5];
            }
            return pdfPCell != null && pdfPCell.getRowspan() > n4;
        }
        if (pdfPCell.getRowspan() == 1 && n4 > 1) {
            int n6 = n2 - 1;
            pdfPRow = (PdfPRow)this.rows.get(n3 + 1);
            --n4;
            pdfPCell = pdfPRow.getCells()[n6];
            while (pdfPCell == null && n6 > 0) {
                pdfPCell = pdfPRow.getCells()[--n6];
            }
        }
        return pdfPCell != null && pdfPCell.getRowspan() > n4;
    }

    public void addCell(String string) {
        this.addCell(new Phrase(string));
    }

    public void addCell(PdfPTable pdfPTable) {
        this.defaultCell.setTable(pdfPTable);
        this.addCell(this.defaultCell);
        this.defaultCell.setTable(null);
    }

    public void addCell(Image image) {
        this.defaultCell.setImage(image);
        this.addCell(this.defaultCell);
        this.defaultCell.setImage(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        this.addCell(this.defaultCell);
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int n, int n2, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        return this.writeSelectedRows(0, -1, n, n2, f, f2, pdfContentByteArray);
    }

    public float writeSelectedRows(int n, int n2, int n3, int n4, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException("The table width must be greater than zero.");
        }
        int n5 = this.rows.size();
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= (n4 = n4 < 0 ? n5 : Math.min(n4, n5))) {
            return f2;
        }
        int n6 = this.getNumberOfColumns();
        n = n < 0 ? 0 : Math.min(n, n6);
        n2 = n2 < 0 ? n6 : Math.min(n2, n6);
        float f3 = f2;
        for (int i = n3; i < n4; ++i) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
            if (pdfPRow == null) continue;
            pdfPRow.writeCells(n, n2, f, f2, pdfContentByteArray);
            f2 -= pdfPRow.getMaxHeights();
        }
        if (this.tableEvent != null && n == 0 && n2 == n6) {
            float[] fArray = new float[n4 - n3 + 1];
            fArray[0] = f3;
            for (int i = n3; i < n4; ++i) {
                PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
                float f4 = 0.0f;
                if (pdfPRow != null) {
                    f4 = pdfPRow.getMaxHeights();
                }
                fArray[i - n3 + 1] = fArray[i - n3] - f4;
            }
            this.tableEvent.tableLayout(this, this.getEventWidths(f, n3, n4, this.headersInEvent), fArray, this.headersInEvent ? this.headerRows : 0, n3, pdfContentByteArray);
        }
        return f2;
    }

    public float writeSelectedRows(int n, int n2, float f, float f2, PdfContentByte pdfContentByte) {
        return this.writeSelectedRows(0, -1, n, n2, f, f2, pdfContentByte);
    }

    public float writeSelectedRows(int n, int n2, int n3, int n4, float f, float f2, PdfContentByte pdfContentByte) {
        float f3;
        boolean bl;
        int n5 = this.getNumberOfColumns();
        n = n < 0 ? 0 : Math.min(n, n5);
        n2 = n2 < 0 ? n5 : Math.min(n2, n5);
        boolean bl2 = bl = n != 0 || n2 != n5;
        if (bl) {
            float f4 = 0.0f;
            for (int i = n; i < n2; ++i) {
                f4 += this.absoluteWidths[i];
            }
            pdfContentByte.saveState();
            f3 = n == 0 ? 10000.0f : 0.0f;
            float f5 = n2 == n5 ? 10000.0f : 0.0f;
            pdfContentByte.rectangle(f - f3, -10000.0f, f4 + f3 + f5, 20000.0f);
            pdfContentByte.clip();
            pdfContentByte.newPath();
        }
        PdfContentByte[] pdfContentByteArray = PdfPTable.beginWritingRows(pdfContentByte);
        f3 = this.writeSelectedRows(n, n2, n3, n4, f, f2, pdfContentByteArray);
        PdfPTable.endWritingRows(pdfContentByteArray);
        if (bl) {
            pdfContentByte.restoreState();
        }
        return f3;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte pdfContentByte) {
        return new PdfContentByte[]{pdfContentByte, pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[0];
        pdfContentByte.saveState();
        pdfContentByte.add(pdfContentByteArray[1]);
        pdfContentByte.restoreState();
        pdfContentByte.saveState();
        pdfContentByte.setLineCap(2);
        pdfContentByte.resetRGBColorStroke();
        pdfContentByte.add(pdfContentByteArray[2]);
        pdfContentByte.restoreState();
        pdfContentByte.add(pdfContentByteArray[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int n) {
        return this.getRowHeight(n, false);
    }

    public float getRowHeight(int n, boolean bl) {
        if (this.totalWidth <= 0.0f || n < 0 || n >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n);
        if (pdfPRow == null) {
            return 0.0f;
        }
        if (bl) {
            pdfPRow.setWidths(this.absoluteWidths);
        }
        float f = pdfPRow.getMaxHeights();
        for (int i = 0; i < this.relativeWidths.length; ++i) {
            if (!this.rowSpanAbove(n, i)) continue;
            int n2 = 1;
            while (this.rowSpanAbove(n - n2, i)) {
                ++n2;
            }
            PdfPRow pdfPRow2 = (PdfPRow)this.rows.get(n - n2);
            PdfPCell pdfPCell = pdfPRow2.getCells()[i];
            float f2 = 0.0f;
            if (pdfPCell.getRowspan() == n2 + 1) {
                f2 = pdfPCell.getMaxHeight();
                while (n2 > 0) {
                    f2 -= this.getRowHeight(n - n2);
                    --n2;
                }
            }
            if (!(f2 > f)) continue;
            f = f2;
        }
        pdfPRow.setMaxHeights(f);
        return f;
    }

    public float getRowspanHeight(int n, int n2) {
        if (this.totalWidth <= 0.0f || n < 0 || n >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n);
        if (pdfPRow == null || n2 >= pdfPRow.getCells().length) {
            return 0.0f;
        }
        PdfPCell pdfPCell = pdfPRow.getCells()[n2];
        if (pdfPCell == null) {
            return 0.0f;
        }
        float f = 0.0f;
        for (int i = 0; i < pdfPCell.getRowspan(); ++i) {
            f += this.getRowHeight(n + i);
        }
        return f;
    }

    public float getHeaderHeight() {
        float f = 0.0f;
        int n = Math.min(this.rows.size(), this.headerRows);
        for (int i = 0; i < n; ++i) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
            if (pdfPRow == null) continue;
            f += pdfPRow.getMaxHeights();
        }
        return f;
    }

    public float getFooterHeight() {
        float f = 0.0f;
        int n = Math.max(0, this.headerRows - this.footerRows);
        int n2 = Math.min(this.rows.size(), this.headerRows);
        for (int i = n; i < n2; ++i) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
            if (pdfPRow == null) continue;
            f += pdfPRow.getMaxHeights();
        }
        return f;
    }

    public boolean deleteRow(int n) {
        PdfPRow pdfPRow;
        if (n < 0 || n >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f && (pdfPRow = (PdfPRow)this.rows.get(n)) != null) {
            this.totalHeight -= pdfPRow.getMaxHeights();
        }
        this.rows.remove(n);
        if (n < this.headerRows) {
            --this.headerRows;
            if (n >= this.headerRows - this.footerRows) {
                --this.footerRows;
            }
        }
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public void deleteBodyRows() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.headerRows; ++i) {
            arrayList.add(this.rows.get(i));
        }
        this.rows = arrayList;
        this.totalHeight = 0.0f;
        if (this.totalWidth > 0.0f) {
            this.totalHeight = this.getHeaderHeight();
        }
    }

    public int getNumberOfColumns() {
        return this.relativeWidths.length;
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int n) {
        if (n < 0) {
            n = 0;
        }
        this.headerRows = n;
    }

    @Override
    public ArrayList getChunks() {
        return new ArrayList();
    }

    @Override
    public int type() {
        return 23;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f) {
        this.widthPercentage = f;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public PdfPRow getRow(int n) {
        return (PdfPRow)this.rows.get(n);
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public ArrayList getRows(int n, int n2) {
        int n3;
        ArrayList<PdfPRow> arrayList = new ArrayList<PdfPRow>();
        if (n < 0 || n2 > this.size()) {
            return arrayList;
        }
        PdfPRow pdfPRow = this.adjustCellsInRow(n, n2);
        int n4 = 0;
        while (n4 < this.getNumberOfColumns()) {
            n3 = n;
            while (this.rowSpanAbove(n3--, n4)) {
                PdfPCell pdfPCell;
                PdfPRow pdfPRow2 = this.getRow(n3);
                if (pdfPRow2 == null || (pdfPCell = pdfPRow2.getCells()[n4]) == null) continue;
                pdfPRow.getCells()[n4] = new PdfPCell(pdfPCell);
                float f = 0.0f;
                int n5 = Math.min(n3 + pdfPCell.getRowspan(), n2);
                for (int i = n + 1; i < n5; ++i) {
                    f += this.getRowHeight(i);
                }
                pdfPRow.setExtraHeight(n4, f);
                float f2 = this.getRowspanHeight(n3, n4) - this.getRowHeight(n) - f;
                pdfPRow.getCells()[n4].consumeHeight(f2);
            }
            PdfPCell pdfPCell = pdfPRow.getCells()[n4];
            if (pdfPCell == null) {
                ++n4;
                continue;
            }
            n4 += pdfPCell.getColspan();
        }
        arrayList.add(pdfPRow);
        for (n3 = n + 1; n3 < n2; ++n3) {
            arrayList.add(this.adjustCellsInRow(n3, n2));
        }
        return arrayList;
    }

    protected PdfPRow adjustCellsInRow(int n, int n2) {
        PdfPRow pdfPRow = new PdfPRow(this.getRow(n));
        pdfPRow.initExtraHeights();
        PdfPCell[] pdfPCellArray = pdfPRow.getCells();
        for (int i = 0; i < pdfPCellArray.length; ++i) {
            PdfPCell pdfPCell = pdfPCellArray[i];
            if (pdfPCell == null || pdfPCell.getRowspan() == 1) continue;
            int n3 = Math.min(n2, n + pdfPCell.getRowspan());
            float f = 0.0f;
            for (int j = n + 1; j < n3; ++j) {
                f += this.getRowHeight(j);
            }
            pdfPRow.setExtraHeight(i, f);
        }
        return pdfPRow;
    }

    public void setTableEvent(PdfPTableEvent pdfPTableEvent) {
        if (pdfPTableEvent == null) {
            this.tableEvent = null;
        } else if (this.tableEvent == null) {
            this.tableEvent = pdfPTableEvent;
        } else if (this.tableEvent instanceof PdfPTableEventForwarder) {
            ((PdfPTableEventForwarder)this.tableEvent).addTableEvent(pdfPTableEvent);
        } else {
            PdfPTableEventForwarder pdfPTableEventForwarder = new PdfPTableEventForwarder();
            pdfPTableEventForwarder.addTableEvent(this.tableEvent);
            pdfPTableEventForwarder.addTableEvent(pdfPTableEvent);
            this.tableEvent = pdfPTableEventForwarder;
        }
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    float[][] getEventWidths(float f, int n, int n2, boolean bl) {
        if (bl) {
            n = Math.max(n, this.headerRows);
            n2 = Math.max(n2, this.headerRows);
        }
        float[][] fArrayArray = new float[(bl ? this.headerRows : 0) + n2 - n][];
        if (this.isColspan) {
            int n3 = 0;
            if (bl) {
                for (int i = 0; i < this.headerRows; ++i) {
                    PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
                    if (pdfPRow == null) {
                        ++n3;
                        continue;
                    }
                    fArrayArray[n3++] = pdfPRow.getEventWidth(f);
                }
            }
            while (n < n2) {
                PdfPRow pdfPRow = (PdfPRow)this.rows.get(n);
                if (pdfPRow == null) {
                    ++n3;
                } else {
                    fArrayArray[n3++] = pdfPRow.getEventWidth(f);
                }
                ++n;
            }
        } else {
            int n4;
            int n5 = this.getNumberOfColumns();
            float[] fArray = new float[n5 + 1];
            fArray[0] = f;
            for (n4 = 0; n4 < n5; ++n4) {
                fArray[n4 + 1] = fArray[n4] + this.absoluteWidths[n4];
            }
            for (n4 = 0; n4 < fArrayArray.length; ++n4) {
                fArrayArray[n4] = fArray;
            }
        }
        return fArrayArray;
    }

    public boolean isSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public boolean isSkipLastFooter() {
        return this.skipLastFooter;
    }

    public void setSkipFirstHeader(boolean bl) {
        this.skipFirstHeader = bl;
    }

    public void setSkipLastFooter(boolean bl) {
        this.skipLastFooter = bl;
    }

    public void setRunDirection(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.runDirection = n;
                break;
            }
            default: {
                throw new RuntimeException("Invalid run direction: " + n);
            }
        }
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public boolean isLockedWidth() {
        return this.lockedWidth;
    }

    public void setLockedWidth(boolean bl) {
        this.lockedWidth = bl;
    }

    public boolean isSplitRows() {
        return this.splitRows;
    }

    public void setSplitRows(boolean bl) {
        this.splitRows = bl;
    }

    public void setSpacingBefore(float f) {
        this.spacingBefore = f;
    }

    public void setSpacingAfter(float f) {
        this.spacingAfter = f;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public boolean isExtendLastRow() {
        return this.extendLastRow;
    }

    public void setExtendLastRow(boolean bl) {
        this.extendLastRow = bl;
    }

    public boolean isHeadersInEvent() {
        return this.headersInEvent;
    }

    public void setHeadersInEvent(boolean bl) {
        this.headersInEvent = bl;
    }

    public boolean isSplitLate() {
        return this.splitLate;
    }

    public void setSplitLate(boolean bl) {
        this.splitLate = bl;
    }

    public void setKeepTogether(boolean bl) {
        this.keepTogether = bl;
    }

    public boolean getKeepTogether() {
        return this.keepTogether;
    }

    public int getFooterRows() {
        return this.footerRows;
    }

    public void setFooterRows(int n) {
        if (n < 0) {
            n = 0;
        }
        this.footerRows = n;
    }

    public void completeRow() {
        while (!this.rowCompleted) {
            this.addCell(this.defaultCell);
        }
    }

    @Override
    public void flushContent() {
        this.deleteBodyRows();
        this.setSkipFirstHeader(true);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean bl) {
        this.complete = bl;
    }
}

