/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.datum.Ellipsoid;
import org.osgeo.proj4j.proj.CylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class ObliqueMercatorProjection
extends CylindricalProjection {
    private static final double TOL = 1.0E-7;
    private double lamc;
    private double lam1;
    private double phi1;
    private double lam2;
    private double phi2;
    private double Gamma;
    private double al;
    private double bl;
    private double el;
    private double singam;
    private double cosgam;
    private double sinrot;
    private double cosrot;
    private double u_0;
    private boolean ellips;
    private boolean rot;

    public ObliqueMercatorProjection() {
        this.ellipsoid = Ellipsoid.WGS84;
        this.projectionLatitude = Math.toRadians(0.0);
        this.projectionLongitude = Math.toRadians(0.0);
        this.minLongitude = Math.toRadians(-60.0);
        this.maxLongitude = Math.toRadians(60.0);
        this.minLatitude = Math.toRadians(-80.0);
        this.maxLatitude = Math.toRadians(80.0);
        this.alpha = Math.toRadians(-45.0);
        this.initialize();
    }

    public ObliqueMercatorProjection(Ellipsoid ellipsoid, double d, double d2, double d3, double d4, double d5, double d6) {
        this.setEllipsoid(ellipsoid);
        this.lamc = d;
        this.projectionLatitude = d2;
        this.alpha = d3;
        this.scaleFactor = d4;
        this.falseEasting = d5;
        this.falseNorthing = d6;
        this.initialize();
    }

    @Override
    public void initialize() {
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl;
        super.initialize();
        this.rot = true;
        this.lamc = this.lonc;
        boolean bl2 = bl = !Double.isNaN(this.alpha);
        if (bl) {
            if (Math.abs(this.alpha) <= 1.0E-7 || Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) <= 1.0E-7 || Math.abs(Math.abs(this.alpha) - 1.5707963267948966) <= 1.0E-7) {
                throw new ProjectionException("Obl 1");
            }
        } else if (Math.abs(this.phi1 - this.phi2) <= 1.0E-7 || (d4 = Math.abs(this.phi1)) <= 1.0E-7 || Math.abs(d4 - 1.5707963267948966) <= 1.0E-7 || Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) <= 1.0E-7 || Math.abs(Math.abs(this.phi2) - 1.5707963267948966) <= 1.0E-7) {
            throw new ProjectionException("Obl 2");
        }
        this.spherical = this.es == 0.0;
        double d5 = d3 = this.spherical ? 1.0 : Math.sqrt(this.one_es);
        if (Math.abs(this.projectionLatitude) > 1.0E-10) {
            double d6;
            double d7 = Math.sin(this.projectionLatitude);
            double d8 = Math.cos(this.projectionLatitude);
            if (!this.spherical) {
                d4 = 1.0 - this.es * d7 * d7;
                this.bl = d8 * d8;
                this.bl = Math.sqrt(1.0 + this.es * this.bl * this.bl / this.one_es);
                this.al = this.bl * this.scaleFactor * d3 / d4;
                d2 = this.bl * d3 / (d8 * Math.sqrt(d4));
            } else {
                this.bl = 1.0;
                this.al = this.scaleFactor;
                d2 = 1.0 / d8;
            }
            d = d2 * d2 - 1.0;
            if (d6 <= 0.0) {
                d = 0.0;
            } else {
                d = Math.sqrt(d);
                if (this.projectionLatitude < 0.0) {
                    d = -d;
                }
            }
            this.el = d += d2;
            this.el = !this.spherical ? (this.el *= Math.pow(ProjectionMath.tsfn(this.projectionLatitude, d7, this.e), this.bl)) : (this.el *= Math.tan(0.5 * (1.5707963267948966 - this.projectionLatitude)));
        } else {
            this.bl = 1.0 / d3;
            this.al = this.scaleFactor;
            d = 1.0;
            d2 = 1.0;
            this.el = 1.0;
        }
        if (bl) {
            this.Gamma = Math.asin(Math.sin(this.alpha) / d2);
            this.projectionLongitude = this.lamc - Math.asin(0.5 * (d - 1.0 / d) * Math.tan(this.Gamma)) / this.bl;
        } else {
            double d9;
            double d10;
            double d11;
            if (!this.spherical) {
                d11 = Math.pow(ProjectionMath.tsfn(this.phi1, Math.sin(this.phi1), this.e), this.bl);
                d10 = Math.pow(ProjectionMath.tsfn(this.phi2, Math.sin(this.phi2), this.e), this.bl);
            } else {
                d11 = Math.tan(0.5 * (1.5707963267948966 - this.phi1));
                d10 = Math.tan(0.5 * (1.5707963267948966 - this.phi2));
            }
            d = this.el / d11;
            double d12 = (d10 - d11) / (d10 + d11);
            double d13 = this.el * this.el;
            d13 = (d13 - d10 * d11) / (d13 + d10 * d11);
            d4 = this.lam1 - this.lam2;
            if (d9 < -Math.PI) {
                this.lam2 -= Math.PI * 2;
            } else if (d4 > Math.PI) {
                this.lam2 += Math.PI * 2;
            }
            this.projectionLongitude = ProjectionMath.normalizeLongitude(0.5 * (this.lam1 + this.lam2) - Math.atan(d13 * Math.tan(0.5 * this.bl * (this.lam1 - this.lam2)) / d12) / this.bl);
            this.Gamma = Math.atan(2.0 * Math.sin(this.bl * ProjectionMath.normalizeLongitude(this.lam1 - this.projectionLongitude)) / (d - 1.0 / d));
            this.alpha = Math.asin(d2 * Math.sin(this.Gamma));
        }
        this.singam = Math.sin(this.Gamma);
        this.cosgam = Math.cos(this.Gamma);
        d = this.alpha;
        this.sinrot = Math.sin(d);
        this.cosrot = Math.cos(d);
        this.u_0 = Math.abs(this.al * Math.atan(Math.sqrt(d2 * d2 - 1.0) / this.cosrot) / this.bl);
        if (this.projectionLatitude < 0.0) {
            this.u_0 = -this.u_0;
        }
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4;
        double d5 = Math.sin(this.bl * d);
        if (Math.abs(Math.abs(d2) - 1.5707963267948966) <= 1.0E-10) {
            d4 = d2 < 0.0 ? -this.singam : this.singam;
            d3 = this.al * d2 / this.bl;
        } else {
            double d6 = this.el / (!this.spherical ? Math.pow(ProjectionMath.tsfn(d2, Math.sin(d2), this.e), this.bl) : Math.tan(0.5 * (1.5707963267948966 - d2)));
            double d7 = 0.5 * (d6 - 1.0 / d6);
            d4 = 2.0 * (d7 * this.singam - d5 * this.cosgam) / (d6 + 1.0 / d6);
            double d8 = Math.cos(this.bl * d);
            if (Math.abs(d8) >= 1.0E-7) {
                d3 = this.al * Math.atan((d7 * this.cosgam + d5 * this.singam) / d8) / this.bl;
                if (d8 < 0.0) {
                    d3 += Math.PI * this.al / this.bl;
                }
            } else {
                d3 = this.al * this.bl * d;
            }
        }
        if (Math.abs(Math.abs(d4) - 1.0) <= 1.0E-10) {
            throw new ProjectionException("Obl 3");
        }
        double d9 = 0.5 * this.al * Math.log((1.0 - d4) / (1.0 + d4)) / this.bl;
        d3 -= this.u_0;
        if (!this.rot) {
            projCoordinate.x = d3;
            projCoordinate.y = d9;
        } else {
            projCoordinate.x = d9 * this.cosrot + d3 * this.sinrot;
            projCoordinate.y = d3 * this.cosrot - d9 * this.sinrot;
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4;
        if (!this.rot) {
            d4 = d;
            d3 = d2;
        } else {
            d3 = d * this.cosrot - d2 * this.sinrot;
            d4 = d2 * this.cosrot + d * this.sinrot;
        }
        double d5 = Math.exp(-this.bl * d3 / this.al);
        double d6 = 0.5 * (d5 - 1.0 / d5);
        double d7 = Math.sin(this.bl * (d4 += this.u_0) / this.al);
        double d8 = 2.0 * (d7 * this.cosgam + d6 * this.singam) / (d5 + 1.0 / d5);
        if (Math.abs(Math.abs(d8) - 1.0) < 1.0E-10) {
            projCoordinate.x = 0.0;
            projCoordinate.y = d8 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            projCoordinate.y = this.el / Math.sqrt((1.0 + d8) / (1.0 - d8));
            projCoordinate.y = !this.spherical ? ProjectionMath.phi2(Math.pow(projCoordinate.y, 1.0 / this.bl), this.e) : 1.5707963267948966 - 2.0 * Math.atan(projCoordinate.y);
            projCoordinate.x = -Math.atan2(d6 * this.cosgam - d7 * this.singam, Math.cos(this.bl * d4 / this.al)) / this.bl;
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Oblique Mercator";
    }
}

