/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class RectangularPolyconicProjection
extends Projection {
    private double phi0;
    private double phi1;
    private double fxa;
    private double fxb;
    private boolean mode;
    private static final double EPS = 1.0E-9;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = this.mode ? Math.tan(d * this.fxb) * this.fxa : 0.5 * d;
        if (Math.abs(d2) < 1.0E-9) {
            projCoordinate.x = d3 + d3;
            projCoordinate.y = -this.phi0;
        } else {
            projCoordinate.y = 1.0 / Math.tan(d2);
            d3 = 2.0 * Math.atan(d3 * Math.sin(d2));
            projCoordinate.x = Math.sin(d3) * projCoordinate.y;
            projCoordinate.y = d2 - this.phi0 + (1.0 - Math.cos(d3)) * projCoordinate.y;
        }
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public String toString() {
        return "Rectangular Polyconic";
    }
}

