/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class SinusoidalProjection
extends PseudoCylindricalProjection {
    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = d * Math.cos(d2);
        projCoordinate.y = d2;
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = d / Math.cos(d2);
        projCoordinate.y = d2;
        return projCoordinate;
    }

    public double getWidth(double d) {
        return ProjectionMath.normalizeLongitude(Math.PI) * Math.cos(d);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        return "Sinusoidal";
    }
}

