/*
 * Decompiled with CFR 0.152.
 */
package ambience.dsengine.datastore;

import com.elixirtech.data.JSONSerializers;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import java.io.IOException;
import java.io.Writer;

public class JSONDataStore
implements DataListener {
    private PushContext m_Context = new DefaultPushContext();
    private int m_Rows;
    private Writer m_Writer;

    public JSONDataStore(Writer writer) {
        this.m_Writer = writer;
    }

    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    public void startData(IDataSource iDataSource) {
        String string = JSONSerializers.schemaJsonString((DataSchema)iDataSource.getSchema());
        this.m_Rows = 0;
        try {
            this.m_Writer.append("{");
            this.m_Writer.append("\"schema\": " + string);
            this.m_Writer.append(",\n");
            this.m_Writer.append("\"data\": [");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error in startData: " + String.valueOf(iOException), iOException);
        }
    }

    public void startGroup(DataGroup dataGroup) {
    }

    public boolean processRecord(DataRecord dataRecord) {
        String string = JSONSerializers.dataRecordJsonString((DataRecord)dataRecord);
        ++this.m_Rows;
        try {
            if (this.m_Rows == 1) {
                this.m_Writer.append("\n ");
            } else {
                this.m_Writer.append(",\n ");
            }
            this.m_Writer.append(string);
            if (this.m_Rows % 1000 == 0) {
                return !this.m_Context.isAborted();
            }
            return true;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in processRecord: " + String.valueOf(exception), exception);
        }
    }

    public void endGroup(DataGroup dataGroup) {
    }

    public void endData(IDataSource iDataSource) {
        try {
            this.m_Writer.append("\n]\n");
            this.m_Writer.append("}");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error in endData: " + String.valueOf(iOException), iOException);
        }
    }
}

