/*
 * Decompiled with CFR 0.152.
 */
package ambience.rmlengine;

import ambience.api.Lifecycle;
import ambience.api.RMLEngine;
import ambience.api.ReportEngine;
import ambience.arch.Arch$;
import ambience.module.UserDB;
import ambience.queue.JobQueueStorage$;
import ambience.rml.AuthWrapper$;
import ambience.rmlengine.ActivityLogger$;
import ambience.rmlengine.RMLEngineModule$;
import ambience.rmlengine.TimeoutLogic$;
import ambience.rmlengine.local.RMLEngineRepository$;
import com.elixirtech.api.SchedulerAPI;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeInfo$;
import com.elixirtech.arch.Path$;
import com.elixirtech.arch.SyncDataBytes;
import com.elixirtech.arch.job.IJobLog;
import com.elixirtech.arch.job.IJobLogging;
import com.elixirtech.arch.job.JobEntry;
import com.elixirtech.arch.job.JobException$;
import com.elixirtech.arch.job.JobLog;
import com.elixirtech.arch.job.JobLogStorage$;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.arch.job.JobTimeout$;
import com.elixirtech.arch.job.NestedJobLogging;
import com.elixirtech.arch.util.ThrowableInfo$;
import com.elixirtech.coredata.JsonToString$;
import com.elixirtech.report2.ReportEngine$;
import com.elixirtech.report2.raw.model.RawReport;
import io.circe.Decoder$;
import io.circe.Json;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.concurrent.TimeoutException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class RMLEngineAPI
implements RMLEngine,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(RMLEngineAPI.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RMLEngineAPI.class.getDeclaredField("i18n$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object i18n$lzy1;

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ResourceBundle i18n() {
        Object object = this.i18n$lzy1;
        if (object instanceof ResourceBundle) {
            return (ResourceBundle)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ResourceBundle)this.i18n$lzyINIT1();
    }

    private Object i18n$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.i18n$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ResourceBundle resourceBundle = null;
                    try {
                        resourceBundle = ResourceBundle.getBundle("i18n/rml-engine");
                        object2 = resourceBundle == null ? LazyVals.NullValue$.MODULE$ : resourceBundle;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.i18n$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return resourceBundle;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Observable<ReportEngine.TemplatePath> getAvailableReports(UserDB.User user) {
        return RMLEngineRepository$.MODULE$.getRMLPaths(user);
    }

    public Task<Either<ReportEngine.Error, ReportEngine.Report>> buildResult(Document doc) {
        return JobQueueStorage$.MODULE$.bsonToReport(doc);
    }

    public Task<Either<ReportEngine.Error, ReportEngine.Report>> renderReport(UserDB.User user, ReportEngine.Request request) {
        Task task = ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).runJob(this.doRenderReport(user, request));
        return task.executeOn((Scheduler)RMLEngineModule$.MODULE$.io(), task.executeOn$default$2());
    }

    public Map<String, String> getParamsMap(ReportEngine.Request request) {
        return (Map)request.params().asObject().map((Function1 & Serializable)obj -> obj.toList().flatMap((Function1 & Serializable)kv -> JsonToString$.MODULE$.apply((Json)kv._2()).map((Function1 & Serializable)_$1 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$1);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse(RMLEngineAPI::getParamsMap$$anonfun$2);
    }

    public Map<String, String> getRenderDetailsMap(ReportEngine.Request request) {
        return (Map)request.renderDetails().asObject().map((Function1 & Serializable)obj -> obj.toList().flatMap((Function1 & Serializable)kv -> JsonToString$.MODULE$.apply((Json)kv._2()).map((Function1 & Serializable)_$2 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse(RMLEngineAPI::getRenderDetailsMap$$anonfun$2);
    }

    public Task<Either<ReportEngine.Error, ReportEngine.Report>> doRenderReport(UserDB.User user, ReportEngine.Request request) {
        Map<String, String> paramsMap = this.getParamsMap(request);
        Map<String, String> rdMap = this.getRenderDetailsMap(request);
        this.log().debug(() -> RMLEngineAPI.doRenderReport$$anonfun$1(user, request), Line$.MODULE$.apply(48), FullName$.MODULE$.apply("ambience.rmlengine.RMLEngineAPI.doRenderReport"));
        return Task$.MODULE$.apply(() -> RMLEngineAPI.doRenderReport$$anonfun$2(user, request)).flatMap((Function1 & Serializable)rawReport -> {
            NestedJobLogging logger = new NestedJobLogging(JobLogging$.MODULE$.getInstance(), "elx.RMLEngineAPI");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Task task = TimeoutLogic$.MODULE$.runWithTimeout(request.path(), (RawReport)rawReport, paramsMap, () -> RMLEngineAPI.$anonfun$1(logger, user, rawReport, request, baos, paramsMap, rdMap)).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> this.onError(request, (NestedJobLogging<BoxedUnit>)logger, (Throwable)ex));
            return task.map((Function1 & Serializable)_$3 -> this.handleResult(user, request, baos.toByteArray(), (NestedJobLogging<BoxedUnit>)logger));
        });
    }

    public Either<ReportEngine.Error, ReportEngine.Report> handleResult(UserDB.User user, ReportEngine.Request request, byte[] bytes, NestedJobLogging<BoxedUnit> logger) {
        JobLog jobLog = logger.getJobLog();
        Document jobLogDoc = JobLogStorage$.MODULE$.save((IJobLog)jobLog);
        SchedulerAPI.TriggerStatus status = jobLog.statusCode();
        this.logActivity(user, request, jobLogDoc);
        SchedulerAPI.TriggerStatus triggerStatus = status;
        SchedulerAPI.TriggerStatus triggerStatus2 = SchedulerAPI.TriggerStatus$.MODULE$.Completed();
        if (!(triggerStatus != null ? !triggerStatus.equals(triggerStatus2) : triggerStatus2 != null)) {
            String filename = this.getResultFilename(request);
            ReportEngine.ReportMetadata metadata = ReportEngine.ReportMetadata$.MODULE$.apply(filename, Int$.MODULE$.int2long(bytes.length), request.mimeType(), jobLogDoc);
            return package$.MODULE$.Right().apply((Object)ReportEngine.Report$.MODULE$.apply(metadata, (SyncDataBytes)FullDataBytes$.MODULE$.apply(bytes)));
        }
        String defaultMsg = status.value() + " " + status.name();
        String msg = (String)Try$.MODULE$.apply(() -> this.$anonfun$3(status)).toOption().getOrElse(() -> RMLEngineAPI.$anonfun$4(defaultMsg));
        return package$.MODULE$.Left().apply((Object)ReportEngine.Error$.MODULE$.apply(msg, jobLogDoc));
    }

    public String getResultFilename(ReportEngine.Request request) {
        String filename = (String)request.params().hcursor().downField("elx-filename").as(Decoder$.MODULE$.decodeString()).toOption().flatMap((Function1 & Serializable)s -> Arch$.MODULE$.opts(s)).getOrElse(() -> RMLEngineAPI.$anonfun$6(request));
        this.log().info(() -> RMLEngineAPI.getResultFilename$$anonfun$1(filename, request), Line$.MODULE$.apply(90), FullName$.MODULE$.apply("ambience.rmlengine.RMLEngineAPI.getResultFilename"));
        return Path$.MODULE$.apply(filename).withExtension(MimeInfo$.MODULE$.extension(request.mimeType())).name();
    }

    public void logActivity(UserDB.User user, ReportEngine.Request request, Document jobLogDoc) {
        ActivityLogger$.MODULE$.log(user, "render-rml", Path$.MODULE$.apply(request.path()), jobLogDoc).runAsyncAndForget(RMLEngineModule$.MODULE$.shortIO());
    }

    public void onError(ReportEngine.Request request, NestedJobLogging<BoxedUnit> logger, Throwable ex) {
        Throwable throwable = ex;
        if (throwable instanceof TimeoutException) {
            TimeoutException ex2 = (TimeoutException)throwable;
            this.log().error(() -> RMLEngineAPI.onError$$anonfun$1(request, ex2), Line$.MODULE$.apply(101), FullName$.MODULE$.apply("ambience.rmlengine.RMLEngineAPI.onError"));
            logger.error("elx.RMLEngineAPI", () -> RMLEngineAPI.onError$$anonfun$2(ex2));
            logger.add((JobEntry)JobTimeout$.MODULE$.apply(JobTimeout$.MODULE$.$lessinit$greater$default$1()));
            return;
        }
        Throwable ex3 = throwable;
        this.log().error(() -> RMLEngineAPI.onError$$anonfun$3(request, ex3), ex3, Line$.MODULE$.apply(105), FullName$.MODULE$.apply("ambience.rmlengine.RMLEngineAPI.onError"));
        logger.error("elx.RMLEngineAPI", () -> RMLEngineAPI.onError$$anonfun$4(ex3));
        logger.add((JobEntry)JobException$.MODULE$.apply(ThrowableInfo$.MODULE$.apply(ex3), JobException$.MODULE$.$lessinit$greater$default$2()));
    }

    private static final Map getParamsMap$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Map getRenderDetailsMap$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Object doRenderReport$$anonfun$1(UserDB.User user$1, ReportEngine.Request request$1) {
        return "doRenderReport(" + user$1.name() + "," + user$1.roles() + ") " + new ReportEngine.TemplatePath(request$1.path());
    }

    private static final RawReport doRenderReport$$anonfun$2$$anonfun$1(ReportEngine.Request request$3) {
        return ReportEngine$.MODULE$.getRawReport(request$3.path());
    }

    private static final RawReport doRenderReport$$anonfun$2(UserDB.User user$2, ReportEngine.Request request$2) {
        return (RawReport)AuthWrapper$.MODULE$.withUser(user$2, () -> RMLEngineAPI.doRenderReport$$anonfun$2$$anonfun$1(request$2));
    }

    private static final void $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(RawReport rawReport$4, ReportEngine.Request request$8, ByteArrayOutputStream baos$4, Map paramsMap$5, Map rdMap$5) {
        ReportEngine$.MODULE$.renderRMLWithExternalJobLog(rawReport$4, request$8.mimeType(), (OutputStream)baos$4, paramsMap$5, rdMap$5);
    }

    private static final void $anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$6, RawReport rawReport$3, ReportEngine.Request request$7, ByteArrayOutputStream baos$3, Map paramsMap$4, Map rdMap$4) {
        AuthWrapper$.MODULE$.withUser(user$6, (Function0 & Serializable)() -> {
            RMLEngineAPI.$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(rawReport$3, request$7, baos$3, paramsMap$4, rdMap$4);
            return BoxedUnit.UNIT;
        });
    }

    private static final void $anonfun$1$$anonfun$1(NestedJobLogging logger$2, UserDB.User user$5, RawReport rawReport$2, ReportEngine.Request request$6, ByteArrayOutputStream baos$2, Map paramsMap$3, Map rdMap$3) {
        JobLogging$.MODULE$.run((IJobLogging)logger$2, (Function0 & Serializable)() -> {
            RMLEngineAPI.$anonfun$1$$anonfun$1$$anonfun$1(user$5, rawReport$2, request$6, baos$2, paramsMap$3, rdMap$3);
            return BoxedUnit.UNIT;
        });
    }

    private static final Task $anonfun$1(NestedJobLogging logger$1, UserDB.User user$4, RawReport rawReport$1, ReportEngine.Request request$5, ByteArrayOutputStream baos$1, Map paramsMap$2, Map rdMap$2) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            RMLEngineAPI.$anonfun$1$$anonfun$1(logger$1, user$4, rawReport$1, request$5, baos$1, paramsMap$2, rdMap$2);
            return BoxedUnit.UNIT;
        });
    }

    private final String $anonfun$3(SchedulerAPI.TriggerStatus status$1) {
        return this.i18n().getString("TriggerStatus." + status$1.value());
    }

    private static final String $anonfun$4(String defaultMsg$1) {
        return defaultMsg$1;
    }

    private static final String $anonfun$6(ReportEngine.Request request$11) {
        return request$11.path();
    }

    private static final Object getResultFilename$$anonfun$1(String filename$1, ReportEngine.Request request$12) {
        return "getResultFilename = " + filename$1 + " from " + request$12.params().noSpaces();
    }

    private static final Object onError$$anonfun$1(ReportEngine.Request request$13, TimeoutException ex$1) {
        return "Timeout Error rendering report " + request$13.path() + ": " + ex$1;
    }

    private static final String onError$$anonfun$2(TimeoutException ex$2) {
        return "Timeout error rendering report. Monitor " + ex$2.getMessage();
    }

    private static final Object onError$$anonfun$3(ReportEngine.Request request$14, Throwable ex$3) {
        return "Error rendering report " + request$14.path() + ": " + ex$3;
    }

    private static final String onError$$anonfun$4(Throwable ex$4) {
        return ex$4.toString();
    }
}

