/*
 * Decompiled with CFR 0.152.
 */
package ambience.rmlengine.queue;

import ambience.api.Notifications;
import ambience.api.RMLEngine;
import ambience.api.ReportEngine;
import ambience.etl.BsonToJson$;
import ambience.module.UserDB;
import ambience.module.UserDB$;
import ambience.queue.JobQueueStorage$;
import ambience.queue.JobRunner;
import ambience.report.ReportUtils$;
import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.implicits$;
import cats.syntax.OptionIdOps$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeType$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.parser.package$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class RMLJobRunner
implements JobRunner,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RMLJobRunner.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final RMLEngine rmlEngine;
    private final UserDB users;
    private final Notifications.Source source;

    public RMLJobRunner(RMLEngine rmlEngine, UserDB users) {
        this.rmlEngine = rmlEngine;
        this.users = users;
        this.source = Notifications.Source$.MODULE$.apply("report-portal");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Notifications.Source source() {
        return this.source;
    }

    public Task<Document> run(Document req) {
        MimeType mimeType = this.getMimeType(req);
        Json params = this.getParams(req);
        Json renderDetails = this.getRenderDetails(req);
        boolean isRunAfter = req.get("runAfter", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).isDefined();
        OptionT reply = this.loadUser(req).flatMap((Function1 & Serializable)user -> this.loadRML(req).flatMap((Function1 & Serializable)rml -> this.$anonfun$1$$anonfun$1(mimeType, params, renderDetails, (UserDB.User)user, isRunAfter, rml == null ? null : ((ReportEngine.TemplatePath)rml).value()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return ((Task)reply.value()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Either either = (Either)((Some)option).value();
                if (either instanceof Right) {
                    ReportEngine.Report report = (ReportEngine.Report)((Right)either).value();
                    return JobQueueStorage$.MODULE$.reportToBson(report);
                }
                if (either instanceof Left) {
                    ReportEngine.Error err = (ReportEngine.Error)((Left)either).value();
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(err.value())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    return Task$.MODULE$.now((Object)Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                }
            }
            if (None$.MODULE$.equals(option)) {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply("Can't decode request")), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return Task$.MODULE$.now((Object)Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            throw new MatchError((Object)option);
        });
    }

    public OptionT<Task, UserDB.User> loadUser(Document req) {
        Option option = req.get("user", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
        if (option instanceof Some) {
            BsonString s = (BsonString)((Some)option).value();
            return OptionT$.MODULE$.apply((Object)UserDB$.MODULE$.filterEnabled(this.users.getUserById(s.getValue())));
        }
        if (None$.MODULE$.equals(option)) {
            return OptionT$.MODULE$.none((Applicative)Task$.MODULE$.catsAsync());
        }
        throw new MatchError((Object)option);
    }

    public OptionT<Task, ReportEngine.TemplatePath> loadRML(Document req) {
        return OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)req.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> new ReportEngine.TemplatePath(ReportEngine.TemplatePath$.MODULE$.apply(s.getValue())))));
    }

    public MimeType getMimeType(Document req) {
        return MimeType$.MODULE$.apply((String)req.get("mimeType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).getOrElse(RMLJobRunner::getMimeType$$anonfun$2));
    }

    public Json getParams(Document req) {
        Option option = req.get("parameters", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonDocument) {
                BsonDocument doc = (BsonDocument)bsonValue;
                return (Json)BsonToJson$.MODULE$.apply(doc).getOrElse(RMLJobRunner::getParams$$anonfun$1);
            }
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                return (Json)package$.MODULE$.parse(bs.getValue()).getOrElse(RMLJobRunner::getParams$$anonfun$2);
            }
        }
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public Json getRenderDetails(Document req) {
        return (Json)req.get("renderDetails", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).flatMap((Function1 & Serializable)_$4 -> BsonToJson$.MODULE$.apply(_$4)).getOrElse(RMLJobRunner::getRenderDetails$$anonfun$2);
    }

    public Task<BoxedUnit> notifyReportPortal(UserDB.User user, ReportEngine.Request request, Either<ReportEngine.Error, ReportEngine.Report> result) {
        return ReportUtils$.MODULE$.storeResult(user, request.path(), result).flatMap((Function1 & Serializable)eContentId -> ReportUtils$.MODULE$.notifyResult(user, this.source(), request.path(), result, eContentId).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        })).void();
    }

    private static final Option $anonfun$1$$anonfun$1$$anonfun$1(String rml$1, MimeType mimeType$2, Json params$2, Json renderDetails$2) {
        return Option$.MODULE$.apply((Object)ReportEngine.Request$.MODULE$.apply(rml$1, mimeType$2, params$2, renderDetails$2));
    }

    private final /* synthetic */ OptionT $anonfun$1$$anonfun$1(MimeType mimeType$3, Json params$3, Json renderDetails$3, UserDB.User user$1, boolean isRunAfter$2, String rml) {
        return OptionT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> RMLJobRunner.$anonfun$1$$anonfun$1$$anonfun$1(rml, mimeType$3, params$3, renderDetails$3))).flatMap((Function1 & Serializable)request -> OptionT$.MODULE$.apply((Object)this.rmlEngine.renderReport(user$1, request).map((Function1 & Serializable)_$1 -> {
            Either either = (Either)implicits$.MODULE$.catsSyntaxOptionId(_$1);
            return OptionIdOps$.MODULE$.some$extension((Object)either);
        })).flatMap((Function1 & Serializable)reply -> OptionT$.MODULE$.apply((Object)(isRunAfter$2 ? this.notifyReportPortal(user$1, (ReportEngine.Request)request, (Either<ReportEngine.Error, ReportEngine.Report>)reply) : Task$.MODULE$.unit()).map((Function1 & Serializable)_$2 -> Option$.MODULE$.apply(_$2))).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return reply;
        }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
    }

    private static final String getMimeType$$anonfun$2() {
        return "application/pdf";
    }

    private static final Json getParams$$anonfun$1() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final Json getParams$$anonfun$2() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final Json getRenderDetails$$anonfun$2() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

