/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class RichInputStream {
    private final InputStream is;

    public RichInputStream(InputStream is) {
        this.is = is;
    }

    public InputStream is() {
        return this.is;
    }

    public InputStreamReader utf8() {
        return new InputStreamReader(this.is(), StandardCharsets.UTF_8);
    }

    public InputStreamReader reader(String enc) {
        return new InputStreamReader(this.is(), enc);
    }

    public BufferedInputStream buffered() {
        return new BufferedInputStream(this.is());
    }

    public BufferedInputStream buffered(int sz) {
        return new BufferedInputStream(this.is(), sz);
    }

    public DataInputStream data() {
        return new DataInputStream(this.is());
    }

    public void copyTo(OutputStream os) {
        this.is().transferTo(os);
    }

    public byte[] contents() {
        return this.is().readAllBytes();
    }

    public String text() {
        return new String(this.contents(), StandardCharsets.UTF_8);
    }

    public void empty() {
        this.empty(new byte[10240]);
    }

    private void empty(byte[] buff) {
        while (this.is().read(buff) >= 0) {
        }
    }
}

